/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.payment.model.RawSupplierContract;
import travel.wink.sdk.payment.model.StripeCardholder;

@JsonPropertyOrder(value={"acquirerIdentifier", "affiliateAccountIdentifier", "affiliateAccountIdentifierType", "displayCurrency", "sourceUrl", "traceId", "contract", "cardholder", "stripeCustomerIdentifier", "stripePaymentMethodIdentifier", "stripePaymentIntentIdentifier"})
public class CreateStripeSaleRequest {
    public static final String JSON_PROPERTY_ACQUIRER_IDENTIFIER = "acquirerIdentifier";
    private String acquirerIdentifier;
    public static final String JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER = "affiliateAccountIdentifier";
    private UUID affiliateAccountIdentifier;
    public static final String JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER_TYPE = "affiliateAccountIdentifierType";
    private AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType;
    public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
    private String displayCurrency = "USD";
    public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
    private String sourceUrl;
    public static final String JSON_PROPERTY_TRACE_ID = "traceId";
    private String traceId;
    public static final String JSON_PROPERTY_CONTRACT = "contract";
    private RawSupplierContract contract;
    public static final String JSON_PROPERTY_CARDHOLDER = "cardholder";
    private StripeCardholder cardholder;
    public static final String JSON_PROPERTY_STRIPE_CUSTOMER_IDENTIFIER = "stripeCustomerIdentifier";
    private String stripeCustomerIdentifier;
    public static final String JSON_PROPERTY_STRIPE_PAYMENT_METHOD_IDENTIFIER = "stripePaymentMethodIdentifier";
    private String stripePaymentMethodIdentifier;
    public static final String JSON_PROPERTY_STRIPE_PAYMENT_INTENT_IDENTIFIER = "stripePaymentIntentIdentifier";
    private String stripePaymentIntentIdentifier;

    public CreateStripeSaleRequest acquirerIdentifier(String acquirerIdentifier) {
        this.acquirerIdentifier = acquirerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="stripe-acquirer-1", required=true, value="Stripe's acquirer coverage record")
    @JsonProperty(value="acquirerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAcquirerIdentifier() {
        return this.acquirerIdentifier;
    }

    @JsonProperty(value="acquirerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAcquirerIdentifier(String acquirerIdentifier) {
        this.acquirerIdentifier = acquirerIdentifier;
    }

    public CreateStripeSaleRequest affiliateAccountIdentifier(UUID affiliateAccountIdentifier) {
        this.affiliateAccountIdentifier = affiliateAccountIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="affiliate account making the request")
    @JsonProperty(value="affiliateAccountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getAffiliateAccountIdentifier() {
        return this.affiliateAccountIdentifier;
    }

    @JsonProperty(value="affiliateAccountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAffiliateAccountIdentifier(UUID affiliateAccountIdentifier) {
        this.affiliateAccountIdentifier = affiliateAccountIdentifier;
    }

    public CreateStripeSaleRequest affiliateAccountIdentifierType(AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType) {
        this.affiliateAccountIdentifierType = affiliateAccountIdentifierType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Type of identifier this is")
    @JsonProperty(value="affiliateAccountIdentifierType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AffiliateAccountIdentifierTypeEnum getAffiliateAccountIdentifierType() {
        return this.affiliateAccountIdentifierType;
    }

    @JsonProperty(value="affiliateAccountIdentifierType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAffiliateAccountIdentifierType(AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType) {
        this.affiliateAccountIdentifierType = affiliateAccountIdentifierType;
    }

    public CreateStripeSaleRequest displayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="USD", required=true, value="The desired quote")
    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDisplayCurrency() {
        return this.displayCurrency;
    }

    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
    }

    public CreateStripeSaleRequest sourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="https://www.traveliko.com", required=true, value="Where did the booking occur")
    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public CreateStripeSaleRequest traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="integrator-booking-code-1", value="Integrator can choose to include a unique identifier to help identify the collection of bookings")
    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTraceId() {
        return this.traceId;
    }

    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public CreateStripeSaleRequest contract(RawSupplierContract contract) {
        this.contract = contract;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="contract")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RawSupplierContract getContract() {
        return this.contract;
    }

    @JsonProperty(value="contract")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContract(RawSupplierContract contract) {
        this.contract = contract;
    }

    public CreateStripeSaleRequest cardholder(StripeCardholder cardholder) {
        this.cardholder = cardholder;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="cardholder")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StripeCardholder getCardholder() {
        return this.cardholder;
    }

    @JsonProperty(value="cardholder")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCardholder(StripeCardholder cardholder) {
        this.cardholder = cardholder;
    }

    public CreateStripeSaleRequest stripeCustomerIdentifier(String stripeCustomerIdentifier) {
        this.stripeCustomerIdentifier = stripeCustomerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="stripe-customer-1", required=true, value="Vendor, like Stripe, will create a customer identifier to refer to this customer on their end.")
    @JsonProperty(value="stripeCustomerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getStripeCustomerIdentifier() {
        return this.stripeCustomerIdentifier;
    }

    @JsonProperty(value="stripeCustomerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStripeCustomerIdentifier(String stripeCustomerIdentifier) {
        this.stripeCustomerIdentifier = stripeCustomerIdentifier;
    }

    public CreateStripeSaleRequest stripePaymentMethodIdentifier(String stripePaymentMethodIdentifier) {
        this.stripePaymentMethodIdentifier = stripePaymentMethodIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="pm_1JeACpACqvQog7R1zoLeqPwv", required=true, value="Reference to payment method that was used to pay. Can be re-used to make an offline payment.")
    @JsonProperty(value="stripePaymentMethodIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getStripePaymentMethodIdentifier() {
        return this.stripePaymentMethodIdentifier;
    }

    @JsonProperty(value="stripePaymentMethodIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStripePaymentMethodIdentifier(String stripePaymentMethodIdentifier) {
        this.stripePaymentMethodIdentifier = stripePaymentMethodIdentifier;
    }

    public CreateStripeSaleRequest stripePaymentIntentIdentifier(String stripePaymentIntentIdentifier) {
        this.stripePaymentIntentIdentifier = stripePaymentIntentIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="pi_3JeAC8ACqvQog7R10yG09pPm", required=true, value="Reference to payment intent that charged the card.")
    @JsonProperty(value="stripePaymentIntentIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getStripePaymentIntentIdentifier() {
        return this.stripePaymentIntentIdentifier;
    }

    @JsonProperty(value="stripePaymentIntentIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStripePaymentIntentIdentifier(String stripePaymentIntentIdentifier) {
        this.stripePaymentIntentIdentifier = stripePaymentIntentIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateStripeSaleRequest createStripeSaleRequest = (CreateStripeSaleRequest)o;
        return Objects.equals(this.acquirerIdentifier, createStripeSaleRequest.acquirerIdentifier) && Objects.equals(this.affiliateAccountIdentifier, createStripeSaleRequest.affiliateAccountIdentifier) && Objects.equals((Object)this.affiliateAccountIdentifierType, (Object)createStripeSaleRequest.affiliateAccountIdentifierType) && Objects.equals(this.displayCurrency, createStripeSaleRequest.displayCurrency) && Objects.equals(this.sourceUrl, createStripeSaleRequest.sourceUrl) && Objects.equals(this.traceId, createStripeSaleRequest.traceId) && Objects.equals(this.contract, createStripeSaleRequest.contract) && Objects.equals(this.cardholder, createStripeSaleRequest.cardholder) && Objects.equals(this.stripeCustomerIdentifier, createStripeSaleRequest.stripeCustomerIdentifier) && Objects.equals(this.stripePaymentMethodIdentifier, createStripeSaleRequest.stripePaymentMethodIdentifier) && Objects.equals(this.stripePaymentIntentIdentifier, createStripeSaleRequest.stripePaymentIntentIdentifier);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acquirerIdentifier, this.affiliateAccountIdentifier, this.affiliateAccountIdentifierType, this.displayCurrency, this.sourceUrl, this.traceId, this.contract, this.cardholder, this.stripeCustomerIdentifier, this.stripePaymentMethodIdentifier, this.stripePaymentIntentIdentifier});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateStripeSaleRequest {\n");
        sb.append("    acquirerIdentifier: ").append(this.toIndentedString(this.acquirerIdentifier)).append("\n");
        sb.append("    affiliateAccountIdentifier: ").append(this.toIndentedString(this.affiliateAccountIdentifier)).append("\n");
        sb.append("    affiliateAccountIdentifierType: ").append(this.toIndentedString((Object)this.affiliateAccountIdentifierType)).append("\n");
        sb.append("    displayCurrency: ").append(this.toIndentedString(this.displayCurrency)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    traceId: ").append(this.toIndentedString(this.traceId)).append("\n");
        sb.append("    contract: ").append(this.toIndentedString(this.contract)).append("\n");
        sb.append("    cardholder: ").append(this.toIndentedString(this.cardholder)).append("\n");
        sb.append("    stripeCustomerIdentifier: ").append(this.toIndentedString(this.stripeCustomerIdentifier)).append("\n");
        sb.append("    stripePaymentMethodIdentifier: ").append(this.toIndentedString(this.stripePaymentMethodIdentifier)).append("\n");
        sb.append("    stripePaymentIntentIdentifier: ").append(this.toIndentedString(this.stripePaymentIntentIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AffiliateAccountIdentifierTypeEnum {
        INTERNAL("INTERNAL"),
        EXTERNAL("EXTERNAL");

        private String value;

        private AffiliateAccountIdentifierTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AffiliateAccountIdentifierTypeEnum fromValue(String value) {
            for (AffiliateAccountIdentifierTypeEnum b : AffiliateAccountIdentifierTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

