package travel.wink.sdk.payment.api;

import travel.wink.sdk.payment.invoker.ApiClient;

import travel.wink.sdk.payment.model.BookingContractResponse;
import travel.wink.sdk.payment.model.CreateNmiSaleRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-06T15:31:16.117259+07:00[Asia/Bangkok]")
public class NmiApi {
    private ApiClient apiClient;

    public NmiApi() {
        this(new ApiClient());
    }

    @Autowired
    public NmiApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create NMI Sale
     * Attempt an immediate sale with NMI as acquirer.
     * <p><b>201</b> - Created
     * @param createNmiSaleRequest The createNmiSaleRequest parameter
     * @return BookingContractResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createNmiSaleRequestCreation(CreateNmiSaleRequest createNmiSaleRequest) throws WebClientResponseException {
        Object postBody = createNmiSaleRequest;
        // verify the required parameter 'createNmiSaleRequest' is set
        if (createNmiSaleRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createNmiSaleRequest' when calling createNmiSale", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<BookingContractResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractResponse>() {};
        return apiClient.invokeAPI("/api/payment/nmi/sale", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create NMI Sale
     * Attempt an immediate sale with NMI as acquirer.
     * <p><b>201</b> - Created
     * @param createNmiSaleRequest The createNmiSaleRequest parameter
     * @return BookingContractResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingContractResponse> createNmiSale(CreateNmiSaleRequest createNmiSaleRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractResponse>() {};
        return createNmiSaleRequestCreation(createNmiSaleRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BookingContractResponse>> createNmiSaleWithHttpInfo(CreateNmiSaleRequest createNmiSaleRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractResponse>() {};
        return createNmiSaleRequestCreation(createNmiSaleRequest).toEntity(localVarReturnType);
    }
}
