/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [TripPay Acquiring](/payment-acquiring): All APIs related to how our Web Components work. - [TripPay](/payment): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 21.14.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.payment.model.AcquirerCredentials;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Payment method with the details describing how to make a payment happen
 */
@ApiModel(description = "Payment method with the details describing how to make a payment happen")
@JsonPropertyOrder({
  UpsertAccountAcquirerRequest.JSON_PROPERTY_PRIORITY,
  UpsertAccountAcquirerRequest.JSON_PROPERTY_VENDOR,
  UpsertAccountAcquirerRequest.JSON_PROPERTY_TYPE,
  UpsertAccountAcquirerRequest.JSON_PROPERTY_CURRENCY_CODE,
  UpsertAccountAcquirerRequest.JSON_PROPERTY_CREDENTIALS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-06T15:31:16.117259+07:00[Asia/Bangkok]")
public class UpsertAccountAcquirerRequest {
  public static final String JSON_PROPERTY_PRIORITY = "priority";
  private Integer priority;

  /**
   * Name of acquiring vendor
   */
  public enum VendorEnum {
    STRIPE("STRIPE"),
    
    YAPILY("YAPILY"),
    
    PAY_PAL("PAY_PAL"),
    
    NMI("NMI"),
    
    AGENT("AGENT");

    private String value;

    VendorEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static VendorEnum fromValue(String value) {
      for (VendorEnum b : VendorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_VENDOR = "vendor";
  private VendorEnum vendor;

  /**
   * Technology taking the charge
   */
  public enum TypeEnum {
    CREDIT_CARD("CREDIT_CARD"),
    
    BANK_TRANSFER("BANK_TRANSFER"),
    
    PAY_PAL("PAY_PAL"),
    
    CRYPTO("CRYPTO"),
    
    AGENT("AGENT"),
    
    CASH("CASH");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode;

  public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
  private List<AcquirerCredentials> credentials = new ArrayList<>();

  public UpsertAccountAcquirerRequest() { 
  }

  public UpsertAccountAcquirerRequest priority(Integer priority) {
    
    this.priority = priority;
    return this;
  }

   /**
   * Determines how vendors are displayed in a list
   * @return priority
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "Determines how vendors are displayed in a list")
  @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getPriority() {
    return priority;
  }


  @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPriority(Integer priority) {
    this.priority = priority;
  }


  public UpsertAccountAcquirerRequest vendor(VendorEnum vendor) {
    
    this.vendor = vendor;
    return this;
  }

   /**
   * Name of acquiring vendor
   * @return vendor
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "STRIPE", required = true, value = "Name of acquiring vendor")
  @JsonProperty(JSON_PROPERTY_VENDOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public VendorEnum getVendor() {
    return vendor;
  }


  @JsonProperty(JSON_PROPERTY_VENDOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVendor(VendorEnum vendor) {
    this.vendor = vendor;
  }


  public UpsertAccountAcquirerRequest type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Technology taking the charge
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "CREDIT_CARD", required = true, value = "Technology taking the charge")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public UpsertAccountAcquirerRequest currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Currency in coverage region.
   * @return currencyCode
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "GBP", required = true, value = "Currency in coverage region.")
  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }


  public UpsertAccountAcquirerRequest credentials(List<AcquirerCredentials> credentials) {
    
    this.credentials = credentials;
    return this;
  }

  public UpsertAccountAcquirerRequest addCredentialsItem(AcquirerCredentials credentialsItem) {
    this.credentials.add(credentialsItem);
    return this;
  }

   /**
   * Get credentials
   * @return credentials
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CREDENTIALS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<AcquirerCredentials> getCredentials() {
    return credentials;
  }


  @JsonProperty(JSON_PROPERTY_CREDENTIALS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCredentials(List<AcquirerCredentials> credentials) {
    this.credentials = credentials;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpsertAccountAcquirerRequest upsertAccountAcquirerRequest = (UpsertAccountAcquirerRequest) o;
    return Objects.equals(this.priority, upsertAccountAcquirerRequest.priority) &&
        Objects.equals(this.vendor, upsertAccountAcquirerRequest.vendor) &&
        Objects.equals(this.type, upsertAccountAcquirerRequest.type) &&
        Objects.equals(this.currencyCode, upsertAccountAcquirerRequest.currencyCode) &&
        Objects.equals(this.credentials, upsertAccountAcquirerRequest.credentials);
  }

  @Override
  public int hashCode() {
    return Objects.hash(priority, vendor, type, currencyCode, credentials);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpsertAccountAcquirerRequest {\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    vendor: ").append(toIndentedString(vendor)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

