/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.payment.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.payment.invoker.ApiClient;
import travel.wink.sdk.payment.model.CreateMappingRequest;
import travel.wink.sdk.payment.model.Mapping;
import travel.wink.sdk.payment.model.UpdateMappingRequest;

public class MappingApi {
    private ApiClient apiClient;

    public MappingApi() {
        this(new ApiClient());
    }

    @Autowired
    public MappingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createMappingRequestCreation(CreateMappingRequest createMappingRequest) throws WebClientResponseException {
        CreateMappingRequest postBody = createMappingRequest;
        if (createMappingRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createMappingRequest' when calling createMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/vnd.platform-v1+json", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.apiClient.invokeAPI("/api/mapping", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Mapping> createMapping(CreateMappingRequest createMappingRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.createMappingRequestCreation(createMappingRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Mapping>> createMappingWithHttpInfo(CreateMappingRequest createMappingRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.createMappingRequestCreation(createMappingRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec loadMappingRequestCreation(String id, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling loadMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/vnd.platform-v1+json", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.apiClient.invokeAPI("/api/mapping/{id}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Mapping> loadMapping(String id, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.loadMappingRequestCreation(id, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Mapping>> loadMappingWithHttpInfo(String id, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.loadMappingRequestCreation(id, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec loadMappingByExternalIdentifierRequestCreation(String id, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling loadMappingByExternalIdentifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/vnd.platform-v1+json", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.apiClient.invokeAPI("/api/mapping/external/{id}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Mapping> loadMappingByExternalIdentifier(String id, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.loadMappingByExternalIdentifierRequestCreation(id, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Mapping>> loadMappingByExternalIdentifierWithHttpInfo(String id, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.loadMappingByExternalIdentifierRequestCreation(id, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec loadMappingsRequestCreation(String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/vnd.platform-v1+json", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.apiClient.invokeAPI("/api/mapping/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Mapping> loadMappings(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.loadMappingsRequestCreation(accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Mapping>>> loadMappingsWithHttpInfo(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.loadMappingsRequestCreation(accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removeMappingRequestCreation(String id, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/vnd.platform-v1+json", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.apiClient.invokeAPI("/api/mapping/{id}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Mapping> removeMapping(String id, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.removeMappingRequestCreation(id, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Mapping>> removeMappingWithHttpInfo(String id, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.removeMappingRequestCreation(id, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removeMappingByExternalIdentifierRequestCreation(String id, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeMappingByExternalIdentifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/vnd.platform-v1+json", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.apiClient.invokeAPI("/api/mapping/external/{id}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Mapping> removeMappingByExternalIdentifier(String id, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.removeMappingByExternalIdentifierRequestCreation(id, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Mapping>> removeMappingByExternalIdentifierWithHttpInfo(String id, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.removeMappingByExternalIdentifierRequestCreation(id, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateMappingRequestCreation(String id, UpdateMappingRequest updateMappingRequest) throws WebClientResponseException {
        UpdateMappingRequest postBody = updateMappingRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (updateMappingRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateMappingRequest' when calling updateMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/vnd.platform-v1+json", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.apiClient.invokeAPI("/api/mapping/{id}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Mapping> updateMapping(String id, UpdateMappingRequest updateMappingRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.updateMappingRequestCreation(id, updateMappingRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Mapping>> updateMappingWithHttpInfo(String id, UpdateMappingRequest updateMappingRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.updateMappingRequestCreation(id, updateMappingRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateMappingByExternalIdentifierRequestCreation(String id, UpdateMappingRequest updateMappingRequest) throws WebClientResponseException {
        UpdateMappingRequest postBody = updateMappingRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateMappingByExternalIdentifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (updateMappingRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateMappingRequest' when calling updateMappingByExternalIdentifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/vnd.platform-v1+json", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.apiClient.invokeAPI("/api/mapping/external/{id}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Mapping> updateMappingByExternalIdentifier(String id, UpdateMappingRequest updateMappingRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.updateMappingByExternalIdentifierRequestCreation(id, updateMappingRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Mapping>> updateMappingByExternalIdentifierWithHttpInfo(String id, UpdateMappingRequest updateMappingRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.updateMappingByExternalIdentifierRequestCreation(id, updateMappingRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

