/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.payment.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.payment.invoker.ApiClient;
import travel.wink.sdk.payment.model.BookingContractResponse;
import travel.wink.sdk.payment.model.CreatePaymentIntentRequest;
import travel.wink.sdk.payment.model.CreatePaymentIntentResponse;
import travel.wink.sdk.payment.model.CreateStripeSaleRequest;
import travel.wink.sdk.payment.model.CustomerPaymentMethodsResponse;

public class StripeApi {
    private ApiClient apiClient;

    public StripeApi() {
        this(new ApiClient());
    }

    @Autowired
    public StripeApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec captureSaleRequestCreation(CreateStripeSaleRequest createStripeSaleRequest) throws WebClientResponseException {
        CreateStripeSaleRequest postBody = createStripeSaleRequest;
        if (createStripeSaleRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createStripeSaleRequest' when calling captureSale", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/vnd.platform-v1+json", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<BookingContractResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractResponse>(){};
        return this.apiClient.invokeAPI("/api/payment/stripe/sale", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingContractResponse> captureSale(CreateStripeSaleRequest createStripeSaleRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractResponse>(){};
        return this.captureSaleRequestCreation(createStripeSaleRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingContractResponse>> captureSaleWithHttpInfo(CreateStripeSaleRequest createStripeSaleRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractResponse>(){};
        return this.captureSaleRequestCreation(createStripeSaleRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec createPaymentIntentRequestCreation(CreatePaymentIntentRequest createPaymentIntentRequest) throws WebClientResponseException {
        CreatePaymentIntentRequest postBody = createPaymentIntentRequest;
        if (createPaymentIntentRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createPaymentIntentRequest' when calling createPaymentIntent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/vnd.platform-v1+json", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<CreatePaymentIntentResponse> localVarReturnType = new ParameterizedTypeReference<CreatePaymentIntentResponse>(){};
        return this.apiClient.invokeAPI("/api/payment/stripe/payment/intent", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CreatePaymentIntentResponse> createPaymentIntent(CreatePaymentIntentRequest createPaymentIntentRequest) throws WebClientResponseException {
        ParameterizedTypeReference<CreatePaymentIntentResponse> localVarReturnType = new ParameterizedTypeReference<CreatePaymentIntentResponse>(){};
        return this.createPaymentIntentRequestCreation(createPaymentIntentRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CreatePaymentIntentResponse>> createPaymentIntentWithHttpInfo(CreatePaymentIntentRequest createPaymentIntentRequest) throws WebClientResponseException {
        ParameterizedTypeReference<CreatePaymentIntentResponse> localVarReturnType = new ParameterizedTypeReference<CreatePaymentIntentResponse>(){};
        return this.createPaymentIntentRequestCreation(createPaymentIntentRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showCustomerPaymentMethodsRequestCreation(String acquirerId, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (acquirerId == null) {
            throw new WebClientResponseException("Missing the required parameter 'acquirerId' when calling showCustomerPaymentMethods", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "acquirerId", acquirerId));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/vnd.platform-v1+json", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<CustomerPaymentMethodsResponse> localVarReturnType = new ParameterizedTypeReference<CustomerPaymentMethodsResponse>(){};
        return this.apiClient.invokeAPI("/api/payment/stripe/payment/method/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CustomerPaymentMethodsResponse> showCustomerPaymentMethods(String acquirerId, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CustomerPaymentMethodsResponse> localVarReturnType = new ParameterizedTypeReference<CustomerPaymentMethodsResponse>(){};
        return this.showCustomerPaymentMethodsRequestCreation(acquirerId, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CustomerPaymentMethodsResponse>> showCustomerPaymentMethodsWithHttpInfo(String acquirerId, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CustomerPaymentMethodsResponse> localVarReturnType = new ParameterizedTypeReference<CustomerPaymentMethodsResponse>(){};
        return this.showCustomerPaymentMethodsRequestCreation(acquirerId, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

