/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"cancellerType", "type", "reason"})
public class CancelBookingContractRequest {
    public static final String JSON_PROPERTY_CANCELLER_TYPE = "cancellerType";
    private CancellerTypeEnum cancellerType;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_REASON = "reason";
    private String reason;

    public CancelBookingContractRequest cancellerType(CancellerTypeEnum cancellerType) {
        this.cancellerType = cancellerType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="SUPPLIER", required=true, value="Who is doing the cancellation")
    @JsonProperty(value="cancellerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CancellerTypeEnum getCancellerType() {
        return this.cancellerType;
    }

    @JsonProperty(value="cancellerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCancellerType(CancellerTypeEnum cancellerType) {
        this.cancellerType = cancellerType;
    }

    public CancelBookingContractRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="NO_SHOW", required=true, value="Type of cancellation")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CancelBookingContractRequest reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Reason for cancellation")
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReason(String reason) {
        this.reason = reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CancelBookingContractRequest cancelBookingContractRequest = (CancelBookingContractRequest)o;
        return Objects.equals((Object)this.cancellerType, (Object)cancelBookingContractRequest.cancellerType) && Objects.equals((Object)this.type, (Object)cancelBookingContractRequest.type) && Objects.equals(this.reason, cancelBookingContractRequest.reason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cancellerType, this.type, this.reason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CancelBookingContractRequest {\n");
        sb.append("    cancellerType: ").append(this.toIndentedString((Object)this.cancellerType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CancellerTypeEnum {
        SALES_CHANNEL("SALES_CHANNEL"),
        SUPPLIER("SUPPLIER"),
        TRAVELER("TRAVELER");

        private String value;

        private CancellerTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CancellerTypeEnum fromValue(String value) {
            for (CancellerTypeEnum b : CancellerTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        DUPLICATE("DUPLICATE"),
        CANCELLATION("CANCELLATION"),
        NO_SHOW("NO_SHOW"),
        CC_INVALID("CC_INVALID"),
        CC_INSUFFICIENT("CC_INSUFFICIENT"),
        DISCRETIONARY("DISCRETIONARY");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

