/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.payment.model.Moneys;

@JsonPropertyOrder(value={"acquirerIdentifier", "charge", "name", "description", "customerIdentifier"})
public class CreatePaymentIntentRequest {
    public static final String JSON_PROPERTY_ACQUIRER_IDENTIFIER = "acquirerIdentifier";
    private String acquirerIdentifier;
    public static final String JSON_PROPERTY_CHARGE = "charge";
    private Moneys charge;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_CUSTOMER_IDENTIFIER = "customerIdentifier";
    private String customerIdentifier;

    public CreatePaymentIntentRequest acquirerIdentifier(String acquirerIdentifier) {
        this.acquirerIdentifier = acquirerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="stripe-eur", required=true, value="Which coverage area is Stripe customer occurring in.")
    @JsonProperty(value="acquirerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAcquirerIdentifier() {
        return this.acquirerIdentifier;
    }

    @JsonProperty(value="acquirerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAcquirerIdentifier(String acquirerIdentifier) {
        this.acquirerIdentifier = acquirerIdentifier;
    }

    public CreatePaymentIntentRequest charge(Moneys charge) {
        this.charge = charge;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="charge")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getCharge() {
        return this.charge;
    }

    @JsonProperty(value="charge")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCharge(Moneys charge) {
        this.charge = charge;
    }

    public CreatePaymentIntentRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Hotel X", required=true, value="Name of hotel")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public CreatePaymentIntentRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Hotel X", required=true, value="Details of the booking")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CreatePaymentIntentRequest customerIdentifier(String customerIdentifier) {
        this.customerIdentifier = customerIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="customer-1", value="Optional Stripe customer identifier.")
    @JsonProperty(value="customerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerIdentifier() {
        return this.customerIdentifier;
    }

    @JsonProperty(value="customerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerIdentifier(String customerIdentifier) {
        this.customerIdentifier = customerIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePaymentIntentRequest createPaymentIntentRequest = (CreatePaymentIntentRequest)o;
        return Objects.equals(this.acquirerIdentifier, createPaymentIntentRequest.acquirerIdentifier) && Objects.equals(this.charge, createPaymentIntentRequest.charge) && Objects.equals(this.name, createPaymentIntentRequest.name) && Objects.equals(this.description, createPaymentIntentRequest.description) && Objects.equals(this.customerIdentifier, createPaymentIntentRequest.customerIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.acquirerIdentifier, this.charge, this.name, this.description, this.customerIdentifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreatePaymentIntentRequest {\n");
        sb.append("    acquirerIdentifier: ").append(this.toIndentedString(this.acquirerIdentifier)).append("\n");
        sb.append("    charge: ").append(this.toIndentedString(this.charge)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    customerIdentifier: ").append(this.toIndentedString(this.customerIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

