/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.sdk.payment.model.UpsertAddressRequest;
import travel.wink.sdk.payment.model.UpsertBankAccountRequest;

@JsonPropertyOrder(value={"bankAccount", "address", "ownerType", "ownerTypeIdentifier", "dob"})
public class VerifyAccountRequest {
    public static final String JSON_PROPERTY_BANK_ACCOUNT = "bankAccount";
    private UpsertBankAccountRequest bankAccount;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private UpsertAddressRequest address;
    public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
    private OwnerTypeEnum ownerType;
    public static final String JSON_PROPERTY_OWNER_TYPE_IDENTIFIER = "ownerTypeIdentifier";
    private String ownerTypeIdentifier;
    public static final String JSON_PROPERTY_DOB = "dob";
    private OffsetDateTime dob;

    public VerifyAccountRequest bankAccount(UpsertBankAccountRequest bankAccount) {
        this.bankAccount = bankAccount;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="bankAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UpsertBankAccountRequest getBankAccount() {
        return this.bankAccount;
    }

    @JsonProperty(value="bankAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccount(UpsertBankAccountRequest bankAccount) {
        this.bankAccount = bankAccount;
    }

    public VerifyAccountRequest address(UpsertAddressRequest address) {
        this.address = address;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UpsertAddressRequest getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(UpsertAddressRequest address) {
        this.address = address;
    }

    public VerifyAccountRequest ownerType(OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the account is a company or individual.")
    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OwnerTypeEnum getOwnerType() {
        return this.ownerType;
    }

    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerType(OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
    }

    public VerifyAccountRequest ownerTypeIdentifier(String ownerTypeIdentifier) {
        this.ownerTypeIdentifier = ownerTypeIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Either the TIN (individual) or the EIN (company) number of the individual.")
    @JsonProperty(value="ownerTypeIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOwnerTypeIdentifier() {
        return this.ownerTypeIdentifier;
    }

    @JsonProperty(value="ownerTypeIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerTypeIdentifier(String ownerTypeIdentifier) {
        this.ownerTypeIdentifier = ownerTypeIdentifier;
    }

    public VerifyAccountRequest dob(OffsetDateTime dob) {
        this.dob = dob;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Date of birth in the case of an individual.")
    @JsonProperty(value="dob")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getDob() {
        return this.dob;
    }

    @JsonProperty(value="dob")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDob(OffsetDateTime dob) {
        this.dob = dob;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerifyAccountRequest verifyAccountRequest = (VerifyAccountRequest)o;
        return Objects.equals(this.bankAccount, verifyAccountRequest.bankAccount) && Objects.equals(this.address, verifyAccountRequest.address) && Objects.equals((Object)this.ownerType, (Object)verifyAccountRequest.ownerType) && Objects.equals(this.ownerTypeIdentifier, verifyAccountRequest.ownerTypeIdentifier) && Objects.equals(this.dob, verifyAccountRequest.dob);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bankAccount, this.address, this.ownerType, this.ownerTypeIdentifier, this.dob});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VerifyAccountRequest {\n");
        sb.append("    bankAccount: ").append(this.toIndentedString(this.bankAccount)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    ownerType: ").append(this.toIndentedString((Object)this.ownerType)).append("\n");
        sb.append("    ownerTypeIdentifier: ").append(this.toIndentedString(this.ownerTypeIdentifier)).append("\n");
        sb.append("    dob: ").append(this.toIndentedString(this.dob)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OwnerTypeEnum {
        COMPANY("COMPANY"),
        INDIVIDUAL("INDIVIDUAL");

        private String value;

        private OwnerTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OwnerTypeEnum fromValue(String value) {
            for (OwnerTypeEnum b : OwnerTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

