/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.payment.model.FilterDescriptor;
import travel.wink.sdk.payment.model.GroupDescriptor;
import travel.wink.sdk.payment.model.SortDescriptor;

@JsonPropertyOrder(value={"skip", "take", "sort", "filter", "group"})
public class State {
    public static final String JSON_PROPERTY_SKIP = "skip";
    private Integer skip = 0;
    public static final String JSON_PROPERTY_TAKE = "take";
    private Integer take = 30;
    public static final String JSON_PROPERTY_SORT = "sort";
    private List<SortDescriptor> sort = null;
    public static final String JSON_PROPERTY_FILTER = "filter";
    private FilterDescriptor filter;
    public static final String JSON_PROPERTY_GROUP = "group";
    private List<GroupDescriptor> group = null;

    public State skip(Integer skip) {
        this.skip = skip;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @ApiModelProperty(example="0", required=true, value="Number of records to be skipped by the pager.")
    @JsonProperty(value="skip")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getSkip() {
        return this.skip;
    }

    @JsonProperty(value="skip")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSkip(Integer skip) {
        this.skip = skip;
    }

    public State take(Integer take) {
        this.take = take;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @Max(value=180L)
    @ApiModelProperty(example="10", required=true, value="Number of records to take.")
    @JsonProperty(value="take")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) @Max(value=180L) Integer getTake() {
        return this.take;
    }

    @JsonProperty(value="take")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTake(Integer take) {
        this.take = take;
    }

    public State sort(List<SortDescriptor> sort) {
        this.sort = sort;
        return this;
    }

    public State addSortItem(SortDescriptor sortItem) {
        if (this.sort == null) {
            this.sort = new ArrayList<SortDescriptor>();
        }
        this.sort.add(sortItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Descriptors used for sorting result set.")
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SortDescriptor> getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(List<SortDescriptor> sort) {
        this.sort = sort;
    }

    public State filter(FilterDescriptor filter) {
        this.filter = filter;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FilterDescriptor getFilter() {
        return this.filter;
    }

    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilter(FilterDescriptor filter) {
        this.filter = filter;
    }

    public State group(List<GroupDescriptor> group) {
        this.group = group;
        return this;
    }

    public State addGroupItem(GroupDescriptor groupItem) {
        if (this.group == null) {
            this.group = new ArrayList<GroupDescriptor>();
        }
        this.group.add(groupItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Descriptors to group result sets by.")
    @JsonProperty(value="group")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<GroupDescriptor> getGroup() {
        return this.group;
    }

    @JsonProperty(value="group")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroup(List<GroupDescriptor> group) {
        this.group = group;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        State state = (State)o;
        return Objects.equals(this.skip, state.skip) && Objects.equals(this.take, state.take) && Objects.equals(this.sort, state.sort) && Objects.equals(this.filter, state.filter) && Objects.equals(this.group, state.group);
    }

    public int hashCode() {
        return Objects.hash(this.skip, this.take, this.sort, this.filter, this.group);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class State {\n");
        sb.append("    skip: ").append(this.toIndentedString(this.skip)).append("\n");
        sb.append("    take: ").append(this.toIndentedString(this.take)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

