package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;

import io.trippay.sdk.payment.model.AggregateBookingContractCancellationState;
import io.trippay.sdk.payment.model.AggregateBookingContractCaptureCurrenciesByAccountResponse;
import io.trippay.sdk.payment.model.BeneficiaryAggregateData;
import io.trippay.sdk.payment.model.BookingContract;
import io.trippay.sdk.payment.model.BookingContractCancellableResponse;
import io.trippay.sdk.payment.model.BookingContractGridResponse;
import io.trippay.sdk.payment.model.CancelBookingContractRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-11-08T02:00:35.320414350+07:00[Asia/Bangkok]")
public class ContractApi {
    private ApiClient apiClient;

    public ContractApi() {
        this(new ApiClient());
    }

    @Autowired
    public ContractApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Cancel booking
     * Cancels a booking contract. Based on the type of cancellation policy, will do a refund or partial refund to the payment method.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec cancelBookingContractRequestCreation(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = cancelBookingContractRequest;
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling cancelBookingContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancelBookingContractRequest' is set
        if (cancelBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancelBookingContractRequest' when calling cancelBookingContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return apiClient.invokeAPI("/api/contract/{identifier}/cancel", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Cancel booking
     * Cancels a booking contract. Based on the type of cancellation policy, will do a refund or partial refund to the payment method.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingContract> cancelBookingContract(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return cancelBookingContractRequestCreation(identifier, cancelBookingContractRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BookingContract>> cancelBookingContractWithHttpInfo(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return cancelBookingContractRequestCreation(identifier, cancelBookingContractRequest, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Cancel group bookings
     * Cancels a group booking contract. All bookings under the same traceId.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec cancelGroupBookingContractRequestCreation(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = cancelBookingContractRequest;
        // verify the required parameter 'traceId' is set
        if (traceId == null) {
            throw new WebClientResponseException("Missing the required parameter 'traceId' when calling cancelGroupBookingContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancelBookingContractRequest' is set
        if (cancelBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancelBookingContractRequest' when calling cancelGroupBookingContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("traceId", traceId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return apiClient.invokeAPI("/api/contract/list/{traceId}/cancel", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Cancel group bookings
     * Cancels a group booking contract. All bookings under the same traceId.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BookingContract> cancelGroupBookingContract(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return cancelGroupBookingContractRequestCreation(traceId, cancelBookingContractRequest, winkVersion).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<BookingContract>>> cancelGroupBookingContractWithHttpInfo(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return cancelGroupBookingContractRequestCreation(traceId, cancelBookingContractRequest, winkVersion).toEntityList(localVarReturnType);
    }
    /**
     * Contract cancellable
     * Returns whether a booking can be cancelled or not and any rules associated with cancelling.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingContractCancellableResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec isContractCancellableRequestCreation(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = cancelBookingContractRequest;
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling isContractCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancelBookingContractRequest' is set
        if (cancelBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancelBookingContractRequest' when calling isContractCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>() {};
        return apiClient.invokeAPI("/api/contract/{identifier}/cancellable", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Contract cancellable
     * Returns whether a booking can be cancelled or not and any rules associated with cancelling.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingContractCancellableResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingContractCancellableResponse> isContractCancellable(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>() {};
        return isContractCancellableRequestCreation(identifier, cancelBookingContractRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BookingContractCancellableResponse>> isContractCancellableWithHttpInfo(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>() {};
        return isContractCancellableRequestCreation(identifier, cancelBookingContractRequest, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Group contract cancellable
     * Returns whether a booking can be cancelled or not and any rules associated with cancelling.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingContractCancellableResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec isGroupContractCancellableRequestCreation(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = cancelBookingContractRequest;
        // verify the required parameter 'traceId' is set
        if (traceId == null) {
            throw new WebClientResponseException("Missing the required parameter 'traceId' when calling isGroupContractCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancelBookingContractRequest' is set
        if (cancelBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancelBookingContractRequest' when calling isGroupContractCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("traceId", traceId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>() {};
        return apiClient.invokeAPI("/api/contract/list/{traceId}/cancellable", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Group contract cancellable
     * Returns whether a booking can be cancelled or not and any rules associated with cancelling.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingContractCancellableResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BookingContractCancellableResponse> isGroupContractCancellable(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>() {};
        return isGroupContractCancellableRequestCreation(traceId, cancelBookingContractRequest, winkVersion).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<BookingContractCancellableResponse>>> isGroupContractCancellableWithHttpInfo(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>() {};
        return isGroupContractCancellableRequestCreation(traceId, cancelBookingContractRequest, winkVersion).toEntityList(localVarReturnType);
    }
    /**
     * Retrieve aggregate beneficiary data
     * Returns aggregate contract data this account identifier has participated in.
     * <p><b>200</b> - OK
     * @param type The type parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BeneficiaryAggregateData&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAggregateBookingContractDataRequestCreation(String type, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "type", type));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BeneficiaryAggregateData> localVarReturnType = new ParameterizedTypeReference<BeneficiaryAggregateData>() {};
        return apiClient.invokeAPI("/api/administration/contract/aggregate/beneficiary", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve aggregate beneficiary data
     * Returns aggregate contract data this account identifier has participated in.
     * <p><b>200</b> - OK
     * @param type The type parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BeneficiaryAggregateData&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BeneficiaryAggregateData> showAggregateBookingContractData(String type, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BeneficiaryAggregateData> localVarReturnType = new ParameterizedTypeReference<BeneficiaryAggregateData>() {};
        return showAggregateBookingContractDataRequestCreation(type, winkVersion).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<BeneficiaryAggregateData>>> showAggregateBookingContractDataWithHttpInfo(String type, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BeneficiaryAggregateData> localVarReturnType = new ParameterizedTypeReference<BeneficiaryAggregateData>() {};
        return showAggregateBookingContractDataRequestCreation(type, winkVersion).toEntityList(localVarReturnType);
    }
    /**
     * Retrieve aggregate beneficiary data
     * Returns aggregate contract data this account identifier has participated in.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param type The type parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BeneficiaryAggregateData&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAggregateBookingContractData1RequestCreation(String accountIdentifier, String type, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling showAggregateBookingContractData1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "type", type));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BeneficiaryAggregateData> localVarReturnType = new ParameterizedTypeReference<BeneficiaryAggregateData>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/contract/aggregate/beneficiary", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve aggregate beneficiary data
     * Returns aggregate contract data this account identifier has participated in.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param type The type parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BeneficiaryAggregateData&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BeneficiaryAggregateData> showAggregateBookingContractData1(String accountIdentifier, String type, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BeneficiaryAggregateData> localVarReturnType = new ParameterizedTypeReference<BeneficiaryAggregateData>() {};
        return showAggregateBookingContractData1RequestCreation(accountIdentifier, type, winkVersion).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<BeneficiaryAggregateData>>> showAggregateBookingContractData1WithHttpInfo(String accountIdentifier, String type, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BeneficiaryAggregateData> localVarReturnType = new ParameterizedTypeReference<BeneficiaryAggregateData>() {};
        return showAggregateBookingContractData1RequestCreation(accountIdentifier, type, winkVersion).toEntityList(localVarReturnType);
    }
    /**
     * Retrieve aggregate cancellation data
     * Returns aggregate cancellation data this account identifier has participated in.
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;AggregateBookingContractCancellationState&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAggregateCancellationDataRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AggregateBookingContractCancellationState> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCancellationState>() {};
        return apiClient.invokeAPI("/api/administration/contract/aggregate/cancellation", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve aggregate cancellation data
     * Returns aggregate cancellation data this account identifier has participated in.
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;AggregateBookingContractCancellationState&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<AggregateBookingContractCancellationState> showAggregateCancellationData(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AggregateBookingContractCancellationState> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCancellationState>() {};
        return showAggregateCancellationDataRequestCreation(winkVersion).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<AggregateBookingContractCancellationState>>> showAggregateCancellationDataWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AggregateBookingContractCancellationState> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCancellationState>() {};
        return showAggregateCancellationDataRequestCreation(winkVersion).toEntityList(localVarReturnType);
    }
    /**
     * Retrieve aggregate cancellation data
     * Returns aggregate cancellation data this account identifier has participated in.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;AggregateBookingContractCancellationState&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAggregateCancellationData1RequestCreation(String accountIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling showAggregateCancellationData1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AggregateBookingContractCancellationState> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCancellationState>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/contract/aggregate/cancellation", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve aggregate cancellation data
     * Returns aggregate cancellation data this account identifier has participated in.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;AggregateBookingContractCancellationState&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<AggregateBookingContractCancellationState> showAggregateCancellationData1(String accountIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AggregateBookingContractCancellationState> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCancellationState>() {};
        return showAggregateCancellationData1RequestCreation(accountIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<AggregateBookingContractCancellationState>>> showAggregateCancellationData1WithHttpInfo(String accountIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AggregateBookingContractCancellationState> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCancellationState>() {};
        return showAggregateCancellationData1RequestCreation(accountIdentifier, winkVersion).toEntityList(localVarReturnType);
    }
    /**
     * Retrieve capture currencies
     * Returns a list of capture currencies and amounts for the account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @return AggregateBookingContractCaptureCurrenciesByAccountResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCaptureCurrenciesRequestCreation(String accountIdentifier, String state, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling showCaptureCurrencies", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "state", state));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AggregateBookingContractCaptureCurrenciesByAccountResponse> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCaptureCurrenciesByAccountResponse>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/contract/capture", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve capture currencies
     * Returns a list of capture currencies and amounts for the account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @return AggregateBookingContractCaptureCurrenciesByAccountResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AggregateBookingContractCaptureCurrenciesByAccountResponse> showCaptureCurrencies(String accountIdentifier, String state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AggregateBookingContractCaptureCurrenciesByAccountResponse> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCaptureCurrenciesByAccountResponse>() {};
        return showCaptureCurrenciesRequestCreation(accountIdentifier, state, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<AggregateBookingContractCaptureCurrenciesByAccountResponse>> showCaptureCurrenciesWithHttpInfo(String accountIdentifier, String state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AggregateBookingContractCaptureCurrenciesByAccountResponse> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCaptureCurrenciesByAccountResponse>() {};
        return showCaptureCurrenciesRequestCreation(accountIdentifier, state, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Retrieve single contract
     * Returns a booking contract by its unique identifier.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param winkVersion The winkVersion parameter
     * @return BookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showContractRequestCreation(String identifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling showContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return apiClient.invokeAPI("/api/contract/{identifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve single contract
     * Returns a booking contract by its unique identifier.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param winkVersion The winkVersion parameter
     * @return BookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingContract> showContract(String identifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return showContractRequestCreation(identifier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BookingContract>> showContractWithHttpInfo(String identifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return showContractRequestCreation(identifier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Retrieve contract grid
     * Returns booking contracts for account identifier.
     * <p><b>200</b> - OK
     * @param state The state parameter
     * @param page The page parameter
     * @param size The size parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingContractGridResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showContractGridRequestCreation(String state, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "state", state));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "size", size));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContractGridResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractGridResponse>() {};
        return apiClient.invokeAPI("/api/administration/contract/grid", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve contract grid
     * Returns booking contracts for account identifier.
     * <p><b>200</b> - OK
     * @param state The state parameter
     * @param page The page parameter
     * @param size The size parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingContractGridResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingContractGridResponse> showContractGrid(String state, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractGridResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractGridResponse>() {};
        return showContractGridRequestCreation(state, page, size, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BookingContractGridResponse>> showContractGridWithHttpInfo(String state, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractGridResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractGridResponse>() {};
        return showContractGridRequestCreation(state, page, size, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Retrieve contract grid
     * Returns booking contracts for account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param state The state parameter
     * @param page The page parameter
     * @param size The size parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingContractGridResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showContractGrid1RequestCreation(String accountIdentifier, String state, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling showContractGrid1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "state", state));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "size", size));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContractGridResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractGridResponse>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/contract/grid", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve contract grid
     * Returns booking contracts for account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param state The state parameter
     * @param page The page parameter
     * @param size The size parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingContractGridResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingContractGridResponse> showContractGrid1(String accountIdentifier, String state, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractGridResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractGridResponse>() {};
        return showContractGrid1RequestCreation(accountIdentifier, state, page, size, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BookingContractGridResponse>> showContractGrid1WithHttpInfo(String accountIdentifier, String state, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractGridResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractGridResponse>() {};
        return showContractGrid1RequestCreation(accountIdentifier, state, page, size, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Retrieve multiple contracts
     * Returns booking contracts matching traceId.
     * <p><b>200</b> - OK
     * @param traceId Trace identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showContractsRequestCreation(String traceId, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'traceId' is set
        if (traceId == null) {
            throw new WebClientResponseException("Missing the required parameter 'traceId' when calling showContracts", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("traceId", traceId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return apiClient.invokeAPI("/api/contract/list/{traceId}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve multiple contracts
     * Returns booking contracts matching traceId.
     * <p><b>200</b> - OK
     * @param traceId Trace identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BookingContract> showContracts(String traceId, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return showContractsRequestCreation(traceId, winkVersion).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<BookingContract>>> showContractsWithHttpInfo(String traceId, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return showContractsRequestCreation(traceId, winkVersion).toEntityList(localVarReturnType);
    }
}
