/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 23.1.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.trippay.sdk.payment.model.NmiCardholder;
import io.trippay.sdk.payment.model.NmiCreditCardToken;
import io.trippay.sdk.payment.model.RawSupplierContract;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CreateNmiSaleRequest
 */
@JsonPropertyOrder({
  CreateNmiSaleRequest.JSON_PROPERTY_ACQUIRER_IDENTIFIER,
  CreateNmiSaleRequest.JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER,
  CreateNmiSaleRequest.JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER_TYPE,
  CreateNmiSaleRequest.JSON_PROPERTY_DISPLAY_CURRENCY,
  CreateNmiSaleRequest.JSON_PROPERTY_SOURCE_URL,
  CreateNmiSaleRequest.JSON_PROPERTY_TRACE_ID,
  CreateNmiSaleRequest.JSON_PROPERTY_CONTRACT,
  CreateNmiSaleRequest.JSON_PROPERTY_TOKEN,
  CreateNmiSaleRequest.JSON_PROPERTY_CARDHOLDER
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-11-08T02:00:35.320414350+07:00[Asia/Bangkok]")
public class CreateNmiSaleRequest {
  public static final String JSON_PROPERTY_ACQUIRER_IDENTIFIER = "acquirerIdentifier";
  private String acquirerIdentifier;

  public static final String JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER = "affiliateAccountIdentifier";
  private UUID affiliateAccountIdentifier;

  /**
   * Type of identifier this is
   */
  public enum AffiliateAccountIdentifierTypeEnum {
    INTERNAL("INTERNAL"),
    
    EXTERNAL("EXTERNAL");

    private String value;

    AffiliateAccountIdentifierTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AffiliateAccountIdentifierTypeEnum fromValue(String value) {
      for (AffiliateAccountIdentifierTypeEnum b : AffiliateAccountIdentifierTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER_TYPE = "affiliateAccountIdentifierType";
  private AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType;

  public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
  private String displayCurrency = "USD";

  public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
  private String sourceUrl;

  public static final String JSON_PROPERTY_TRACE_ID = "traceId";
  private String traceId;

  public static final String JSON_PROPERTY_CONTRACT = "contract";
  private RawSupplierContract contract;

  public static final String JSON_PROPERTY_TOKEN = "token";
  private NmiCreditCardToken token;

  public static final String JSON_PROPERTY_CARDHOLDER = "cardholder";
  private NmiCardholder cardholder;

  public CreateNmiSaleRequest() { 
  }

  public CreateNmiSaleRequest acquirerIdentifier(String acquirerIdentifier) {
    
    this.acquirerIdentifier = acquirerIdentifier;
    return this;
  }

   /**
   * Acquirer identifier to use for processing
   * @return acquirerIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "user-1", required = true, value = "Acquirer identifier to use for processing")
  @JsonProperty(JSON_PROPERTY_ACQUIRER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAcquirerIdentifier() {
    return acquirerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ACQUIRER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAcquirerIdentifier(String acquirerIdentifier) {
    this.acquirerIdentifier = acquirerIdentifier;
  }


  public CreateNmiSaleRequest affiliateAccountIdentifier(UUID affiliateAccountIdentifier) {
    
    this.affiliateAccountIdentifier = affiliateAccountIdentifier;
    return this;
  }

   /**
   * affiliate account making the request
   * @return affiliateAccountIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "affiliate account making the request")
  @JsonProperty(JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getAffiliateAccountIdentifier() {
    return affiliateAccountIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAffiliateAccountIdentifier(UUID affiliateAccountIdentifier) {
    this.affiliateAccountIdentifier = affiliateAccountIdentifier;
  }


  public CreateNmiSaleRequest affiliateAccountIdentifierType(AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType) {
    
    this.affiliateAccountIdentifierType = affiliateAccountIdentifierType;
    return this;
  }

   /**
   * Type of identifier this is
   * @return affiliateAccountIdentifierType
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "Type of identifier this is")
  @JsonProperty(JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AffiliateAccountIdentifierTypeEnum getAffiliateAccountIdentifierType() {
    return affiliateAccountIdentifierType;
  }


  @JsonProperty(JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAffiliateAccountIdentifierType(AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType) {
    this.affiliateAccountIdentifierType = affiliateAccountIdentifierType;
  }


  public CreateNmiSaleRequest displayCurrency(String displayCurrency) {
    
    this.displayCurrency = displayCurrency;
    return this;
  }

   /**
   * The desired quote
   * @return displayCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "USD", required = true, value = "The desired quote")
  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDisplayCurrency() {
    return displayCurrency;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayCurrency(String displayCurrency) {
    this.displayCurrency = displayCurrency;
  }


  public CreateNmiSaleRequest sourceUrl(String sourceUrl) {
    
    this.sourceUrl = sourceUrl;
    return this;
  }

   /**
   * Where did the booking occur
   * @return sourceUrl
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "https://www.traveliko.com", required = true, value = "Where did the booking occur")
  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSourceUrl() {
    return sourceUrl;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceUrl(String sourceUrl) {
    this.sourceUrl = sourceUrl;
  }


  public CreateNmiSaleRequest traceId(String traceId) {
    
    this.traceId = traceId;
    return this;
  }

   /**
   * Integrator can choose to include a unique identifier to help identify the collection of bookings
   * @return traceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "integrator-booking-code-1", value = "Integrator can choose to include a unique identifier to help identify the collection of bookings")
  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTraceId() {
    return traceId;
  }


  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTraceId(String traceId) {
    this.traceId = traceId;
  }


  public CreateNmiSaleRequest contract(RawSupplierContract contract) {
    
    this.contract = contract;
    return this;
  }

   /**
   * Get contract
   * @return contract
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CONTRACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RawSupplierContract getContract() {
    return contract;
  }


  @JsonProperty(JSON_PROPERTY_CONTRACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContract(RawSupplierContract contract) {
    this.contract = contract;
  }


  public CreateNmiSaleRequest token(NmiCreditCardToken token) {
    
    this.token = token;
    return this;
  }

   /**
   * Get token
   * @return token
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TOKEN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public NmiCreditCardToken getToken() {
    return token;
  }


  @JsonProperty(JSON_PROPERTY_TOKEN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setToken(NmiCreditCardToken token) {
    this.token = token;
  }


  public CreateNmiSaleRequest cardholder(NmiCardholder cardholder) {
    
    this.cardholder = cardholder;
    return this;
  }

   /**
   * Get cardholder
   * @return cardholder
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CARDHOLDER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public NmiCardholder getCardholder() {
    return cardholder;
  }


  @JsonProperty(JSON_PROPERTY_CARDHOLDER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCardholder(NmiCardholder cardholder) {
    this.cardholder = cardholder;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateNmiSaleRequest createNmiSaleRequest = (CreateNmiSaleRequest) o;
    return Objects.equals(this.acquirerIdentifier, createNmiSaleRequest.acquirerIdentifier) &&
        Objects.equals(this.affiliateAccountIdentifier, createNmiSaleRequest.affiliateAccountIdentifier) &&
        Objects.equals(this.affiliateAccountIdentifierType, createNmiSaleRequest.affiliateAccountIdentifierType) &&
        Objects.equals(this.displayCurrency, createNmiSaleRequest.displayCurrency) &&
        Objects.equals(this.sourceUrl, createNmiSaleRequest.sourceUrl) &&
        Objects.equals(this.traceId, createNmiSaleRequest.traceId) &&
        Objects.equals(this.contract, createNmiSaleRequest.contract) &&
        Objects.equals(this.token, createNmiSaleRequest.token) &&
        Objects.equals(this.cardholder, createNmiSaleRequest.cardholder);
  }

  @Override
  public int hashCode() {
    return Objects.hash(acquirerIdentifier, affiliateAccountIdentifier, affiliateAccountIdentifierType, displayCurrency, sourceUrl, traceId, contract, token, cardholder);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateNmiSaleRequest {\n");
    sb.append("    acquirerIdentifier: ").append(toIndentedString(acquirerIdentifier)).append("\n");
    sb.append("    affiliateAccountIdentifier: ").append(toIndentedString(affiliateAccountIdentifier)).append("\n");
    sb.append("    affiliateAccountIdentifierType: ").append(toIndentedString(affiliateAccountIdentifierType)).append("\n");
    sb.append("    displayCurrency: ").append(toIndentedString(displayCurrency)).append("\n");
    sb.append("    sourceUrl: ").append(toIndentedString(sourceUrl)).append("\n");
    sb.append("    traceId: ").append(toIndentedString(traceId)).append("\n");
    sb.append("    contract: ").append(toIndentedString(contract)).append("\n");
    sb.append("    token: ").append(toIndentedString(token)).append("\n");
    sb.append("    cardholder: ").append(toIndentedString(cardholder)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

