/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.trippay.sdk.payment.model.Moneys;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@ApiModel(description="Beneficiary is a registered account with rights to compensation within a booking.")
@JsonPropertyOrder(value={"accountIdentifier", "accountName", "accountEmail", "accountUrl", "amountDueInSourceCurrency", "amountDueInDisplayCurrency", "amountDueInSupplierCurrency", "amountDueInInternalCurrency", "amountDueInCaptureCurrency", "type", "amountDueInSourcePriceAfterCancellation", "amountDueInDisplayPriceAfterCancellation", "amountDueInSupplierPriceAfterCancellation", "amountDueInInternalPriceAfterCancellation", "amountDueInCapturePriceAfterCancellation"})
public class Beneficiary {
    public static final String JSON_PROPERTY_ACCOUNT_IDENTIFIER = "accountIdentifier";
    private String accountIdentifier;
    public static final String JSON_PROPERTY_ACCOUNT_NAME = "accountName";
    private String accountName;
    public static final String JSON_PROPERTY_ACCOUNT_EMAIL = "accountEmail";
    private String accountEmail;
    public static final String JSON_PROPERTY_ACCOUNT_URL = "accountUrl";
    private String accountUrl;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_CURRENCY = "amountDueInSourceCurrency";
    private Moneys amountDueInSourceCurrency;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_CURRENCY = "amountDueInDisplayCurrency";
    private Moneys amountDueInDisplayCurrency;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_CURRENCY = "amountDueInSupplierCurrency";
    private Moneys amountDueInSupplierCurrency;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_CURRENCY = "amountDueInInternalCurrency";
    private Moneys amountDueInInternalCurrency;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_CURRENCY = "amountDueInCaptureCurrency";
    private Moneys amountDueInCaptureCurrency;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_PRICE_AFTER_CANCELLATION = "amountDueInSourcePriceAfterCancellation";
    private Moneys amountDueInSourcePriceAfterCancellation;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_PRICE_AFTER_CANCELLATION = "amountDueInDisplayPriceAfterCancellation";
    private Moneys amountDueInDisplayPriceAfterCancellation;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_PRICE_AFTER_CANCELLATION = "amountDueInSupplierPriceAfterCancellation";
    private Moneys amountDueInSupplierPriceAfterCancellation;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_PRICE_AFTER_CANCELLATION = "amountDueInInternalPriceAfterCancellation";
    private Moneys amountDueInInternalPriceAfterCancellation;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_PRICE_AFTER_CANCELLATION = "amountDueInCapturePriceAfterCancellation";
    private Moneys amountDueInCapturePriceAfterCancellation;

    public Beneficiary accountIdentifier(String accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="account-1", required=true, value="accountIdentifier of beneficiary that can map to an account with us")
    @JsonProperty(value="accountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountIdentifier() {
        return this.accountIdentifier;
    }

    @JsonProperty(value="accountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountIdentifier(String accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
    }

    public Beneficiary accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Account 1", required=true, value="accountName of beneficiary that can map to an account with us")
    @JsonProperty(value="accountName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountName() {
        return this.accountName;
    }

    @JsonProperty(value="accountName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public Beneficiary accountEmail(String accountEmail) {
        this.accountEmail = accountEmail;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="account@one.com", required=true, value="accountEmail of beneficiary that can map to an account with us")
    @JsonProperty(value="accountEmail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountEmail() {
        return this.accountEmail;
    }

    @JsonProperty(value="accountEmail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountEmail(String accountEmail) {
        this.accountEmail = accountEmail;
    }

    public Beneficiary accountUrl(String accountUrl) {
        this.accountUrl = accountUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="https://some.url", required=true, value="accountUrl of beneficiary that can map to an account with us")
    @JsonProperty(value="accountUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountUrl() {
        return this.accountUrl;
    }

    @JsonProperty(value="accountUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountUrl(String accountUrl) {
        this.accountUrl = accountUrl;
    }

    public Beneficiary amountDueInSourceCurrency(Moneys amountDueInSourceCurrency) {
        this.amountDueInSourceCurrency = amountDueInSourceCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amountDueInSourceCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getAmountDueInSourceCurrency() {
        return this.amountDueInSourceCurrency;
    }

    @JsonProperty(value="amountDueInSourceCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmountDueInSourceCurrency(Moneys amountDueInSourceCurrency) {
        this.amountDueInSourceCurrency = amountDueInSourceCurrency;
    }

    public Beneficiary amountDueInDisplayCurrency(Moneys amountDueInDisplayCurrency) {
        this.amountDueInDisplayCurrency = amountDueInDisplayCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amountDueInDisplayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getAmountDueInDisplayCurrency() {
        return this.amountDueInDisplayCurrency;
    }

    @JsonProperty(value="amountDueInDisplayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmountDueInDisplayCurrency(Moneys amountDueInDisplayCurrency) {
        this.amountDueInDisplayCurrency = amountDueInDisplayCurrency;
    }

    public Beneficiary amountDueInSupplierCurrency(Moneys amountDueInSupplierCurrency) {
        this.amountDueInSupplierCurrency = amountDueInSupplierCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amountDueInSupplierCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getAmountDueInSupplierCurrency() {
        return this.amountDueInSupplierCurrency;
    }

    @JsonProperty(value="amountDueInSupplierCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmountDueInSupplierCurrency(Moneys amountDueInSupplierCurrency) {
        this.amountDueInSupplierCurrency = amountDueInSupplierCurrency;
    }

    public Beneficiary amountDueInInternalCurrency(Moneys amountDueInInternalCurrency) {
        this.amountDueInInternalCurrency = amountDueInInternalCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amountDueInInternalCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getAmountDueInInternalCurrency() {
        return this.amountDueInInternalCurrency;
    }

    @JsonProperty(value="amountDueInInternalCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmountDueInInternalCurrency(Moneys amountDueInInternalCurrency) {
        this.amountDueInInternalCurrency = amountDueInInternalCurrency;
    }

    public Beneficiary amountDueInCaptureCurrency(Moneys amountDueInCaptureCurrency) {
        this.amountDueInCaptureCurrency = amountDueInCaptureCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amountDueInCaptureCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getAmountDueInCaptureCurrency() {
        return this.amountDueInCaptureCurrency;
    }

    @JsonProperty(value="amountDueInCaptureCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmountDueInCaptureCurrency(Moneys amountDueInCaptureCurrency) {
        this.amountDueInCaptureCurrency = amountDueInCaptureCurrency;
    }

    public Beneficiary type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="The type of beneficiary payment.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Beneficiary amountDueInSourcePriceAfterCancellation(Moneys amountDueInSourcePriceAfterCancellation) {
        this.amountDueInSourcePriceAfterCancellation = amountDueInSourcePriceAfterCancellation;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="amountDueInSourcePriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getAmountDueInSourcePriceAfterCancellation() {
        return this.amountDueInSourcePriceAfterCancellation;
    }

    @JsonProperty(value="amountDueInSourcePriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmountDueInSourcePriceAfterCancellation(Moneys amountDueInSourcePriceAfterCancellation) {
        this.amountDueInSourcePriceAfterCancellation = amountDueInSourcePriceAfterCancellation;
    }

    public Beneficiary amountDueInDisplayPriceAfterCancellation(Moneys amountDueInDisplayPriceAfterCancellation) {
        this.amountDueInDisplayPriceAfterCancellation = amountDueInDisplayPriceAfterCancellation;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="amountDueInDisplayPriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getAmountDueInDisplayPriceAfterCancellation() {
        return this.amountDueInDisplayPriceAfterCancellation;
    }

    @JsonProperty(value="amountDueInDisplayPriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmountDueInDisplayPriceAfterCancellation(Moneys amountDueInDisplayPriceAfterCancellation) {
        this.amountDueInDisplayPriceAfterCancellation = amountDueInDisplayPriceAfterCancellation;
    }

    public Beneficiary amountDueInSupplierPriceAfterCancellation(Moneys amountDueInSupplierPriceAfterCancellation) {
        this.amountDueInSupplierPriceAfterCancellation = amountDueInSupplierPriceAfterCancellation;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="amountDueInSupplierPriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getAmountDueInSupplierPriceAfterCancellation() {
        return this.amountDueInSupplierPriceAfterCancellation;
    }

    @JsonProperty(value="amountDueInSupplierPriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmountDueInSupplierPriceAfterCancellation(Moneys amountDueInSupplierPriceAfterCancellation) {
        this.amountDueInSupplierPriceAfterCancellation = amountDueInSupplierPriceAfterCancellation;
    }

    public Beneficiary amountDueInInternalPriceAfterCancellation(Moneys amountDueInInternalPriceAfterCancellation) {
        this.amountDueInInternalPriceAfterCancellation = amountDueInInternalPriceAfterCancellation;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="amountDueInInternalPriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getAmountDueInInternalPriceAfterCancellation() {
        return this.amountDueInInternalPriceAfterCancellation;
    }

    @JsonProperty(value="amountDueInInternalPriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmountDueInInternalPriceAfterCancellation(Moneys amountDueInInternalPriceAfterCancellation) {
        this.amountDueInInternalPriceAfterCancellation = amountDueInInternalPriceAfterCancellation;
    }

    public Beneficiary amountDueInCapturePriceAfterCancellation(Moneys amountDueInCapturePriceAfterCancellation) {
        this.amountDueInCapturePriceAfterCancellation = amountDueInCapturePriceAfterCancellation;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="amountDueInCapturePriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getAmountDueInCapturePriceAfterCancellation() {
        return this.amountDueInCapturePriceAfterCancellation;
    }

    @JsonProperty(value="amountDueInCapturePriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmountDueInCapturePriceAfterCancellation(Moneys amountDueInCapturePriceAfterCancellation) {
        this.amountDueInCapturePriceAfterCancellation = amountDueInCapturePriceAfterCancellation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Beneficiary beneficiary = (Beneficiary)o;
        return Objects.equals(this.accountIdentifier, beneficiary.accountIdentifier) && Objects.equals(this.accountName, beneficiary.accountName) && Objects.equals(this.accountEmail, beneficiary.accountEmail) && Objects.equals(this.accountUrl, beneficiary.accountUrl) && Objects.equals(this.amountDueInSourceCurrency, beneficiary.amountDueInSourceCurrency) && Objects.equals(this.amountDueInDisplayCurrency, beneficiary.amountDueInDisplayCurrency) && Objects.equals(this.amountDueInSupplierCurrency, beneficiary.amountDueInSupplierCurrency) && Objects.equals(this.amountDueInInternalCurrency, beneficiary.amountDueInInternalCurrency) && Objects.equals(this.amountDueInCaptureCurrency, beneficiary.amountDueInCaptureCurrency) && Objects.equals((Object)this.type, (Object)beneficiary.type) && Objects.equals(this.amountDueInSourcePriceAfterCancellation, beneficiary.amountDueInSourcePriceAfterCancellation) && Objects.equals(this.amountDueInDisplayPriceAfterCancellation, beneficiary.amountDueInDisplayPriceAfterCancellation) && Objects.equals(this.amountDueInSupplierPriceAfterCancellation, beneficiary.amountDueInSupplierPriceAfterCancellation) && Objects.equals(this.amountDueInInternalPriceAfterCancellation, beneficiary.amountDueInInternalPriceAfterCancellation) && Objects.equals(this.amountDueInCapturePriceAfterCancellation, beneficiary.amountDueInCapturePriceAfterCancellation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountIdentifier, this.accountName, this.accountEmail, this.accountUrl, this.amountDueInSourceCurrency, this.amountDueInDisplayCurrency, this.amountDueInSupplierCurrency, this.amountDueInInternalCurrency, this.amountDueInCaptureCurrency, this.type, this.amountDueInSourcePriceAfterCancellation, this.amountDueInDisplayPriceAfterCancellation, this.amountDueInSupplierPriceAfterCancellation, this.amountDueInInternalPriceAfterCancellation, this.amountDueInCapturePriceAfterCancellation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Beneficiary {\n");
        sb.append("    accountIdentifier: ").append(this.toIndentedString(this.accountIdentifier)).append("\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    accountEmail: ").append(this.toIndentedString(this.accountEmail)).append("\n");
        sb.append("    accountUrl: ").append(this.toIndentedString(this.accountUrl)).append("\n");
        sb.append("    amountDueInSourceCurrency: ").append(this.toIndentedString(this.amountDueInSourceCurrency)).append("\n");
        sb.append("    amountDueInDisplayCurrency: ").append(this.toIndentedString(this.amountDueInDisplayCurrency)).append("\n");
        sb.append("    amountDueInSupplierCurrency: ").append(this.toIndentedString(this.amountDueInSupplierCurrency)).append("\n");
        sb.append("    amountDueInInternalCurrency: ").append(this.toIndentedString(this.amountDueInInternalCurrency)).append("\n");
        sb.append("    amountDueInCaptureCurrency: ").append(this.toIndentedString(this.amountDueInCaptureCurrency)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    amountDueInSourcePriceAfterCancellation: ").append(this.toIndentedString(this.amountDueInSourcePriceAfterCancellation)).append("\n");
        sb.append("    amountDueInDisplayPriceAfterCancellation: ").append(this.toIndentedString(this.amountDueInDisplayPriceAfterCancellation)).append("\n");
        sb.append("    amountDueInSupplierPriceAfterCancellation: ").append(this.toIndentedString(this.amountDueInSupplierPriceAfterCancellation)).append("\n");
        sb.append("    amountDueInInternalPriceAfterCancellation: ").append(this.toIndentedString(this.amountDueInInternalPriceAfterCancellation)).append("\n");
        sb.append("    amountDueInCapturePriceAfterCancellation: ").append(this.toIndentedString(this.amountDueInCapturePriceAfterCancellation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        COMMISSION("COMMISSION"),
        PLATFORM_FEE("PLATFORM_FEE"),
        TRIP_PAY("TRIP_PAY"),
        SALE("SALE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

