/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.trippay.sdk.payment.model.Moneys;
import io.trippay.sdk.payment.model.SupplierContractItemPolicy;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@ApiModel(description="Contract item cancellable object")
@JsonPropertyOrder(value={"supplierItemBookingCode", "nameInEnglish", "policy", "type", "sourcePrice", "supplierPrice", "displayPrice", "internalPrice", "capturePrice", "cancellableByTraveler", "cancellableBySupplier", "cancellableWithCharges", "sourcePriceAfterCancellation", "supplierPriceAfterCancellation", "displayPriceAfterCancellation", "internalPriceAfterCancellation"})
public class BookingContractItemCancellableResponse {
    public static final String JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE = "supplierItemBookingCode";
    private String supplierItemBookingCode;
    public static final String JSON_PROPERTY_NAME_IN_ENGLISH = "nameInEnglish";
    private String nameInEnglish;
    public static final String JSON_PROPERTY_POLICY = "policy";
    private SupplierContractItemPolicy policy;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_SOURCE_PRICE = "sourcePrice";
    private Moneys sourcePrice;
    public static final String JSON_PROPERTY_SUPPLIER_PRICE = "supplierPrice";
    private Moneys supplierPrice;
    public static final String JSON_PROPERTY_DISPLAY_PRICE = "displayPrice";
    private Moneys displayPrice;
    public static final String JSON_PROPERTY_INTERNAL_PRICE = "internalPrice";
    private Moneys internalPrice;
    public static final String JSON_PROPERTY_CAPTURE_PRICE = "capturePrice";
    private Moneys capturePrice;
    public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
    private Boolean cancellableByTraveler;
    public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
    private Boolean cancellableBySupplier;
    public static final String JSON_PROPERTY_CANCELLABLE_WITH_CHARGES = "cancellableWithCharges";
    private Boolean cancellableWithCharges;
    public static final String JSON_PROPERTY_SOURCE_PRICE_AFTER_CANCELLATION = "sourcePriceAfterCancellation";
    private Moneys sourcePriceAfterCancellation;
    public static final String JSON_PROPERTY_SUPPLIER_PRICE_AFTER_CANCELLATION = "supplierPriceAfterCancellation";
    private Moneys supplierPriceAfterCancellation;
    public static final String JSON_PROPERTY_DISPLAY_PRICE_AFTER_CANCELLATION = "displayPriceAfterCancellation";
    private Moneys displayPriceAfterCancellation;
    public static final String JSON_PROPERTY_INTERNAL_PRICE_AFTER_CANCELLATION = "internalPriceAfterCancellation";
    private Moneys internalPriceAfterCancellation;

    public BookingContractItemCancellableResponse supplierItemBookingCode(String supplierItemBookingCode) {
        this.supplierItemBookingCode = supplierItemBookingCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="TP-ASDFG1234", value="Booking code identifying the supplier line item.")
    @JsonProperty(value="supplierItemBookingCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSupplierItemBookingCode() {
        return this.supplierItemBookingCode;
    }

    @JsonProperty(value="supplierItemBookingCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupplierItemBookingCode(String supplierItemBookingCode) {
        this.supplierItemBookingCode = supplierItemBookingCode;
    }

    public BookingContractItemCancellableResponse nameInEnglish(String nameInEnglish) {
        this.nameInEnglish = nameInEnglish;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Deluxe King", value="Name of item in English included in booking.")
    @JsonProperty(value="nameInEnglish")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNameInEnglish() {
        return this.nameInEnglish;
    }

    @JsonProperty(value="nameInEnglish")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNameInEnglish(String nameInEnglish) {
        this.nameInEnglish = nameInEnglish;
    }

    public BookingContractItemCancellableResponse policy(SupplierContractItemPolicy policy) {
        this.policy = policy;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SupplierContractItemPolicy getPolicy() {
        return this.policy;
    }

    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolicy(SupplierContractItemPolicy policy) {
        this.policy = policy;
    }

    public BookingContractItemCancellableResponse type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="LODGING", value="Type of item this is.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public BookingContractItemCancellableResponse sourcePrice(Moneys sourcePrice) {
        this.sourcePrice = sourcePrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="sourcePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getSourcePrice() {
        return this.sourcePrice;
    }

    @JsonProperty(value="sourcePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourcePrice(Moneys sourcePrice) {
        this.sourcePrice = sourcePrice;
    }

    public BookingContractItemCancellableResponse supplierPrice(Moneys supplierPrice) {
        this.supplierPrice = supplierPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="supplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getSupplierPrice() {
        return this.supplierPrice;
    }

    @JsonProperty(value="supplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupplierPrice(Moneys supplierPrice) {
        this.supplierPrice = supplierPrice;
    }

    public BookingContractItemCancellableResponse displayPrice(Moneys displayPrice) {
        this.displayPrice = displayPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="displayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getDisplayPrice() {
        return this.displayPrice;
    }

    @JsonProperty(value="displayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayPrice(Moneys displayPrice) {
        this.displayPrice = displayPrice;
    }

    public BookingContractItemCancellableResponse internalPrice(Moneys internalPrice) {
        this.internalPrice = internalPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="internalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getInternalPrice() {
        return this.internalPrice;
    }

    @JsonProperty(value="internalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalPrice(Moneys internalPrice) {
        this.internalPrice = internalPrice;
    }

    public BookingContractItemCancellableResponse capturePrice(Moneys capturePrice) {
        this.capturePrice = capturePrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="capturePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getCapturePrice() {
        return this.capturePrice;
    }

    @JsonProperty(value="capturePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCapturePrice(Moneys capturePrice) {
        this.capturePrice = capturePrice;
    }

    public BookingContractItemCancellableResponse cancellableByTraveler(Boolean cancellableByTraveler) {
        this.cancellableByTraveler = cancellableByTraveler;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether this item can be cancelled by traveler either fully or partially.")
    @JsonProperty(value="cancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableByTraveler() {
        return this.cancellableByTraveler;
    }

    @JsonProperty(value="cancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableByTraveler(Boolean cancellableByTraveler) {
        this.cancellableByTraveler = cancellableByTraveler;
    }

    public BookingContractItemCancellableResponse cancellableBySupplier(Boolean cancellableBySupplier) {
        this.cancellableBySupplier = cancellableBySupplier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether this item can be cancelled by supplier either fully or partially.")
    @JsonProperty(value="cancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableBySupplier() {
        return this.cancellableBySupplier;
    }

    @JsonProperty(value="cancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableBySupplier(Boolean cancellableBySupplier) {
        this.cancellableBySupplier = cancellableBySupplier;
    }

    public BookingContractItemCancellableResponse cancellableWithCharges(Boolean cancellableWithCharges) {
        this.cancellableWithCharges = cancellableWithCharges;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether this item can be cancelled by supplier either fully or partially.")
    @JsonProperty(value="cancellableWithCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableWithCharges() {
        return this.cancellableWithCharges;
    }

    @JsonProperty(value="cancellableWithCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableWithCharges(Boolean cancellableWithCharges) {
        this.cancellableWithCharges = cancellableWithCharges;
    }

    public BookingContractItemCancellableResponse sourcePriceAfterCancellation(Moneys sourcePriceAfterCancellation) {
        this.sourcePriceAfterCancellation = sourcePriceAfterCancellation;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="sourcePriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getSourcePriceAfterCancellation() {
        return this.sourcePriceAfterCancellation;
    }

    @JsonProperty(value="sourcePriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourcePriceAfterCancellation(Moneys sourcePriceAfterCancellation) {
        this.sourcePriceAfterCancellation = sourcePriceAfterCancellation;
    }

    public BookingContractItemCancellableResponse supplierPriceAfterCancellation(Moneys supplierPriceAfterCancellation) {
        this.supplierPriceAfterCancellation = supplierPriceAfterCancellation;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="supplierPriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getSupplierPriceAfterCancellation() {
        return this.supplierPriceAfterCancellation;
    }

    @JsonProperty(value="supplierPriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupplierPriceAfterCancellation(Moneys supplierPriceAfterCancellation) {
        this.supplierPriceAfterCancellation = supplierPriceAfterCancellation;
    }

    public BookingContractItemCancellableResponse displayPriceAfterCancellation(Moneys displayPriceAfterCancellation) {
        this.displayPriceAfterCancellation = displayPriceAfterCancellation;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="displayPriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getDisplayPriceAfterCancellation() {
        return this.displayPriceAfterCancellation;
    }

    @JsonProperty(value="displayPriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayPriceAfterCancellation(Moneys displayPriceAfterCancellation) {
        this.displayPriceAfterCancellation = displayPriceAfterCancellation;
    }

    public BookingContractItemCancellableResponse internalPriceAfterCancellation(Moneys internalPriceAfterCancellation) {
        this.internalPriceAfterCancellation = internalPriceAfterCancellation;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="internalPriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getInternalPriceAfterCancellation() {
        return this.internalPriceAfterCancellation;
    }

    @JsonProperty(value="internalPriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalPriceAfterCancellation(Moneys internalPriceAfterCancellation) {
        this.internalPriceAfterCancellation = internalPriceAfterCancellation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookingContractItemCancellableResponse bookingContractItemCancellableResponse = (BookingContractItemCancellableResponse)o;
        return Objects.equals(this.supplierItemBookingCode, bookingContractItemCancellableResponse.supplierItemBookingCode) && Objects.equals(this.nameInEnglish, bookingContractItemCancellableResponse.nameInEnglish) && Objects.equals(this.policy, bookingContractItemCancellableResponse.policy) && Objects.equals((Object)this.type, (Object)bookingContractItemCancellableResponse.type) && Objects.equals(this.sourcePrice, bookingContractItemCancellableResponse.sourcePrice) && Objects.equals(this.supplierPrice, bookingContractItemCancellableResponse.supplierPrice) && Objects.equals(this.displayPrice, bookingContractItemCancellableResponse.displayPrice) && Objects.equals(this.internalPrice, bookingContractItemCancellableResponse.internalPrice) && Objects.equals(this.capturePrice, bookingContractItemCancellableResponse.capturePrice) && Objects.equals(this.cancellableByTraveler, bookingContractItemCancellableResponse.cancellableByTraveler) && Objects.equals(this.cancellableBySupplier, bookingContractItemCancellableResponse.cancellableBySupplier) && Objects.equals(this.cancellableWithCharges, bookingContractItemCancellableResponse.cancellableWithCharges) && Objects.equals(this.sourcePriceAfterCancellation, bookingContractItemCancellableResponse.sourcePriceAfterCancellation) && Objects.equals(this.supplierPriceAfterCancellation, bookingContractItemCancellableResponse.supplierPriceAfterCancellation) && Objects.equals(this.displayPriceAfterCancellation, bookingContractItemCancellableResponse.displayPriceAfterCancellation) && Objects.equals(this.internalPriceAfterCancellation, bookingContractItemCancellableResponse.internalPriceAfterCancellation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.supplierItemBookingCode, this.nameInEnglish, this.policy, this.type, this.sourcePrice, this.supplierPrice, this.displayPrice, this.internalPrice, this.capturePrice, this.cancellableByTraveler, this.cancellableBySupplier, this.cancellableWithCharges, this.sourcePriceAfterCancellation, this.supplierPriceAfterCancellation, this.displayPriceAfterCancellation, this.internalPriceAfterCancellation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookingContractItemCancellableResponse {\n");
        sb.append("    supplierItemBookingCode: ").append(this.toIndentedString(this.supplierItemBookingCode)).append("\n");
        sb.append("    nameInEnglish: ").append(this.toIndentedString(this.nameInEnglish)).append("\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    sourcePrice: ").append(this.toIndentedString(this.sourcePrice)).append("\n");
        sb.append("    supplierPrice: ").append(this.toIndentedString(this.supplierPrice)).append("\n");
        sb.append("    displayPrice: ").append(this.toIndentedString(this.displayPrice)).append("\n");
        sb.append("    internalPrice: ").append(this.toIndentedString(this.internalPrice)).append("\n");
        sb.append("    capturePrice: ").append(this.toIndentedString(this.capturePrice)).append("\n");
        sb.append("    cancellableByTraveler: ").append(this.toIndentedString(this.cancellableByTraveler)).append("\n");
        sb.append("    cancellableBySupplier: ").append(this.toIndentedString(this.cancellableBySupplier)).append("\n");
        sb.append("    cancellableWithCharges: ").append(this.toIndentedString(this.cancellableWithCharges)).append("\n");
        sb.append("    sourcePriceAfterCancellation: ").append(this.toIndentedString(this.sourcePriceAfterCancellation)).append("\n");
        sb.append("    supplierPriceAfterCancellation: ").append(this.toIndentedString(this.supplierPriceAfterCancellation)).append("\n");
        sb.append("    displayPriceAfterCancellation: ").append(this.toIndentedString(this.displayPriceAfterCancellation)).append("\n");
        sb.append("    internalPriceAfterCancellation: ").append(this.toIndentedString(this.internalPriceAfterCancellation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        LODGING("LODGING"),
        RAIL("RAIL"),
        AIR("AIR"),
        CAR("CAR"),
        CRUISE("CRUISE"),
        PACKAGE("PACKAGE"),
        ADD_ON("ADD_ON"),
        RENTAL("RENTAL"),
        EXPERIENCE("EXPERIENCE"),
        ANCILLARY_BOOKING("ANCILLARY_BOOKING"),
        ANCILLARY_FEE("ANCILLARY_FEE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

