/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@ApiModel(description="Mapping record is responsible for mapping a local account identifier with a remote system. When a booking comes in from the remote system, we will know how to properly assign funds to the correct accounts.")
@JsonPropertyOrder(value={"id", "createdDate", "lastUpdate", "version", "accountOwnerIdentifier", "localAccountIdentifier", "externalIdentifier", "accountIdentifier", "name"})
public class Mapping {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    private LocalDateTime createdDate;
    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    private LocalDateTime lastUpdate;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Long version;
    public static final String JSON_PROPERTY_ACCOUNT_OWNER_IDENTIFIER = "accountOwnerIdentifier";
    private UUID accountOwnerIdentifier;
    public static final String JSON_PROPERTY_LOCAL_ACCOUNT_IDENTIFIER = "localAccountIdentifier";
    private UUID localAccountIdentifier;
    public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
    private String externalIdentifier;
    public static final String JSON_PROPERTY_ACCOUNT_IDENTIFIER = "accountIdentifier";
    private UUID accountIdentifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public Mapping id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="doc-1", value="Document UUID")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public Mapping createdDate(LocalDateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Datetime this record was first created")
    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedDate(LocalDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public Mapping lastUpdate(LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Datetime this record was last updated")
    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastUpdate(LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public Mapping version(Long version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="12", value="Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.")
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(Long version) {
        this.version = version;
    }

    public Mapping accountOwnerIdentifier(UUID accountOwnerIdentifier) {
        this.accountOwnerIdentifier = accountOwnerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The entity that owns this account.")
    @JsonProperty(value="accountOwnerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getAccountOwnerIdentifier() {
        return this.accountOwnerIdentifier;
    }

    @JsonProperty(value="accountOwnerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountOwnerIdentifier(UUID accountOwnerIdentifier) {
        this.accountOwnerIdentifier = accountOwnerIdentifier;
    }

    public Mapping localAccountIdentifier(UUID localAccountIdentifier) {
        this.localAccountIdentifier = localAccountIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Local account identifier is the payment identifier")
    @JsonProperty(value="localAccountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getLocalAccountIdentifier() {
        return this.localAccountIdentifier;
    }

    @JsonProperty(value="localAccountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLocalAccountIdentifier(UUID localAccountIdentifier) {
        this.localAccountIdentifier = localAccountIdentifier;
    }

    public Mapping externalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="hotel-a", required=true, value="External identifier is the identifier of this entity in a remote system")
    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExternalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public Mapping accountIdentifier(UUID accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Account identifier is the account doing the mapping")
    @JsonProperty(value="accountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getAccountIdentifier() {
        return this.accountIdentifier;
    }

    @JsonProperty(value="accountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountIdentifier(UUID accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
    }

    public Mapping name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Sheraton Hua Hin", required=true, value="Name of the entity being mapped")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mapping mapping = (Mapping)o;
        return Objects.equals(this.id, mapping.id) && Objects.equals(this.createdDate, mapping.createdDate) && Objects.equals(this.lastUpdate, mapping.lastUpdate) && Objects.equals(this.version, mapping.version) && Objects.equals(this.accountOwnerIdentifier, mapping.accountOwnerIdentifier) && Objects.equals(this.localAccountIdentifier, mapping.localAccountIdentifier) && Objects.equals(this.externalIdentifier, mapping.externalIdentifier) && Objects.equals(this.accountIdentifier, mapping.accountIdentifier) && Objects.equals(this.name, mapping.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdDate, this.lastUpdate, this.version, this.accountOwnerIdentifier, this.localAccountIdentifier, this.externalIdentifier, this.accountIdentifier, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Mapping {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    accountOwnerIdentifier: ").append(this.toIndentedString(this.accountOwnerIdentifier)).append("\n");
        sb.append("    localAccountIdentifier: ").append(this.toIndentedString(this.localAccountIdentifier)).append("\n");
        sb.append("    externalIdentifier: ").append(this.toIndentedString(this.externalIdentifier)).append("\n");
        sb.append("    accountIdentifier: ").append(this.toIndentedString(this.accountIdentifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

