/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 24.0.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.trippay.sdk.payment.model.BookingContractItem;
import io.trippay.sdk.payment.model.BookingContractPaymentDetails;
import io.trippay.sdk.payment.model.Itinerary;
import io.trippay.sdk.payment.model.Moneys;
import io.trippay.sdk.payment.model.Quote;
import io.trippay.sdk.payment.model.Refund;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * A booking record is the contract that got created after a successful payment was submitted.
 */
@ApiModel(description = "A booking record is the contract that got created after a successful payment was submitted.")
@JsonPropertyOrder({
  BookingContract.JSON_PROPERTY_ID,
  BookingContract.JSON_PROPERTY_CREATED_DATE,
  BookingContract.JSON_PROPERTY_LAST_UPDATE,
  BookingContract.JSON_PROPERTY_VERSION,
  BookingContract.JSON_PROPERTY_IP_ADDRESS,
  BookingContract.JSON_PROPERTY_TRACE_ID,
  BookingContract.JSON_PROPERTY_SOURCE_URL,
  BookingContract.JSON_PROPERTY_IDENTIFIER,
  BookingContract.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  BookingContract.JSON_PROPERTY_SUPPLIER_NAME,
  BookingContract.JSON_PROPERTY_DISPLAY_PRICE_QUOTE,
  BookingContract.JSON_PROPERTY_SUPPLIER_PRICE_QUOTE,
  BookingContract.JSON_PROPERTY_INTERNAL_PRICE_QUOTE,
  BookingContract.JSON_PROPERTY_CAPTURE_PRICE_QUOTE,
  BookingContract.JSON_PROPERTY_ITEM_LIST,
  BookingContract.JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER,
  BookingContract.JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE,
  BookingContract.JSON_PROPERTY_PAYMENT,
  BookingContract.JSON_PROPERTY_CANCELLED,
  BookingContract.JSON_PROPERTY_CANCELLED_ON,
  BookingContract.JSON_PROPERTY_CANCELLER,
  BookingContract.JSON_PROPERTY_CANCELLATION_TYPE,
  BookingContract.JSON_PROPERTY_CANCELLER_USER_IDENTIFIER,
  BookingContract.JSON_PROPERTY_CANCEL_REASON,
  BookingContract.JSON_PROPERTY_FUNDS_ADDED_TO_LEDGER,
  BookingContract.JSON_PROPERTY_FUNDS_PROCESSED,
  BookingContract.JSON_PROPERTY_REFUNDS,
  BookingContract.JSON_PROPERTY_TOTAL_DISPLAY_PRICE,
  BookingContract.JSON_PROPERTY_TOTAL_INTERNAL_PRICE,
  BookingContract.JSON_PROPERTY_TOTAL_SUPPLIER_PRICE,
  BookingContract.JSON_PROPERTY_TOTAL_SOURCE_PRICE,
  BookingContract.JSON_PROPERTY_TOTAL_CAPTURE_PRICE,
  BookingContract.JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_REFUND,
  BookingContract.JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_REFUND,
  BookingContract.JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_REFUND,
  BookingContract.JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_REFUND,
  BookingContract.JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_REFUND,
  BookingContract.JSON_PROPERTY_CANCELLABLE_BY_TRAVELER,
  BookingContract.JSON_PROPERTY_REFUNDED_CAPTURE_PRICE,
  BookingContract.JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER,
  BookingContract.JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES,
  BookingContract.JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES,
  BookingContract.JSON_PROPERTY_LODGING,
  BookingContract.JSON_PROPERTY_REFUNDED_DISPLAY_PRICE,
  BookingContract.JSON_PROPERTY_REFUNDED_INTERNAL_PRICE,
  BookingContract.JSON_PROPERTY_REFUNDED_SUPPLIER_PRICE,
  BookingContract.JSON_PROPERTY_REFUNDED_SOURCE_PRICE,
  BookingContract.JSON_PROPERTY_REFUNDABLE_DISPLAY_PRICE,
  BookingContract.JSON_PROPERTY_REFUNDABLE_INTERNAL_PRICE,
  BookingContract.JSON_PROPERTY_REFUNDABLE_SUPPLIER_PRICE,
  BookingContract.JSON_PROPERTY_REFUNDABLE_SOURCE_PRICE,
  BookingContract.JSON_PROPERTY_REFUNDABLE_CAPTURE_PRICE,
  BookingContract.JSON_PROPERTY_TOTAL_TOKENS_EARNED,
  BookingContract.JSON_PROPERTY_LODGING_ITINERARY
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-06T15:20:29.359634909+07:00[Asia/Bangkok]")
public class BookingContract {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
  private java.time.LocalDateTime createdDate;

  public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
  private java.time.LocalDateTime lastUpdate;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Long version;

  public static final String JSON_PROPERTY_IP_ADDRESS = "ipAddress";
  private String ipAddress;

  public static final String JSON_PROPERTY_TRACE_ID = "traceId";
  private String traceId;

  public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
  private String sourceUrl;

  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  private UUID supplierIdentifier;

  public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
  private String supplierName;

  public static final String JSON_PROPERTY_DISPLAY_PRICE_QUOTE = "displayPriceQuote";
  private Quote displayPriceQuote;

  public static final String JSON_PROPERTY_SUPPLIER_PRICE_QUOTE = "supplierPriceQuote";
  private Quote supplierPriceQuote;

  public static final String JSON_PROPERTY_INTERNAL_PRICE_QUOTE = "internalPriceQuote";
  private Quote internalPriceQuote;

  public static final String JSON_PROPERTY_CAPTURE_PRICE_QUOTE = "capturePriceQuote";
  private Quote capturePriceQuote;

  public static final String JSON_PROPERTY_ITEM_LIST = "itemList";
  private List<BookingContractItem> itemList = new ArrayList<>();

  public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER = "externalSupplierIdentifier";
  private String externalSupplierIdentifier;

  public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
  private String externalSupplierBookingCode;

  public static final String JSON_PROPERTY_PAYMENT = "payment";
  private BookingContractPaymentDetails payment;

  public static final String JSON_PROPERTY_CANCELLED = "cancelled";
  private Boolean cancelled;

  public static final String JSON_PROPERTY_CANCELLED_ON = "cancelledOn";
  private java.time.LocalDateTime cancelledOn;

  /**
   * Type of entity that cancelled the booking.
   */
  public enum CancellerEnum {
    SALES_CHANNEL("SALES_CHANNEL"),
    
    SUPPLIER("SUPPLIER"),
    
    TRAVELER("TRAVELER"),
    
    ACQUIRER("ACQUIRER"),
    
    ADMINISTRATOR("ADMINISTRATOR");

    private String value;

    CancellerEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CancellerEnum fromValue(String value) {
      for (CancellerEnum b : CancellerEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CANCELLER = "canceller";
  private CancellerEnum canceller;

  /**
   * Reason type.
   */
  public enum CancellationTypeEnum {
    DUPLICATE("DUPLICATE"),
    
    CANCELLATION("CANCELLATION"),
    
    NO_SHOW("NO_SHOW"),
    
    CC_INVALID("CC_INVALID"),
    
    CC_INSUFFICIENT("CC_INSUFFICIENT"),
    
    DISCRETIONARY("DISCRETIONARY");

    private String value;

    CancellationTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CancellationTypeEnum fromValue(String value) {
      for (CancellationTypeEnum b : CancellationTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CANCELLATION_TYPE = "cancellationType";
  private CancellationTypeEnum cancellationType;

  public static final String JSON_PROPERTY_CANCELLER_USER_IDENTIFIER = "cancellerUserIdentifier";
  private String cancellerUserIdentifier;

  public static final String JSON_PROPERTY_CANCEL_REASON = "cancelReason";
  private String cancelReason;

  public static final String JSON_PROPERTY_FUNDS_ADDED_TO_LEDGER = "fundsAddedToLedger";
  private Boolean fundsAddedToLedger;

  public static final String JSON_PROPERTY_FUNDS_PROCESSED = "fundsProcessed";
  private Boolean fundsProcessed;

  public static final String JSON_PROPERTY_REFUNDS = "refunds";
  private List<Refund> refunds = null;

  public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE = "totalDisplayPrice";
  private Moneys totalDisplayPrice;

  public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE = "totalInternalPrice";
  private Moneys totalInternalPrice;

  public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE = "totalSupplierPrice";
  private Moneys totalSupplierPrice;

  public static final String JSON_PROPERTY_TOTAL_SOURCE_PRICE = "totalSourcePrice";
  private Moneys totalSourcePrice;

  public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE = "totalCapturePrice";
  private Moneys totalCapturePrice;

  public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_REFUND = "totalDisplayPriceAfterRefund";
  private Moneys totalDisplayPriceAfterRefund;

  public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_REFUND = "totalInternalPriceAfterRefund";
  private Moneys totalInternalPriceAfterRefund;

  public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_REFUND = "totalSupplierPriceAfterRefund";
  private Moneys totalSupplierPriceAfterRefund;

  public static final String JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_REFUND = "totalSourcePriceAfterRefund";
  private Moneys totalSourcePriceAfterRefund;

  public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_REFUND = "totalCapturePriceAfterRefund";
  private Moneys totalCapturePriceAfterRefund;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
  private Boolean cancellableByTraveler;

  public static final String JSON_PROPERTY_REFUNDED_CAPTURE_PRICE = "refundedCapturePrice";
  private Moneys refundedCapturePrice;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
  private Boolean cancellableBySupplier;

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES = "cancellableWithNoCharges";
  private Boolean cancellableWithNoCharges;

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES = "cancellableWithPotentialCharges";
  private Boolean cancellableWithPotentialCharges;

  public static final String JSON_PROPERTY_LODGING = "lodging";
  private BookingContractItem lodging;

  public static final String JSON_PROPERTY_REFUNDED_DISPLAY_PRICE = "refundedDisplayPrice";
  private Moneys refundedDisplayPrice;

  public static final String JSON_PROPERTY_REFUNDED_INTERNAL_PRICE = "refundedInternalPrice";
  private Moneys refundedInternalPrice;

  public static final String JSON_PROPERTY_REFUNDED_SUPPLIER_PRICE = "refundedSupplierPrice";
  private Moneys refundedSupplierPrice;

  public static final String JSON_PROPERTY_REFUNDED_SOURCE_PRICE = "refundedSourcePrice";
  private Moneys refundedSourcePrice;

  public static final String JSON_PROPERTY_REFUNDABLE_DISPLAY_PRICE = "refundableDisplayPrice";
  private Boolean refundableDisplayPrice;

  public static final String JSON_PROPERTY_REFUNDABLE_INTERNAL_PRICE = "refundableInternalPrice";
  private Boolean refundableInternalPrice;

  public static final String JSON_PROPERTY_REFUNDABLE_SUPPLIER_PRICE = "refundableSupplierPrice";
  private Boolean refundableSupplierPrice;

  public static final String JSON_PROPERTY_REFUNDABLE_SOURCE_PRICE = "refundableSourcePrice";
  private Boolean refundableSourcePrice;

  public static final String JSON_PROPERTY_REFUNDABLE_CAPTURE_PRICE = "refundableCapturePrice";
  private Boolean refundableCapturePrice;

  public static final String JSON_PROPERTY_TOTAL_TOKENS_EARNED = "totalTokensEarned";
  private Long totalTokensEarned;

  public static final String JSON_PROPERTY_LODGING_ITINERARY = "lodgingItinerary";
  private Itinerary lodgingItinerary;

  public BookingContract() { 
  }

  public BookingContract id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Document UUID
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "doc-1", value = "Document UUID")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public BookingContract createdDate(java.time.LocalDateTime createdDate) {
    
    this.createdDate = createdDate;
    return this;
  }

   /**
   * Datetime this record was first created
   * @return createdDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Datetime this record was first created")
  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCreatedDate() {
    return createdDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedDate(java.time.LocalDateTime createdDate) {
    this.createdDate = createdDate;
  }


  public BookingContract lastUpdate(java.time.LocalDateTime lastUpdate) {
    
    this.lastUpdate = lastUpdate;
    return this;
  }

   /**
   * Datetime this record was last updated
   * @return lastUpdate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Datetime this record was last updated")
  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getLastUpdate() {
    return lastUpdate;
  }


  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastUpdate(java.time.LocalDateTime lastUpdate) {
    this.lastUpdate = lastUpdate;
  }


  public BookingContract version(Long version) {
    
    this.version = version;
    return this;
  }

   /**
   * Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.
   * @return version
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "12", value = "Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(Long version) {
    this.version = version;
  }


  public BookingContract ipAddress(String ipAddress) {
    
    this.ipAddress = ipAddress;
    return this;
  }

   /**
   * Caller&#39;s IP address
   * @return ipAddress
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "111.222.333.444", required = true, value = "Caller's IP address")
  @JsonProperty(JSON_PROPERTY_IP_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIpAddress() {
    return ipAddress;
  }


  @JsonProperty(JSON_PROPERTY_IP_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIpAddress(String ipAddress) {
    this.ipAddress = ipAddress;
  }


  public BookingContract traceId(String traceId) {
    
    this.traceId = traceId;
    return this;
  }

   /**
   * Way to track which booking contracts were made together
   * @return traceId
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "T-123456", required = true, value = "Way to track which booking contracts were made together")
  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTraceId() {
    return traceId;
  }


  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTraceId(String traceId) {
    this.traceId = traceId;
  }


  public BookingContract sourceUrl(String sourceUrl) {
    
    this.sourceUrl = sourceUrl;
    return this;
  }

   /**
   * Where did the booking occur
   * @return sourceUrl
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "https://www.traveliko.com", required = true, value = "Where did the booking occur")
  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSourceUrl() {
    return sourceUrl;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceUrl(String sourceUrl) {
    this.sourceUrl = sourceUrl;
  }


  public BookingContract identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique identifier used to track the contract.
   * @return identifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "unique-supplier-booking-contract-1", required = true, value = "Unique identifier used to track the contract.")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public BookingContract supplierIdentifier(UUID supplierIdentifier) {
    
    this.supplierIdentifier = supplierIdentifier;
    return this;
  }

   /**
   * Supplier identifier
   * @return supplierIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Supplier identifier")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getSupplierIdentifier() {
    return supplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierIdentifier(UUID supplierIdentifier) {
    this.supplierIdentifier = supplierIdentifier;
  }


  public BookingContract supplierName(String supplierName) {
    
    this.supplierName = supplierName;
    return this;
  }

   /**
   * Supplier name
   * @return supplierName
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Supplier One", required = true, value = "Supplier name")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierName() {
    return supplierName;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierName(String supplierName) {
    this.supplierName = supplierName;
  }


  public BookingContract displayPriceQuote(Quote displayPriceQuote) {
    
    this.displayPriceQuote = displayPriceQuote;
    return this;
  }

   /**
   * Get displayPriceQuote
   * @return displayPriceQuote
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Quote getDisplayPriceQuote() {
    return displayPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayPriceQuote(Quote displayPriceQuote) {
    this.displayPriceQuote = displayPriceQuote;
  }


  public BookingContract supplierPriceQuote(Quote supplierPriceQuote) {
    
    this.supplierPriceQuote = supplierPriceQuote;
    return this;
  }

   /**
   * Get supplierPriceQuote
   * @return supplierPriceQuote
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Quote getSupplierPriceQuote() {
    return supplierPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierPriceQuote(Quote supplierPriceQuote) {
    this.supplierPriceQuote = supplierPriceQuote;
  }


  public BookingContract internalPriceQuote(Quote internalPriceQuote) {
    
    this.internalPriceQuote = internalPriceQuote;
    return this;
  }

   /**
   * Get internalPriceQuote
   * @return internalPriceQuote
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Quote getInternalPriceQuote() {
    return internalPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalPriceQuote(Quote internalPriceQuote) {
    this.internalPriceQuote = internalPriceQuote;
  }


  public BookingContract capturePriceQuote(Quote capturePriceQuote) {
    
    this.capturePriceQuote = capturePriceQuote;
    return this;
  }

   /**
   * Get capturePriceQuote
   * @return capturePriceQuote
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Quote getCapturePriceQuote() {
    return capturePriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCapturePriceQuote(Quote capturePriceQuote) {
    this.capturePriceQuote = capturePriceQuote;
  }


  public BookingContract itemList(List<BookingContractItem> itemList) {
    
    this.itemList = itemList;
    return this;
  }

  public BookingContract addItemListItem(BookingContractItem itemListItem) {
    this.itemList.add(itemListItem);
    return this;
  }

   /**
   * Holds one booking line item for a specific supplier.
   * @return itemList
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)  @ApiModelProperty(required = true, value = "Holds one booking line item for a specific supplier.")
  @JsonProperty(JSON_PROPERTY_ITEM_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<BookingContractItem> getItemList() {
    return itemList;
  }


  @JsonProperty(JSON_PROPERTY_ITEM_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setItemList(List<BookingContractItem> itemList) {
    this.itemList = itemList;
  }


  public BookingContract externalSupplierIdentifier(String externalSupplierIdentifier) {
    
    this.externalSupplierIdentifier = externalSupplierIdentifier;
    return this;
  }

   /**
   * Contract creator can choose to geoname this record with her own identifier
   * @return externalSupplierIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "supplier-a", value = "Contract creator can choose to geoname this record with her own identifier")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalSupplierIdentifier() {
    return externalSupplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalSupplierIdentifier(String externalSupplierIdentifier) {
    this.externalSupplierIdentifier = externalSupplierIdentifier;
  }


  public BookingContract externalSupplierBookingCode(String externalSupplierBookingCode) {
    
    this.externalSupplierBookingCode = externalSupplierBookingCode;
    return this;
  }

   /**
   * External booking code generated by the caller
   * @return externalSupplierBookingCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "external-booking-code-1", value = "External booking code generated by the caller")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalSupplierBookingCode() {
    return externalSupplierBookingCode;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalSupplierBookingCode(String externalSupplierBookingCode) {
    this.externalSupplierBookingCode = externalSupplierBookingCode;
  }


  public BookingContract payment(BookingContractPaymentDetails payment) {
    
    this.payment = payment;
    return this;
  }

   /**
   * Get payment
   * @return payment
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingContractPaymentDetails getPayment() {
    return payment;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPayment(BookingContractPaymentDetails payment) {
    this.payment = payment;
  }


  public BookingContract cancelled(Boolean cancelled) {
    
    this.cancelled = cancelled;
    return this;
  }

   /**
   * Whether the booking was cancelled.
   * @return cancelled
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "false", required = true, value = "Whether the booking was cancelled.")
  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCancelled() {
    return cancelled;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCancelled(Boolean cancelled) {
    this.cancelled = cancelled;
  }


  public BookingContract cancelledOn(java.time.LocalDateTime cancelledOn) {
    
    this.cancelledOn = cancelledOn;
    return this;
  }

   /**
   * When the booking was cancelled.
   * @return cancelledOn
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "When the booking was cancelled.")
  @JsonProperty(JSON_PROPERTY_CANCELLED_ON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCancelledOn() {
    return cancelledOn;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED_ON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelledOn(java.time.LocalDateTime cancelledOn) {
    this.cancelledOn = cancelledOn;
  }


  public BookingContract canceller(CancellerEnum canceller) {
    
    this.canceller = canceller;
    return this;
  }

   /**
   * Type of entity that cancelled the booking.
   * @return canceller
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Type of entity that cancelled the booking.")
  @JsonProperty(JSON_PROPERTY_CANCELLER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellerEnum getCanceller() {
    return canceller;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCanceller(CancellerEnum canceller) {
    this.canceller = canceller;
  }


  public BookingContract cancellationType(CancellationTypeEnum cancellationType) {
    
    this.cancellationType = cancellationType;
    return this;
  }

   /**
   * Reason type.
   * @return cancellationType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Reason type.")
  @JsonProperty(JSON_PROPERTY_CANCELLATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellationTypeEnum getCancellationType() {
    return cancellationType;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellationType(CancellationTypeEnum cancellationType) {
    this.cancellationType = cancellationType;
  }


  public BookingContract cancellerUserIdentifier(String cancellerUserIdentifier) {
    
    this.cancellerUserIdentifier = cancellerUserIdentifier;
    return this;
  }

   /**
   * User identifier that cancelled the entity.
   * @return cancellerUserIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "User identifier that cancelled the entity.")
  @JsonProperty(JSON_PROPERTY_CANCELLER_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCancellerUserIdentifier() {
    return cancellerUserIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLER_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellerUserIdentifier(String cancellerUserIdentifier) {
    this.cancellerUserIdentifier = cancellerUserIdentifier;
  }


  public BookingContract cancelReason(String cancelReason) {
    
    this.cancelReason = cancelReason;
    return this;
  }

   /**
   * Reason for cancellation.
   * @return cancelReason
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Reason for cancellation.")
  @JsonProperty(JSON_PROPERTY_CANCEL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCancelReason() {
    return cancelReason;
  }


  @JsonProperty(JSON_PROPERTY_CANCEL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelReason(String cancelReason) {
    this.cancelReason = cancelReason;
  }


  public BookingContract fundsAddedToLedger(Boolean fundsAddedToLedger) {
    
    this.fundsAddedToLedger = fundsAddedToLedger;
    return this;
  }

   /**
   * Whether the contract has been added to the ledger; rady for payout.
   * @return fundsAddedToLedger
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Whether the contract has been added to the ledger; rady for payout.")
  @JsonProperty(JSON_PROPERTY_FUNDS_ADDED_TO_LEDGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFundsAddedToLedger() {
    return fundsAddedToLedger;
  }


  @JsonProperty(JSON_PROPERTY_FUNDS_ADDED_TO_LEDGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundsAddedToLedger(Boolean fundsAddedToLedger) {
    this.fundsAddedToLedger = fundsAddedToLedger;
  }


  public BookingContract fundsProcessed(Boolean fundsProcessed) {
    
    this.fundsProcessed = fundsProcessed;
    return this;
  }

   /**
   * Whether a funds transfer request has been created for this booking.
   * @return fundsProcessed
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Whether a funds transfer request has been created for this booking.")
  @JsonProperty(JSON_PROPERTY_FUNDS_PROCESSED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFundsProcessed() {
    return fundsProcessed;
  }


  @JsonProperty(JSON_PROPERTY_FUNDS_PROCESSED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundsProcessed(Boolean fundsProcessed) {
    this.fundsProcessed = fundsProcessed;
  }


  public BookingContract refunds(List<Refund> refunds) {
    
    this.refunds = refunds;
    return this;
  }

  public BookingContract addRefundsItem(Refund refundsItem) {
    if (this.refunds == null) {
      this.refunds = new ArrayList<>();
    }
    this.refunds.add(refundsItem);
    return this;
  }

   /**
   * An optional list of refunds that occurred with this booking. If the refund amount(s) is the same as the total price, the booking also gets cancelled.
   * @return refunds
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "An optional list of refunds that occurred with this booking. If the refund amount(s) is the same as the total price, the booking also gets cancelled.")
  @JsonProperty(JSON_PROPERTY_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Refund> getRefunds() {
    return refunds;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefunds(List<Refund> refunds) {
    this.refunds = refunds;
  }


  public BookingContract totalDisplayPrice(Moneys totalDisplayPrice) {
    
    this.totalDisplayPrice = totalDisplayPrice;
    return this;
  }

   /**
   * Get totalDisplayPrice
   * @return totalDisplayPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalDisplayPrice() {
    return totalDisplayPrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalDisplayPrice(Moneys totalDisplayPrice) {
    this.totalDisplayPrice = totalDisplayPrice;
  }


  public BookingContract totalInternalPrice(Moneys totalInternalPrice) {
    
    this.totalInternalPrice = totalInternalPrice;
    return this;
  }

   /**
   * Get totalInternalPrice
   * @return totalInternalPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalInternalPrice() {
    return totalInternalPrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalInternalPrice(Moneys totalInternalPrice) {
    this.totalInternalPrice = totalInternalPrice;
  }


  public BookingContract totalSupplierPrice(Moneys totalSupplierPrice) {
    
    this.totalSupplierPrice = totalSupplierPrice;
    return this;
  }

   /**
   * Get totalSupplierPrice
   * @return totalSupplierPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalSupplierPrice() {
    return totalSupplierPrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSupplierPrice(Moneys totalSupplierPrice) {
    this.totalSupplierPrice = totalSupplierPrice;
  }


  public BookingContract totalSourcePrice(Moneys totalSourcePrice) {
    
    this.totalSourcePrice = totalSourcePrice;
    return this;
  }

   /**
   * Get totalSourcePrice
   * @return totalSourcePrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_SOURCE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalSourcePrice() {
    return totalSourcePrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SOURCE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSourcePrice(Moneys totalSourcePrice) {
    this.totalSourcePrice = totalSourcePrice;
  }


  public BookingContract totalCapturePrice(Moneys totalCapturePrice) {
    
    this.totalCapturePrice = totalCapturePrice;
    return this;
  }

   /**
   * Get totalCapturePrice
   * @return totalCapturePrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalCapturePrice() {
    return totalCapturePrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalCapturePrice(Moneys totalCapturePrice) {
    this.totalCapturePrice = totalCapturePrice;
  }


  public BookingContract totalDisplayPriceAfterRefund(Moneys totalDisplayPriceAfterRefund) {
    
    this.totalDisplayPriceAfterRefund = totalDisplayPriceAfterRefund;
    return this;
  }

   /**
   * Get totalDisplayPriceAfterRefund
   * @return totalDisplayPriceAfterRefund
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalDisplayPriceAfterRefund() {
    return totalDisplayPriceAfterRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalDisplayPriceAfterRefund(Moneys totalDisplayPriceAfterRefund) {
    this.totalDisplayPriceAfterRefund = totalDisplayPriceAfterRefund;
  }


  public BookingContract totalInternalPriceAfterRefund(Moneys totalInternalPriceAfterRefund) {
    
    this.totalInternalPriceAfterRefund = totalInternalPriceAfterRefund;
    return this;
  }

   /**
   * Get totalInternalPriceAfterRefund
   * @return totalInternalPriceAfterRefund
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalInternalPriceAfterRefund() {
    return totalInternalPriceAfterRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalInternalPriceAfterRefund(Moneys totalInternalPriceAfterRefund) {
    this.totalInternalPriceAfterRefund = totalInternalPriceAfterRefund;
  }


  public BookingContract totalSupplierPriceAfterRefund(Moneys totalSupplierPriceAfterRefund) {
    
    this.totalSupplierPriceAfterRefund = totalSupplierPriceAfterRefund;
    return this;
  }

   /**
   * Get totalSupplierPriceAfterRefund
   * @return totalSupplierPriceAfterRefund
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalSupplierPriceAfterRefund() {
    return totalSupplierPriceAfterRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSupplierPriceAfterRefund(Moneys totalSupplierPriceAfterRefund) {
    this.totalSupplierPriceAfterRefund = totalSupplierPriceAfterRefund;
  }


  public BookingContract totalSourcePriceAfterRefund(Moneys totalSourcePriceAfterRefund) {
    
    this.totalSourcePriceAfterRefund = totalSourcePriceAfterRefund;
    return this;
  }

   /**
   * Get totalSourcePriceAfterRefund
   * @return totalSourcePriceAfterRefund
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalSourcePriceAfterRefund() {
    return totalSourcePriceAfterRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSourcePriceAfterRefund(Moneys totalSourcePriceAfterRefund) {
    this.totalSourcePriceAfterRefund = totalSourcePriceAfterRefund;
  }


  public BookingContract totalCapturePriceAfterRefund(Moneys totalCapturePriceAfterRefund) {
    
    this.totalCapturePriceAfterRefund = totalCapturePriceAfterRefund;
    return this;
  }

   /**
   * Get totalCapturePriceAfterRefund
   * @return totalCapturePriceAfterRefund
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalCapturePriceAfterRefund() {
    return totalCapturePriceAfterRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalCapturePriceAfterRefund(Moneys totalCapturePriceAfterRefund) {
    this.totalCapturePriceAfterRefund = totalCapturePriceAfterRefund;
  }


  public BookingContract cancellableByTraveler(Boolean cancellableByTraveler) {
    
    this.cancellableByTraveler = cancellableByTraveler;
    return this;
  }

   /**
   * Whether the booking can still be cancelled completely by the traveller.
   * @return cancellableByTraveler
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether the booking can still be cancelled completely by the traveller.")
  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByTraveler() {
    return cancellableByTraveler;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByTraveler(Boolean cancellableByTraveler) {
    this.cancellableByTraveler = cancellableByTraveler;
  }


  public BookingContract refundedCapturePrice(Moneys refundedCapturePrice) {
    
    this.refundedCapturePrice = refundedCapturePrice;
    return this;
  }

   /**
   * Get refundedCapturePrice
   * @return refundedCapturePrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REFUNDED_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getRefundedCapturePrice() {
    return refundedCapturePrice;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDED_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundedCapturePrice(Moneys refundedCapturePrice) {
    this.refundedCapturePrice = refundedCapturePrice;
  }


  public BookingContract cancellableBySupplier(Boolean cancellableBySupplier) {
    
    this.cancellableBySupplier = cancellableBySupplier;
    return this;
  }

   /**
   * Whether the booking can still be cancelled completely by the supplier.
   * @return cancellableBySupplier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether the booking can still be cancelled completely by the supplier.")
  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableBySupplier() {
    return cancellableBySupplier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableBySupplier(Boolean cancellableBySupplier) {
    this.cancellableBySupplier = cancellableBySupplier;
  }


  public BookingContract cancellableWithNoCharges(Boolean cancellableWithNoCharges) {
    
    this.cancellableWithNoCharges = cancellableWithNoCharges;
    return this;
  }

   /**
   * Whether the cancellation comes at no cost to the traveler.
   * @return cancellableWithNoCharges
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether the cancellation comes at no cost to the traveler.")
  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithNoCharges() {
    return cancellableWithNoCharges;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithNoCharges(Boolean cancellableWithNoCharges) {
    this.cancellableWithNoCharges = cancellableWithNoCharges;
  }


  public BookingContract cancellableWithPotentialCharges(Boolean cancellableWithPotentialCharges) {
    
    this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
    return this;
  }

   /**
   * Whether a cancellation comes with partial charges. I.e. Only some of the items in contract are not fully refundable.
   * @return cancellableWithPotentialCharges
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether a cancellation comes with partial charges. I.e. Only some of the items in contract are not fully refundable.")
  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithPotentialCharges() {
    return cancellableWithPotentialCharges;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithPotentialCharges(Boolean cancellableWithPotentialCharges) {
    this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
  }


  public BookingContract lodging(BookingContractItem lodging) {
    
    this.lodging = lodging;
    return this;
  }

   /**
   * Get lodging
   * @return lodging
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LODGING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BookingContractItem getLodging() {
    return lodging;
  }


  @JsonProperty(JSON_PROPERTY_LODGING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLodging(BookingContractItem lodging) {
    this.lodging = lodging;
  }


  public BookingContract refundedDisplayPrice(Moneys refundedDisplayPrice) {
    
    this.refundedDisplayPrice = refundedDisplayPrice;
    return this;
  }

   /**
   * Get refundedDisplayPrice
   * @return refundedDisplayPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REFUNDED_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getRefundedDisplayPrice() {
    return refundedDisplayPrice;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDED_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundedDisplayPrice(Moneys refundedDisplayPrice) {
    this.refundedDisplayPrice = refundedDisplayPrice;
  }


  public BookingContract refundedInternalPrice(Moneys refundedInternalPrice) {
    
    this.refundedInternalPrice = refundedInternalPrice;
    return this;
  }

   /**
   * Get refundedInternalPrice
   * @return refundedInternalPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REFUNDED_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getRefundedInternalPrice() {
    return refundedInternalPrice;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDED_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundedInternalPrice(Moneys refundedInternalPrice) {
    this.refundedInternalPrice = refundedInternalPrice;
  }


  public BookingContract refundedSupplierPrice(Moneys refundedSupplierPrice) {
    
    this.refundedSupplierPrice = refundedSupplierPrice;
    return this;
  }

   /**
   * Get refundedSupplierPrice
   * @return refundedSupplierPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REFUNDED_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getRefundedSupplierPrice() {
    return refundedSupplierPrice;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDED_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundedSupplierPrice(Moneys refundedSupplierPrice) {
    this.refundedSupplierPrice = refundedSupplierPrice;
  }


  public BookingContract refundedSourcePrice(Moneys refundedSourcePrice) {
    
    this.refundedSourcePrice = refundedSourcePrice;
    return this;
  }

   /**
   * Get refundedSourcePrice
   * @return refundedSourcePrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REFUNDED_SOURCE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getRefundedSourcePrice() {
    return refundedSourcePrice;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDED_SOURCE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundedSourcePrice(Moneys refundedSourcePrice) {
    this.refundedSourcePrice = refundedSourcePrice;
  }


  public BookingContract refundableDisplayPrice(Boolean refundableDisplayPrice) {
    
    this.refundableDisplayPrice = refundableDisplayPrice;
    return this;
  }

   /**
   * Get refundableDisplayPrice
   * @return refundableDisplayPrice
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REFUNDABLE_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRefundableDisplayPrice() {
    return refundableDisplayPrice;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDABLE_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundableDisplayPrice(Boolean refundableDisplayPrice) {
    this.refundableDisplayPrice = refundableDisplayPrice;
  }


  public BookingContract refundableInternalPrice(Boolean refundableInternalPrice) {
    
    this.refundableInternalPrice = refundableInternalPrice;
    return this;
  }

   /**
   * Get refundableInternalPrice
   * @return refundableInternalPrice
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REFUNDABLE_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRefundableInternalPrice() {
    return refundableInternalPrice;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDABLE_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundableInternalPrice(Boolean refundableInternalPrice) {
    this.refundableInternalPrice = refundableInternalPrice;
  }


  public BookingContract refundableSupplierPrice(Boolean refundableSupplierPrice) {
    
    this.refundableSupplierPrice = refundableSupplierPrice;
    return this;
  }

   /**
   * Get refundableSupplierPrice
   * @return refundableSupplierPrice
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REFUNDABLE_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRefundableSupplierPrice() {
    return refundableSupplierPrice;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDABLE_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundableSupplierPrice(Boolean refundableSupplierPrice) {
    this.refundableSupplierPrice = refundableSupplierPrice;
  }


  public BookingContract refundableSourcePrice(Boolean refundableSourcePrice) {
    
    this.refundableSourcePrice = refundableSourcePrice;
    return this;
  }

   /**
   * Get refundableSourcePrice
   * @return refundableSourcePrice
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REFUNDABLE_SOURCE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRefundableSourcePrice() {
    return refundableSourcePrice;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDABLE_SOURCE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundableSourcePrice(Boolean refundableSourcePrice) {
    this.refundableSourcePrice = refundableSourcePrice;
  }


  public BookingContract refundableCapturePrice(Boolean refundableCapturePrice) {
    
    this.refundableCapturePrice = refundableCapturePrice;
    return this;
  }

   /**
   * Get refundableCapturePrice
   * @return refundableCapturePrice
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REFUNDABLE_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRefundableCapturePrice() {
    return refundableCapturePrice;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDABLE_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundableCapturePrice(Boolean refundableCapturePrice) {
    this.refundableCapturePrice = refundableCapturePrice;
  }


  public BookingContract totalTokensEarned(Long totalTokensEarned) {
    
    this.totalTokensEarned = totalTokensEarned;
    return this;
  }

   /**
   * Total amount of tokens minted on this contract.
   * @return totalTokensEarned
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Total amount of tokens minted on this contract.")
  @JsonProperty(JSON_PROPERTY_TOTAL_TOKENS_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTotalTokensEarned() {
    return totalTokensEarned;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TOKENS_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTokensEarned(Long totalTokensEarned) {
    this.totalTokensEarned = totalTokensEarned;
  }


  public BookingContract lodgingItinerary(Itinerary lodgingItinerary) {
    
    this.lodgingItinerary = lodgingItinerary;
    return this;
  }

   /**
   * Get lodgingItinerary
   * @return lodgingItinerary
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LODGING_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Itinerary getLodgingItinerary() {
    return lodgingItinerary;
  }


  @JsonProperty(JSON_PROPERTY_LODGING_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLodgingItinerary(Itinerary lodgingItinerary) {
    this.lodgingItinerary = lodgingItinerary;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingContract bookingContract = (BookingContract) o;
    return Objects.equals(this.id, bookingContract.id) &&
        Objects.equals(this.createdDate, bookingContract.createdDate) &&
        Objects.equals(this.lastUpdate, bookingContract.lastUpdate) &&
        Objects.equals(this.version, bookingContract.version) &&
        Objects.equals(this.ipAddress, bookingContract.ipAddress) &&
        Objects.equals(this.traceId, bookingContract.traceId) &&
        Objects.equals(this.sourceUrl, bookingContract.sourceUrl) &&
        Objects.equals(this.identifier, bookingContract.identifier) &&
        Objects.equals(this.supplierIdentifier, bookingContract.supplierIdentifier) &&
        Objects.equals(this.supplierName, bookingContract.supplierName) &&
        Objects.equals(this.displayPriceQuote, bookingContract.displayPriceQuote) &&
        Objects.equals(this.supplierPriceQuote, bookingContract.supplierPriceQuote) &&
        Objects.equals(this.internalPriceQuote, bookingContract.internalPriceQuote) &&
        Objects.equals(this.capturePriceQuote, bookingContract.capturePriceQuote) &&
        Objects.equals(this.itemList, bookingContract.itemList) &&
        Objects.equals(this.externalSupplierIdentifier, bookingContract.externalSupplierIdentifier) &&
        Objects.equals(this.externalSupplierBookingCode, bookingContract.externalSupplierBookingCode) &&
        Objects.equals(this.payment, bookingContract.payment) &&
        Objects.equals(this.cancelled, bookingContract.cancelled) &&
        Objects.equals(this.cancelledOn, bookingContract.cancelledOn) &&
        Objects.equals(this.canceller, bookingContract.canceller) &&
        Objects.equals(this.cancellationType, bookingContract.cancellationType) &&
        Objects.equals(this.cancellerUserIdentifier, bookingContract.cancellerUserIdentifier) &&
        Objects.equals(this.cancelReason, bookingContract.cancelReason) &&
        Objects.equals(this.fundsAddedToLedger, bookingContract.fundsAddedToLedger) &&
        Objects.equals(this.fundsProcessed, bookingContract.fundsProcessed) &&
        Objects.equals(this.refunds, bookingContract.refunds) &&
        Objects.equals(this.totalDisplayPrice, bookingContract.totalDisplayPrice) &&
        Objects.equals(this.totalInternalPrice, bookingContract.totalInternalPrice) &&
        Objects.equals(this.totalSupplierPrice, bookingContract.totalSupplierPrice) &&
        Objects.equals(this.totalSourcePrice, bookingContract.totalSourcePrice) &&
        Objects.equals(this.totalCapturePrice, bookingContract.totalCapturePrice) &&
        Objects.equals(this.totalDisplayPriceAfterRefund, bookingContract.totalDisplayPriceAfterRefund) &&
        Objects.equals(this.totalInternalPriceAfterRefund, bookingContract.totalInternalPriceAfterRefund) &&
        Objects.equals(this.totalSupplierPriceAfterRefund, bookingContract.totalSupplierPriceAfterRefund) &&
        Objects.equals(this.totalSourcePriceAfterRefund, bookingContract.totalSourcePriceAfterRefund) &&
        Objects.equals(this.totalCapturePriceAfterRefund, bookingContract.totalCapturePriceAfterRefund) &&
        Objects.equals(this.cancellableByTraveler, bookingContract.cancellableByTraveler) &&
        Objects.equals(this.refundedCapturePrice, bookingContract.refundedCapturePrice) &&
        Objects.equals(this.cancellableBySupplier, bookingContract.cancellableBySupplier) &&
        Objects.equals(this.cancellableWithNoCharges, bookingContract.cancellableWithNoCharges) &&
        Objects.equals(this.cancellableWithPotentialCharges, bookingContract.cancellableWithPotentialCharges) &&
        Objects.equals(this.lodging, bookingContract.lodging) &&
        Objects.equals(this.refundedDisplayPrice, bookingContract.refundedDisplayPrice) &&
        Objects.equals(this.refundedInternalPrice, bookingContract.refundedInternalPrice) &&
        Objects.equals(this.refundedSupplierPrice, bookingContract.refundedSupplierPrice) &&
        Objects.equals(this.refundedSourcePrice, bookingContract.refundedSourcePrice) &&
        Objects.equals(this.refundableDisplayPrice, bookingContract.refundableDisplayPrice) &&
        Objects.equals(this.refundableInternalPrice, bookingContract.refundableInternalPrice) &&
        Objects.equals(this.refundableSupplierPrice, bookingContract.refundableSupplierPrice) &&
        Objects.equals(this.refundableSourcePrice, bookingContract.refundableSourcePrice) &&
        Objects.equals(this.refundableCapturePrice, bookingContract.refundableCapturePrice) &&
        Objects.equals(this.totalTokensEarned, bookingContract.totalTokensEarned) &&
        Objects.equals(this.lodgingItinerary, bookingContract.lodgingItinerary);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdDate, lastUpdate, version, ipAddress, traceId, sourceUrl, identifier, supplierIdentifier, supplierName, displayPriceQuote, supplierPriceQuote, internalPriceQuote, capturePriceQuote, itemList, externalSupplierIdentifier, externalSupplierBookingCode, payment, cancelled, cancelledOn, canceller, cancellationType, cancellerUserIdentifier, cancelReason, fundsAddedToLedger, fundsProcessed, refunds, totalDisplayPrice, totalInternalPrice, totalSupplierPrice, totalSourcePrice, totalCapturePrice, totalDisplayPriceAfterRefund, totalInternalPriceAfterRefund, totalSupplierPriceAfterRefund, totalSourcePriceAfterRefund, totalCapturePriceAfterRefund, cancellableByTraveler, refundedCapturePrice, cancellableBySupplier, cancellableWithNoCharges, cancellableWithPotentialCharges, lodging, refundedDisplayPrice, refundedInternalPrice, refundedSupplierPrice, refundedSourcePrice, refundableDisplayPrice, refundableInternalPrice, refundableSupplierPrice, refundableSourcePrice, refundableCapturePrice, totalTokensEarned, lodgingItinerary);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingContract {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    ipAddress: ").append(toIndentedString(ipAddress)).append("\n");
    sb.append("    traceId: ").append(toIndentedString(traceId)).append("\n");
    sb.append("    sourceUrl: ").append(toIndentedString(sourceUrl)).append("\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    supplierName: ").append(toIndentedString(supplierName)).append("\n");
    sb.append("    displayPriceQuote: ").append(toIndentedString(displayPriceQuote)).append("\n");
    sb.append("    supplierPriceQuote: ").append(toIndentedString(supplierPriceQuote)).append("\n");
    sb.append("    internalPriceQuote: ").append(toIndentedString(internalPriceQuote)).append("\n");
    sb.append("    capturePriceQuote: ").append(toIndentedString(capturePriceQuote)).append("\n");
    sb.append("    itemList: ").append(toIndentedString(itemList)).append("\n");
    sb.append("    externalSupplierIdentifier: ").append(toIndentedString(externalSupplierIdentifier)).append("\n");
    sb.append("    externalSupplierBookingCode: ").append(toIndentedString(externalSupplierBookingCode)).append("\n");
    sb.append("    payment: ").append(toIndentedString(payment)).append("\n");
    sb.append("    cancelled: ").append(toIndentedString(cancelled)).append("\n");
    sb.append("    cancelledOn: ").append(toIndentedString(cancelledOn)).append("\n");
    sb.append("    canceller: ").append(toIndentedString(canceller)).append("\n");
    sb.append("    cancellationType: ").append(toIndentedString(cancellationType)).append("\n");
    sb.append("    cancellerUserIdentifier: ").append(toIndentedString(cancellerUserIdentifier)).append("\n");
    sb.append("    cancelReason: ").append(toIndentedString(cancelReason)).append("\n");
    sb.append("    fundsAddedToLedger: ").append(toIndentedString(fundsAddedToLedger)).append("\n");
    sb.append("    fundsProcessed: ").append(toIndentedString(fundsProcessed)).append("\n");
    sb.append("    refunds: ").append(toIndentedString(refunds)).append("\n");
    sb.append("    totalDisplayPrice: ").append(toIndentedString(totalDisplayPrice)).append("\n");
    sb.append("    totalInternalPrice: ").append(toIndentedString(totalInternalPrice)).append("\n");
    sb.append("    totalSupplierPrice: ").append(toIndentedString(totalSupplierPrice)).append("\n");
    sb.append("    totalSourcePrice: ").append(toIndentedString(totalSourcePrice)).append("\n");
    sb.append("    totalCapturePrice: ").append(toIndentedString(totalCapturePrice)).append("\n");
    sb.append("    totalDisplayPriceAfterRefund: ").append(toIndentedString(totalDisplayPriceAfterRefund)).append("\n");
    sb.append("    totalInternalPriceAfterRefund: ").append(toIndentedString(totalInternalPriceAfterRefund)).append("\n");
    sb.append("    totalSupplierPriceAfterRefund: ").append(toIndentedString(totalSupplierPriceAfterRefund)).append("\n");
    sb.append("    totalSourcePriceAfterRefund: ").append(toIndentedString(totalSourcePriceAfterRefund)).append("\n");
    sb.append("    totalCapturePriceAfterRefund: ").append(toIndentedString(totalCapturePriceAfterRefund)).append("\n");
    sb.append("    cancellableByTraveler: ").append(toIndentedString(cancellableByTraveler)).append("\n");
    sb.append("    refundedCapturePrice: ").append(toIndentedString(refundedCapturePrice)).append("\n");
    sb.append("    cancellableBySupplier: ").append(toIndentedString(cancellableBySupplier)).append("\n");
    sb.append("    cancellableWithNoCharges: ").append(toIndentedString(cancellableWithNoCharges)).append("\n");
    sb.append("    cancellableWithPotentialCharges: ").append(toIndentedString(cancellableWithPotentialCharges)).append("\n");
    sb.append("    lodging: ").append(toIndentedString(lodging)).append("\n");
    sb.append("    refundedDisplayPrice: ").append(toIndentedString(refundedDisplayPrice)).append("\n");
    sb.append("    refundedInternalPrice: ").append(toIndentedString(refundedInternalPrice)).append("\n");
    sb.append("    refundedSupplierPrice: ").append(toIndentedString(refundedSupplierPrice)).append("\n");
    sb.append("    refundedSourcePrice: ").append(toIndentedString(refundedSourcePrice)).append("\n");
    sb.append("    refundableDisplayPrice: ").append(toIndentedString(refundableDisplayPrice)).append("\n");
    sb.append("    refundableInternalPrice: ").append(toIndentedString(refundableInternalPrice)).append("\n");
    sb.append("    refundableSupplierPrice: ").append(toIndentedString(refundableSupplierPrice)).append("\n");
    sb.append("    refundableSourcePrice: ").append(toIndentedString(refundableSourcePrice)).append("\n");
    sb.append("    refundableCapturePrice: ").append(toIndentedString(refundableCapturePrice)).append("\n");
    sb.append("    totalTokensEarned: ").append(toIndentedString(totalTokensEarned)).append("\n");
    sb.append("    lodgingItinerary: ").append(toIndentedString(lodgingItinerary)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

