package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;

import io.trippay.sdk.payment.model.Account;
import io.trippay.sdk.payment.model.UpdateAccountStatusRequest;
import io.trippay.sdk.payment.model.UpsertAccountAcquirerRequest;
import io.trippay.sdk.payment.model.UpsertAccountTaskRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-18T09:25:43.445028683+07:00[Asia/Bangkok]")
public class AdministrationAccountControllerApi {
    private ApiClient apiClient;

    public AdministrationAccountControllerApi() {
        this(new ApiClient());
    }

    @Autowired
    public AdministrationAccountControllerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Account Acquirer
     * Create account acquirer entry
     * <p><b>201</b> - Created
     * @param id The id parameter
     * @param upsertAccountAcquirerRequest The upsertAccountAcquirerRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createAccountAcquirerRequestCreation(String id, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertAccountAcquirerRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling createAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertAccountAcquirerRequest' is set
        if (upsertAccountAcquirerRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAccountAcquirerRequest' when calling createAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/administration/account/{id}/acquirer", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Account Acquirer
     * Create account acquirer entry
     * <p><b>201</b> - Created
     * @param id The id parameter
     * @param upsertAccountAcquirerRequest The upsertAccountAcquirerRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> createAccountAcquirer(String id, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return createAccountAcquirerRequestCreation(id, upsertAccountAcquirerRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> createAccountAcquirerWithHttpInfo(String id, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return createAccountAcquirerRequestCreation(id, upsertAccountAcquirerRequest, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Create Account Task
     * Create account task entry
     * <p><b>201</b> - Created
     * @param id The id parameter
     * @param upsertAccountTaskRequest The upsertAccountTaskRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createAccountTaskRequestCreation(String id, UpsertAccountTaskRequest upsertAccountTaskRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertAccountTaskRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling createAccountTask", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertAccountTaskRequest' is set
        if (upsertAccountTaskRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAccountTaskRequest' when calling createAccountTask", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/administration/account/{id}/task", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Account Task
     * Create account task entry
     * <p><b>201</b> - Created
     * @param id The id parameter
     * @param upsertAccountTaskRequest The upsertAccountTaskRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> createAccountTask(String id, UpsertAccountTaskRequest upsertAccountTaskRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return createAccountTaskRequestCreation(id, upsertAccountTaskRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> createAccountTaskWithHttpInfo(String id, UpsertAccountTaskRequest upsertAccountTaskRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return createAccountTaskRequestCreation(id, upsertAccountTaskRequest, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Remove Account Acquirer
     * Remove an existing account acquirer entry
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param acquirerId The acquirerId parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeAccountAcquirerRequestCreation(String id, String acquirerId, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acquirerId' is set
        if (acquirerId == null) {
            throw new WebClientResponseException("Missing the required parameter 'acquirerId' when calling removeAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);
        pathParams.put("acquirerId", acquirerId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/administration/account/{id}/acquirer/{acquirerId}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Account Acquirer
     * Remove an existing account acquirer entry
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param acquirerId The acquirerId parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> removeAccountAcquirer(String id, String acquirerId, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return removeAccountAcquirerRequestCreation(id, acquirerId, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> removeAccountAcquirerWithHttpInfo(String id, String acquirerId, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return removeAccountAcquirerRequestCreation(id, acquirerId, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Remove Account Task
     * Remove an existing account task entry
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param taskId The taskId parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeAccountTaskRequestCreation(String id, String taskId, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeAccountTask", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'taskId' is set
        if (taskId == null) {
            throw new WebClientResponseException("Missing the required parameter 'taskId' when calling removeAccountTask", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);
        pathParams.put("taskId", taskId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/administration/account/{id}/task/{taskId}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Account Task
     * Remove an existing account task entry
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param taskId The taskId parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> removeAccountTask(String id, String taskId, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return removeAccountTaskRequestCreation(id, taskId, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> removeAccountTaskWithHttpInfo(String id, String taskId, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return removeAccountTaskRequestCreation(id, taskId, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Update Account Acquirer
     * Update an existing account acquirer entry
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param acquirerId The acquirerId parameter
     * @param upsertAccountAcquirerRequest The upsertAccountAcquirerRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAccountAcquirerRequestCreation(String id, String acquirerId, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertAccountAcquirerRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acquirerId' is set
        if (acquirerId == null) {
            throw new WebClientResponseException("Missing the required parameter 'acquirerId' when calling updateAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertAccountAcquirerRequest' is set
        if (upsertAccountAcquirerRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAccountAcquirerRequest' when calling updateAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);
        pathParams.put("acquirerId", acquirerId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/administration/account/{id}/acquirer/{acquirerId}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Account Acquirer
     * Update an existing account acquirer entry
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param acquirerId The acquirerId parameter
     * @param upsertAccountAcquirerRequest The upsertAccountAcquirerRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> updateAccountAcquirer(String id, String acquirerId, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return updateAccountAcquirerRequestCreation(id, acquirerId, upsertAccountAcquirerRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> updateAccountAcquirerWithHttpInfo(String id, String acquirerId, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return updateAccountAcquirerRequestCreation(id, acquirerId, upsertAccountAcquirerRequest, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Update Account Status
     * Update account status
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param updateAccountStatusRequest The updateAccountStatusRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAccountStatusRequestCreation(String id, UpdateAccountStatusRequest updateAccountStatusRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = updateAccountStatusRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateAccountStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updateAccountStatusRequest' is set
        if (updateAccountStatusRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateAccountStatusRequest' when calling updateAccountStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/administration/account/{id}/status", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Account Status
     * Update account status
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param updateAccountStatusRequest The updateAccountStatusRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> updateAccountStatus(String id, UpdateAccountStatusRequest updateAccountStatusRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return updateAccountStatusRequestCreation(id, updateAccountStatusRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> updateAccountStatusWithHttpInfo(String id, UpdateAccountStatusRequest updateAccountStatusRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return updateAccountStatusRequestCreation(id, updateAccountStatusRequest, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Update Account Task
     * Update an existing account task entry
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param taskId The taskId parameter
     * @param upsertAccountTaskRequest The upsertAccountTaskRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAccountTaskRequestCreation(String id, String taskId, UpsertAccountTaskRequest upsertAccountTaskRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertAccountTaskRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateAccountTask", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'taskId' is set
        if (taskId == null) {
            throw new WebClientResponseException("Missing the required parameter 'taskId' when calling updateAccountTask", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertAccountTaskRequest' is set
        if (upsertAccountTaskRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAccountTaskRequest' when calling updateAccountTask", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);
        pathParams.put("taskId", taskId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/administration/account/{id}/task/{taskId}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Account Task
     * Update an existing account task entry
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param taskId The taskId parameter
     * @param upsertAccountTaskRequest The upsertAccountTaskRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> updateAccountTask(String id, String taskId, UpsertAccountTaskRequest upsertAccountTaskRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return updateAccountTaskRequestCreation(id, taskId, upsertAccountTaskRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> updateAccountTaskWithHttpInfo(String id, String taskId, UpsertAccountTaskRequest upsertAccountTaskRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return updateAccountTaskRequestCreation(id, taskId, upsertAccountTaskRequest, winkVersion).toEntity(localVarReturnType);
    }
}
