/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 24.7.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Aggregate funds for all booking contracts
 */
@ApiModel(description = "Aggregate funds for all booking contracts")
@JsonPropertyOrder({
  TotalAggregateFunds.JSON_PROPERTY_FUNDS_IN_SOURCE_CURRENCY,
  TotalAggregateFunds.JSON_PROPERTY_FUNDS_IN_DISPLAY_CURRENCY,
  TotalAggregateFunds.JSON_PROPERTY_FUNDS_IN_SUPPLIER_CURRENCY,
  TotalAggregateFunds.JSON_PROPERTY_FUNDS_IN_INTERNAL_CURRENCY,
  TotalAggregateFunds.JSON_PROPERTY_FUNDS_IN_CAPTURE_CURRENCY,
  TotalAggregateFunds.JSON_PROPERTY_FUNDS_IN_SOURCE_AMOUNT,
  TotalAggregateFunds.JSON_PROPERTY_FUNDS_IN_DISPLAY_AMOUNT,
  TotalAggregateFunds.JSON_PROPERTY_FUNDS_IN_SUPPLIER_AMOUNT,
  TotalAggregateFunds.JSON_PROPERTY_FUNDS_IN_INTERNAL_AMOUNT,
  TotalAggregateFunds.JSON_PROPERTY_FUNDS_IN_CAPTURE_AMOUNT
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-18T09:25:43.445028683+07:00[Asia/Bangkok]")
public class TotalAggregateFunds {
  public static final String JSON_PROPERTY_FUNDS_IN_SOURCE_CURRENCY = "fundsInSourceCurrency";
  private String fundsInSourceCurrency;

  public static final String JSON_PROPERTY_FUNDS_IN_DISPLAY_CURRENCY = "fundsInDisplayCurrency";
  private String fundsInDisplayCurrency;

  public static final String JSON_PROPERTY_FUNDS_IN_SUPPLIER_CURRENCY = "fundsInSupplierCurrency";
  private String fundsInSupplierCurrency;

  public static final String JSON_PROPERTY_FUNDS_IN_INTERNAL_CURRENCY = "fundsInInternalCurrency";
  private String fundsInInternalCurrency;

  public static final String JSON_PROPERTY_FUNDS_IN_CAPTURE_CURRENCY = "fundsInCaptureCurrency";
  private String fundsInCaptureCurrency;

  public static final String JSON_PROPERTY_FUNDS_IN_SOURCE_AMOUNT = "fundsInSourceAmount";
  private Double fundsInSourceAmount;

  public static final String JSON_PROPERTY_FUNDS_IN_DISPLAY_AMOUNT = "fundsInDisplayAmount";
  private Double fundsInDisplayAmount;

  public static final String JSON_PROPERTY_FUNDS_IN_SUPPLIER_AMOUNT = "fundsInSupplierAmount";
  private Double fundsInSupplierAmount;

  public static final String JSON_PROPERTY_FUNDS_IN_INTERNAL_AMOUNT = "fundsInInternalAmount";
  private Double fundsInInternalAmount;

  public static final String JSON_PROPERTY_FUNDS_IN_CAPTURE_AMOUNT = "fundsInCaptureAmount";
  private Double fundsInCaptureAmount;

  public TotalAggregateFunds() { 
  }

  public TotalAggregateFunds fundsInSourceCurrency(String fundsInSourceCurrency) {
    
    this.fundsInSourceCurrency = fundsInSourceCurrency;
    return this;
  }

   /**
   * Get fundsInSourceCurrency
   * @return fundsInSourceCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FUNDS_IN_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFundsInSourceCurrency() {
    return fundsInSourceCurrency;
  }


  @JsonProperty(JSON_PROPERTY_FUNDS_IN_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundsInSourceCurrency(String fundsInSourceCurrency) {
    this.fundsInSourceCurrency = fundsInSourceCurrency;
  }


  public TotalAggregateFunds fundsInDisplayCurrency(String fundsInDisplayCurrency) {
    
    this.fundsInDisplayCurrency = fundsInDisplayCurrency;
    return this;
  }

   /**
   * Get fundsInDisplayCurrency
   * @return fundsInDisplayCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FUNDS_IN_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFundsInDisplayCurrency() {
    return fundsInDisplayCurrency;
  }


  @JsonProperty(JSON_PROPERTY_FUNDS_IN_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundsInDisplayCurrency(String fundsInDisplayCurrency) {
    this.fundsInDisplayCurrency = fundsInDisplayCurrency;
  }


  public TotalAggregateFunds fundsInSupplierCurrency(String fundsInSupplierCurrency) {
    
    this.fundsInSupplierCurrency = fundsInSupplierCurrency;
    return this;
  }

   /**
   * Get fundsInSupplierCurrency
   * @return fundsInSupplierCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FUNDS_IN_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFundsInSupplierCurrency() {
    return fundsInSupplierCurrency;
  }


  @JsonProperty(JSON_PROPERTY_FUNDS_IN_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundsInSupplierCurrency(String fundsInSupplierCurrency) {
    this.fundsInSupplierCurrency = fundsInSupplierCurrency;
  }


  public TotalAggregateFunds fundsInInternalCurrency(String fundsInInternalCurrency) {
    
    this.fundsInInternalCurrency = fundsInInternalCurrency;
    return this;
  }

   /**
   * Get fundsInInternalCurrency
   * @return fundsInInternalCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FUNDS_IN_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFundsInInternalCurrency() {
    return fundsInInternalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_FUNDS_IN_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundsInInternalCurrency(String fundsInInternalCurrency) {
    this.fundsInInternalCurrency = fundsInInternalCurrency;
  }


  public TotalAggregateFunds fundsInCaptureCurrency(String fundsInCaptureCurrency) {
    
    this.fundsInCaptureCurrency = fundsInCaptureCurrency;
    return this;
  }

   /**
   * Get fundsInCaptureCurrency
   * @return fundsInCaptureCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FUNDS_IN_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFundsInCaptureCurrency() {
    return fundsInCaptureCurrency;
  }


  @JsonProperty(JSON_PROPERTY_FUNDS_IN_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundsInCaptureCurrency(String fundsInCaptureCurrency) {
    this.fundsInCaptureCurrency = fundsInCaptureCurrency;
  }


  public TotalAggregateFunds fundsInSourceAmount(Double fundsInSourceAmount) {
    
    this.fundsInSourceAmount = fundsInSourceAmount;
    return this;
  }

   /**
   * Get fundsInSourceAmount
   * @return fundsInSourceAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FUNDS_IN_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getFundsInSourceAmount() {
    return fundsInSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_FUNDS_IN_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundsInSourceAmount(Double fundsInSourceAmount) {
    this.fundsInSourceAmount = fundsInSourceAmount;
  }


  public TotalAggregateFunds fundsInDisplayAmount(Double fundsInDisplayAmount) {
    
    this.fundsInDisplayAmount = fundsInDisplayAmount;
    return this;
  }

   /**
   * Get fundsInDisplayAmount
   * @return fundsInDisplayAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FUNDS_IN_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getFundsInDisplayAmount() {
    return fundsInDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_FUNDS_IN_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundsInDisplayAmount(Double fundsInDisplayAmount) {
    this.fundsInDisplayAmount = fundsInDisplayAmount;
  }


  public TotalAggregateFunds fundsInSupplierAmount(Double fundsInSupplierAmount) {
    
    this.fundsInSupplierAmount = fundsInSupplierAmount;
    return this;
  }

   /**
   * Get fundsInSupplierAmount
   * @return fundsInSupplierAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FUNDS_IN_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getFundsInSupplierAmount() {
    return fundsInSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_FUNDS_IN_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundsInSupplierAmount(Double fundsInSupplierAmount) {
    this.fundsInSupplierAmount = fundsInSupplierAmount;
  }


  public TotalAggregateFunds fundsInInternalAmount(Double fundsInInternalAmount) {
    
    this.fundsInInternalAmount = fundsInInternalAmount;
    return this;
  }

   /**
   * Get fundsInInternalAmount
   * @return fundsInInternalAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FUNDS_IN_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getFundsInInternalAmount() {
    return fundsInInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_FUNDS_IN_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundsInInternalAmount(Double fundsInInternalAmount) {
    this.fundsInInternalAmount = fundsInInternalAmount;
  }


  public TotalAggregateFunds fundsInCaptureAmount(Double fundsInCaptureAmount) {
    
    this.fundsInCaptureAmount = fundsInCaptureAmount;
    return this;
  }

   /**
   * Get fundsInCaptureAmount
   * @return fundsInCaptureAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FUNDS_IN_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getFundsInCaptureAmount() {
    return fundsInCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_FUNDS_IN_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundsInCaptureAmount(Double fundsInCaptureAmount) {
    this.fundsInCaptureAmount = fundsInCaptureAmount;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TotalAggregateFunds totalAggregateFunds = (TotalAggregateFunds) o;
    return Objects.equals(this.fundsInSourceCurrency, totalAggregateFunds.fundsInSourceCurrency) &&
        Objects.equals(this.fundsInDisplayCurrency, totalAggregateFunds.fundsInDisplayCurrency) &&
        Objects.equals(this.fundsInSupplierCurrency, totalAggregateFunds.fundsInSupplierCurrency) &&
        Objects.equals(this.fundsInInternalCurrency, totalAggregateFunds.fundsInInternalCurrency) &&
        Objects.equals(this.fundsInCaptureCurrency, totalAggregateFunds.fundsInCaptureCurrency) &&
        Objects.equals(this.fundsInSourceAmount, totalAggregateFunds.fundsInSourceAmount) &&
        Objects.equals(this.fundsInDisplayAmount, totalAggregateFunds.fundsInDisplayAmount) &&
        Objects.equals(this.fundsInSupplierAmount, totalAggregateFunds.fundsInSupplierAmount) &&
        Objects.equals(this.fundsInInternalAmount, totalAggregateFunds.fundsInInternalAmount) &&
        Objects.equals(this.fundsInCaptureAmount, totalAggregateFunds.fundsInCaptureAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fundsInSourceCurrency, fundsInDisplayCurrency, fundsInSupplierCurrency, fundsInInternalCurrency, fundsInCaptureCurrency, fundsInSourceAmount, fundsInDisplayAmount, fundsInSupplierAmount, fundsInInternalAmount, fundsInCaptureAmount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TotalAggregateFunds {\n");
    sb.append("    fundsInSourceCurrency: ").append(toIndentedString(fundsInSourceCurrency)).append("\n");
    sb.append("    fundsInDisplayCurrency: ").append(toIndentedString(fundsInDisplayCurrency)).append("\n");
    sb.append("    fundsInSupplierCurrency: ").append(toIndentedString(fundsInSupplierCurrency)).append("\n");
    sb.append("    fundsInInternalCurrency: ").append(toIndentedString(fundsInInternalCurrency)).append("\n");
    sb.append("    fundsInCaptureCurrency: ").append(toIndentedString(fundsInCaptureCurrency)).append("\n");
    sb.append("    fundsInSourceAmount: ").append(toIndentedString(fundsInSourceAmount)).append("\n");
    sb.append("    fundsInDisplayAmount: ").append(toIndentedString(fundsInDisplayAmount)).append("\n");
    sb.append("    fundsInSupplierAmount: ").append(toIndentedString(fundsInSupplierAmount)).append("\n");
    sb.append("    fundsInInternalAmount: ").append(toIndentedString(fundsInInternalAmount)).append("\n");
    sb.append("    fundsInCaptureAmount: ").append(toIndentedString(fundsInCaptureAmount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

