/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Country")
@JsonPropertyOrder(value={"iso", "iso3", "isoNumeric", "fips", "name", "capital", "area", "population", "continent", "topLevelDomain", "currencyCode", "currencyName", "phone", "postalCodeFormat", "postalCodeRegEx", "languages", "geoNameId", "neighbors"})
public class Country {
    public static final String JSON_PROPERTY_ISO = "iso";
    private String iso;
    public static final String JSON_PROPERTY_ISO3 = "iso3";
    private String iso3;
    public static final String JSON_PROPERTY_ISO_NUMERIC = "isoNumeric";
    private Integer isoNumeric;
    public static final String JSON_PROPERTY_FIPS = "fips";
    private String fips;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_CAPITAL = "capital";
    private String capital;
    public static final String JSON_PROPERTY_AREA = "area";
    private Float area;
    public static final String JSON_PROPERTY_POPULATION = "population";
    private Long population;
    public static final String JSON_PROPERTY_CONTINENT = "continent";
    private String continent;
    public static final String JSON_PROPERTY_TOP_LEVEL_DOMAIN = "topLevelDomain";
    private String topLevelDomain;
    public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
    private String currencyCode;
    public static final String JSON_PROPERTY_CURRENCY_NAME = "currencyName";
    private String currencyName;
    public static final String JSON_PROPERTY_PHONE = "phone";
    private String phone;
    public static final String JSON_PROPERTY_POSTAL_CODE_FORMAT = "postalCodeFormat";
    private String postalCodeFormat;
    public static final String JSON_PROPERTY_POSTAL_CODE_REG_EX = "postalCodeRegEx";
    private String postalCodeRegEx;
    public static final String JSON_PROPERTY_LANGUAGES = "languages";
    private List<String> languages = null;
    public static final String JSON_PROPERTY_GEO_NAME_ID = "geoNameId";
    private String geoNameId;
    public static final String JSON_PROPERTY_NEIGHBORS = "neighbors";
    private List<String> neighbors = null;

    public Country iso(String iso) {
        this.iso = iso;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="US", value="ISO code")
    @JsonProperty(value="iso")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIso() {
        return this.iso;
    }

    @JsonProperty(value="iso")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIso(String iso) {
        this.iso = iso;
    }

    public Country iso3(String iso3) {
        this.iso3 = iso3;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="USA", value="3 character ISO code")
    @JsonProperty(value="iso3")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIso3() {
        return this.iso3;
    }

    @JsonProperty(value="iso3")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIso3(String iso3) {
        this.iso3 = iso3;
    }

    public Country isoNumeric(Integer isoNumeric) {
        this.isoNumeric = isoNumeric;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="840", value="Numeric ISO code")
    @JsonProperty(value="isoNumeric")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getIsoNumeric() {
        return this.isoNumeric;
    }

    @JsonProperty(value="isoNumeric")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsoNumeric(Integer isoNumeric) {
        this.isoNumeric = isoNumeric;
    }

    public Country fips(String fips) {
        this.fips = fips;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="US", value="FIPS country code")
    @JsonProperty(value="fips")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFips() {
        return this.fips;
    }

    @JsonProperty(value="fips")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFips(String fips) {
        this.fips = fips;
    }

    public Country name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="United States", value="Country name")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public Country capital(String capital) {
        this.capital = capital;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Washington", value="Country capital")
    @JsonProperty(value="capital")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCapital() {
        return this.capital;
    }

    @JsonProperty(value="capital")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCapital(String capital) {
        this.capital = capital;
    }

    public Country area(Float area) {
        this.area = area;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="9629091.0", value="Area in square kilometers")
    @JsonProperty(value="area")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getArea() {
        return this.area;
    }

    @JsonProperty(value="area")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setArea(Float area) {
        this.area = area;
    }

    public Country population(Long population) {
        this.population = population;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="310232863", value="Country population")
    @JsonProperty(value="population")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getPopulation() {
        return this.population;
    }

    @JsonProperty(value="population")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPopulation(Long population) {
        this.population = population;
    }

    public Country continent(String continent) {
        this.continent = continent;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="NA", value="Continent code")
    @JsonProperty(value="continent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContinent() {
        return this.continent;
    }

    @JsonProperty(value="continent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContinent(String continent) {
        this.continent = continent;
    }

    public Country topLevelDomain(String topLevelDomain) {
        this.topLevelDomain = topLevelDomain;
        return this;
    }

    @Nullable
    @ApiModelProperty(example=".us", value="Country TLD")
    @JsonProperty(value="topLevelDomain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTopLevelDomain() {
        return this.topLevelDomain;
    }

    @JsonProperty(value="topLevelDomain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTopLevelDomain(String topLevelDomain) {
        this.topLevelDomain = topLevelDomain;
    }

    public Country currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="USD", value="Currency code")
    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public Country currencyName(String currencyName) {
        this.currencyName = currencyName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Dollar", value="Currency name")
    @JsonProperty(value="currencyName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrencyName() {
        return this.currencyName;
    }

    @JsonProperty(value="currencyName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrencyName(String currencyName) {
        this.currencyName = currencyName;
    }

    public Country phone(String phone) {
        this.phone = phone;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="Calling code")
    @JsonProperty(value="phone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPhone() {
        return this.phone;
    }

    @JsonProperty(value="phone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Country postalCodeFormat(String postalCodeFormat) {
        this.postalCodeFormat = postalCodeFormat;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="#####-####", value="Postal code format")
    @JsonProperty(value="postalCodeFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPostalCodeFormat() {
        return this.postalCodeFormat;
    }

    @JsonProperty(value="postalCodeFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPostalCodeFormat(String postalCodeFormat) {
        this.postalCodeFormat = postalCodeFormat;
    }

    public Country postalCodeRegEx(String postalCodeRegEx) {
        this.postalCodeRegEx = postalCodeRegEx;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="^d{5}(-d{4})?$", value="Postal code regular expression")
    @JsonProperty(value="postalCodeRegEx")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPostalCodeRegEx() {
        return this.postalCodeRegEx;
    }

    @JsonProperty(value="postalCodeRegEx")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPostalCodeRegEx(String postalCodeRegEx) {
        this.postalCodeRegEx = postalCodeRegEx;
    }

    public Country languages(List<String> languages) {
        this.languages = languages;
        return this;
    }

    public Country addLanguagesItem(String languagesItem) {
        if (this.languages == null) {
            this.languages = new ArrayList<String>();
        }
        this.languages.add(languagesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Country languages")
    @JsonProperty(value="languages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getLanguages() {
        return this.languages;
    }

    @JsonProperty(value="languages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguages(List<String> languages) {
        this.languages = languages;
    }

    public Country geoNameId(String geoNameId) {
        this.geoNameId = geoNameId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="6252001", value="Country GeoNames identifier")
    @JsonProperty(value="geoNameId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGeoNameId() {
        return this.geoNameId;
    }

    @JsonProperty(value="geoNameId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGeoNameId(String geoNameId) {
        this.geoNameId = geoNameId;
    }

    public Country neighbors(List<String> neighbors) {
        this.neighbors = neighbors;
        return this;
    }

    public Country addNeighborsItem(String neighborsItem) {
        if (this.neighbors == null) {
            this.neighbors = new ArrayList<String>();
        }
        this.neighbors.add(neighborsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Neighboring countries")
    @JsonProperty(value="neighbors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getNeighbors() {
        return this.neighbors;
    }

    @JsonProperty(value="neighbors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNeighbors(List<String> neighbors) {
        this.neighbors = neighbors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Country country = (Country)o;
        return Objects.equals(this.iso, country.iso) && Objects.equals(this.iso3, country.iso3) && Objects.equals(this.isoNumeric, country.isoNumeric) && Objects.equals(this.fips, country.fips) && Objects.equals(this.name, country.name) && Objects.equals(this.capital, country.capital) && Objects.equals(this.area, country.area) && Objects.equals(this.population, country.population) && Objects.equals(this.continent, country.continent) && Objects.equals(this.topLevelDomain, country.topLevelDomain) && Objects.equals(this.currencyCode, country.currencyCode) && Objects.equals(this.currencyName, country.currencyName) && Objects.equals(this.phone, country.phone) && Objects.equals(this.postalCodeFormat, country.postalCodeFormat) && Objects.equals(this.postalCodeRegEx, country.postalCodeRegEx) && Objects.equals(this.languages, country.languages) && Objects.equals(this.geoNameId, country.geoNameId) && Objects.equals(this.neighbors, country.neighbors);
    }

    public int hashCode() {
        return Objects.hash(this.iso, this.iso3, this.isoNumeric, this.fips, this.name, this.capital, this.area, this.population, this.continent, this.topLevelDomain, this.currencyCode, this.currencyName, this.phone, this.postalCodeFormat, this.postalCodeRegEx, this.languages, this.geoNameId, this.neighbors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Country {\n");
        sb.append("    iso: ").append(this.toIndentedString(this.iso)).append("\n");
        sb.append("    iso3: ").append(this.toIndentedString(this.iso3)).append("\n");
        sb.append("    isoNumeric: ").append(this.toIndentedString(this.isoNumeric)).append("\n");
        sb.append("    fips: ").append(this.toIndentedString(this.fips)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    capital: ").append(this.toIndentedString(this.capital)).append("\n");
        sb.append("    area: ").append(this.toIndentedString(this.area)).append("\n");
        sb.append("    population: ").append(this.toIndentedString(this.population)).append("\n");
        sb.append("    continent: ").append(this.toIndentedString(this.continent)).append("\n");
        sb.append("    topLevelDomain: ").append(this.toIndentedString(this.topLevelDomain)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    currencyName: ").append(this.toIndentedString(this.currencyName)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    postalCodeFormat: ").append(this.toIndentedString(this.postalCodeFormat)).append("\n");
        sb.append("    postalCodeRegEx: ").append(this.toIndentedString(this.postalCodeRegEx)).append("\n");
        sb.append("    languages: ").append(this.toIndentedString(this.languages)).append("\n");
        sb.append("    geoNameId: ").append(this.toIndentedString(this.geoNameId)).append("\n");
        sb.append("    neighbors: ").append(this.toIndentedString(this.neighbors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

