/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import io.trippay.sdk.payment.model.Acquirer;
import io.trippay.sdk.payment.model.UpsertAddressRequest;
import io.trippay.sdk.payment.model.UpsertBankAccountRequest;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonPropertyOrder(value={"externalIdentifier", "type", "ownerType", "name", "legalName", "userIdentifier", "accountEmail", "description", "url", "currencyCode", "address", "acquirers", "bankAccounts", "ownerTypeIdentifier", "dob"})
public class CreateAccountRequest {
    public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
    private String externalIdentifier;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
    private OwnerTypeEnum ownerType;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_LEGAL_NAME = "legalName";
    private String legalName;
    public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
    private UUID userIdentifier;
    public static final String JSON_PROPERTY_ACCOUNT_EMAIL = "accountEmail";
    private String accountEmail;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
    private String currencyCode;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private UpsertAddressRequest address;
    public static final String JSON_PROPERTY_ACQUIRERS = "acquirers";
    private List<Acquirer> acquirers = null;
    public static final String JSON_PROPERTY_BANK_ACCOUNTS = "bankAccounts";
    private List<UpsertBankAccountRequest> bankAccounts = null;
    public static final String JSON_PROPERTY_OWNER_TYPE_IDENTIFIER = "ownerTypeIdentifier";
    private String ownerTypeIdentifier;
    public static final String JSON_PROPERTY_DOB = "dob";
    private LocalDate dob;

    public CreateAccountRequest externalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="external-record-1", value="Unique external record identifier")
    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public CreateAccountRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="MERCHANT", required=true, value="Type of account tells us what the account is capable of.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CreateAccountRequest ownerType(OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="COMPANY", required=true, value="Type of account owner tells us whether ths account is managed by a company or an individual.")
    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OwnerTypeEnum getOwnerType() {
        return this.ownerType;
    }

    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerType(OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
    }

    public CreateAccountRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="My Company", required=true, value="Name of company / full name of person")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public CreateAccountRequest legalName(String legalName) {
        this.legalName = legalName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Legal Company 1", value="Legal name of entity if other than name")
    @JsonProperty(value="legalName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalName() {
        return this.legalName;
    }

    @JsonProperty(value="legalName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public CreateAccountRequest userIdentifier(UUID userIdentifier) {
        this.userIdentifier = userIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The authenticated user that owns this account.")
    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getUserIdentifier() {
        return this.userIdentifier;
    }

    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserIdentifier(UUID userIdentifier) {
        this.userIdentifier = userIdentifier;
    }

    public CreateAccountRequest accountEmail(String accountEmail) {
        this.accountEmail = accountEmail;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="company@acme.com", required=true, value="Account email is where we will send KYC documents and other account specific mailings")
    @JsonProperty(value="accountEmail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountEmail() {
        return this.accountEmail;
    }

    @JsonProperty(value="accountEmail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountEmail(String accountEmail) {
        this.accountEmail = accountEmail;
    }

    public CreateAccountRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="My Company is the best company ever.", required=true, value="Short company / person description.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateAccountRequest url(String url) {
        this.url = url;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="https://trippay.io", required=true, value="Company website. If private person with no personal website, link to main social network account.")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUrl(String url) {
        this.url = url;
    }

    public CreateAccountRequest currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=3, max=3)
    @ApiModelProperty(example="GBP", required=true, value="Account's main currency.")
    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=3, max=3) String getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public CreateAccountRequest address(UpsertAddressRequest address) {
        this.address = address;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UpsertAddressRequest getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(UpsertAddressRequest address) {
        this.address = address;
    }

    public CreateAccountRequest acquirers(List<Acquirer> acquirers) {
        this.acquirers = acquirers;
        return this;
    }

    public CreateAccountRequest addAcquirersItem(Acquirer acquirersItem) {
        if (this.acquirers == null) {
            this.acquirers = new ArrayList<Acquirer>();
        }
        this.acquirers.add(acquirersItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="acquirers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Acquirer> getAcquirers() {
        return this.acquirers;
    }

    @JsonProperty(value="acquirers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcquirers(List<Acquirer> acquirers) {
        this.acquirers = acquirers;
    }

    public CreateAccountRequest bankAccounts(List<UpsertBankAccountRequest> bankAccounts) {
        this.bankAccounts = bankAccounts;
        return this;
    }

    public CreateAccountRequest addBankAccountsItem(UpsertBankAccountRequest bankAccountsItem) {
        if (this.bankAccounts == null) {
            this.bankAccounts = new ArrayList<UpsertBankAccountRequest>();
        }
        this.bankAccounts.add(bankAccountsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="bankAccounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UpsertBankAccountRequest> getBankAccounts() {
        return this.bankAccounts;
    }

    @JsonProperty(value="bankAccounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccounts(List<UpsertBankAccountRequest> bankAccounts) {
        this.bankAccounts = bankAccounts;
    }

    public CreateAccountRequest ownerTypeIdentifier(String ownerTypeIdentifier) {
        this.ownerTypeIdentifier = ownerTypeIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This is the tax identification number (TIN) for individuals and entity identification number (EIN) for companies.")
    @JsonProperty(value="ownerTypeIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOwnerTypeIdentifier() {
        return this.ownerTypeIdentifier;
    }

    @JsonProperty(value="ownerTypeIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerTypeIdentifier(String ownerTypeIdentifier) {
        this.ownerTypeIdentifier = ownerTypeIdentifier;
    }

    public CreateAccountRequest dob(LocalDate dob) {
        this.dob = dob;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="This is the individual's date of birth.")
    @JsonProperty(value="dob")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getDob() {
        return this.dob;
    }

    @JsonProperty(value="dob")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDob(LocalDate dob) {
        this.dob = dob;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAccountRequest createAccountRequest = (CreateAccountRequest)o;
        return Objects.equals(this.externalIdentifier, createAccountRequest.externalIdentifier) && Objects.equals((Object)this.type, (Object)createAccountRequest.type) && Objects.equals((Object)this.ownerType, (Object)createAccountRequest.ownerType) && Objects.equals(this.name, createAccountRequest.name) && Objects.equals(this.legalName, createAccountRequest.legalName) && Objects.equals(this.userIdentifier, createAccountRequest.userIdentifier) && Objects.equals(this.accountEmail, createAccountRequest.accountEmail) && Objects.equals(this.description, createAccountRequest.description) && Objects.equals(this.url, createAccountRequest.url) && Objects.equals(this.currencyCode, createAccountRequest.currencyCode) && Objects.equals(this.address, createAccountRequest.address) && Objects.equals(this.acquirers, createAccountRequest.acquirers) && Objects.equals(this.bankAccounts, createAccountRequest.bankAccounts) && Objects.equals(this.ownerTypeIdentifier, createAccountRequest.ownerTypeIdentifier) && Objects.equals(this.dob, createAccountRequest.dob);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.externalIdentifier, this.type, this.ownerType, this.name, this.legalName, this.userIdentifier, this.accountEmail, this.description, this.url, this.currencyCode, this.address, this.acquirers, this.bankAccounts, this.ownerTypeIdentifier, this.dob});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateAccountRequest {\n");
        sb.append("    externalIdentifier: ").append(this.toIndentedString(this.externalIdentifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    ownerType: ").append(this.toIndentedString((Object)this.ownerType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    legalName: ").append(this.toIndentedString(this.legalName)).append("\n");
        sb.append("    userIdentifier: ").append(this.toIndentedString(this.userIdentifier)).append("\n");
        sb.append("    accountEmail: ").append(this.toIndentedString(this.accountEmail)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    acquirers: ").append(this.toIndentedString(this.acquirers)).append("\n");
        sb.append("    bankAccounts: ").append(this.toIndentedString(this.bankAccounts)).append("\n");
        sb.append("    ownerTypeIdentifier: ").append(this.toIndentedString(this.ownerTypeIdentifier)).append("\n");
        sb.append("    dob: ").append(this.toIndentedString(this.dob)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        MERCHANT("MERCHANT"),
        AFFILIATE("AFFILIATE"),
        AGENT("AGENT"),
        FACILITATOR("FACILITATOR"),
        RATE_PROVIDER("RATE_PROVIDER"),
        TRIP_PAY("TRIP_PAY");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum OwnerTypeEnum {
        COMPANY("COMPANY"),
        INDIVIDUAL("INDIVIDUAL");

        private String value;

        private OwnerTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OwnerTypeEnum fromValue(String value) {
            for (OwnerTypeEnum b : OwnerTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

