/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.trippay.sdk.payment.model.AccountStatusEntry;
import io.trippay.sdk.payment.model.Acquirer;
import io.trippay.sdk.payment.model.Address;
import io.trippay.sdk.payment.model.BankAccount;
import io.trippay.sdk.payment.model.Contact;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@ApiModel(description="Account holds KYC, bank account and contact information of an affiliate, supplier, payment or any type of entity that is to be a beneficiary of funds through the payment.")
@JsonPropertyOrder(value={"id", "createdDate", "lastUpdate", "version", "type", "ownerType", "accountOwnerIdentifier", "name", "legalName", "userIdentifier", "owner", "accountEmail", "description", "url", "status", "currencyCode", "address", "acquirers", "bankAccounts", "ownerTypeIdentifier", "dob", "tasks"})
public class Account {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    private LocalDateTime createdDate;
    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    private LocalDateTime lastUpdate;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Long version;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
    private OwnerTypeEnum ownerType;
    public static final String JSON_PROPERTY_ACCOUNT_OWNER_IDENTIFIER = "accountOwnerIdentifier";
    private UUID accountOwnerIdentifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_LEGAL_NAME = "legalName";
    private String legalName;
    public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
    private UUID userIdentifier;
    public static final String JSON_PROPERTY_OWNER = "owner";
    private Contact owner;
    public static final String JSON_PROPERTY_ACCOUNT_EMAIL = "accountEmail";
    private String accountEmail;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status = StatusEnum.REGISTERED;
    public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
    private String currencyCode;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private Address address;
    public static final String JSON_PROPERTY_ACQUIRERS = "acquirers";
    private List<Acquirer> acquirers = null;
    public static final String JSON_PROPERTY_BANK_ACCOUNTS = "bankAccounts";
    private List<BankAccount> bankAccounts = null;
    public static final String JSON_PROPERTY_OWNER_TYPE_IDENTIFIER = "ownerTypeIdentifier";
    private String ownerTypeIdentifier;
    public static final String JSON_PROPERTY_DOB = "dob";
    private LocalDate dob;
    public static final String JSON_PROPERTY_TASKS = "tasks";
    private List<AccountStatusEntry> tasks = null;

    public Account id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="doc-1", value="Document UUID")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public Account createdDate(LocalDateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Datetime this record was first created")
    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedDate(LocalDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public Account lastUpdate(LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Datetime this record was last updated")
    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastUpdate(LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public Account version(Long version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="12", value="Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.")
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(Long version) {
        this.version = version;
    }

    public Account type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="MERCHANT", required=true, value="Type of account tells us what the account is capable of.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Account ownerType(OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="COMPANY", required=true, value="Type of account owner tells us whether ths account is managed by a company or an individual.")
    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OwnerTypeEnum getOwnerType() {
        return this.ownerType;
    }

    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerType(OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
    }

    public Account accountOwnerIdentifier(UUID accountOwnerIdentifier) {
        this.accountOwnerIdentifier = accountOwnerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The entity that created this account.")
    @JsonProperty(value="accountOwnerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getAccountOwnerIdentifier() {
        return this.accountOwnerIdentifier;
    }

    @JsonProperty(value="accountOwnerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountOwnerIdentifier(UUID accountOwnerIdentifier) {
        this.accountOwnerIdentifier = accountOwnerIdentifier;
    }

    public Account name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="My Company", required=true, value="Name of company / full name of person")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public Account legalName(String legalName) {
        this.legalName = legalName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Legal Company 1", value="Legal name of entity if other than name")
    @JsonProperty(value="legalName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalName() {
        return this.legalName;
    }

    @JsonProperty(value="legalName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public Account userIdentifier(UUID userIdentifier) {
        this.userIdentifier = userIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The authenticated user that owns this account.")
    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getUserIdentifier() {
        return this.userIdentifier;
    }

    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserIdentifier(UUID userIdentifier) {
        this.userIdentifier = userIdentifier;
    }

    public Account owner(Contact owner) {
        this.owner = owner;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Contact getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwner(Contact owner) {
        this.owner = owner;
    }

    public Account accountEmail(String accountEmail) {
        this.accountEmail = accountEmail;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="company@acme.com", required=true, value="Account email is where we will send KYC documents and other account specific mailings")
    @JsonProperty(value="accountEmail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountEmail() {
        return this.accountEmail;
    }

    @JsonProperty(value="accountEmail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountEmail(String accountEmail) {
        this.accountEmail = accountEmail;
    }

    public Account description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="My Company is the best company ever.", required=true, value="Short company / person description.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(String description) {
        this.description = description;
    }

    public Account url(String url) {
        this.url = url;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="https://trippay.io", required=true, value="Company website. If private person with no personal website, link to main social network account.")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUrl(String url) {
        this.url = url;
    }

    public Account status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="APPROVED", required=true, value="Account status shows if it's approved")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Account currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=3, max=3)
    @ApiModelProperty(example="GBP", required=true, value="Account's main currency.")
    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=3, max=3) String getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public Account address(Address address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Address getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(Address address) {
        this.address = address;
    }

    public Account acquirers(List<Acquirer> acquirers) {
        this.acquirers = acquirers;
        return this;
    }

    public Account addAcquirersItem(Acquirer acquirersItem) {
        if (this.acquirers == null) {
            this.acquirers = new ArrayList<Acquirer>();
        }
        this.acquirers.add(acquirersItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="acquirers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Acquirer> getAcquirers() {
        return this.acquirers;
    }

    @JsonProperty(value="acquirers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcquirers(List<Acquirer> acquirers) {
        this.acquirers = acquirers;
    }

    public Account bankAccounts(List<BankAccount> bankAccounts) {
        this.bankAccounts = bankAccounts;
        return this;
    }

    public Account addBankAccountsItem(BankAccount bankAccountsItem) {
        if (this.bankAccounts == null) {
            this.bankAccounts = new ArrayList<BankAccount>();
        }
        this.bankAccounts.add(bankAccountsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="bankAccounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<BankAccount> getBankAccounts() {
        return this.bankAccounts;
    }

    @JsonProperty(value="bankAccounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccounts(List<BankAccount> bankAccounts) {
        this.bankAccounts = bankAccounts;
    }

    public Account ownerTypeIdentifier(String ownerTypeIdentifier) {
        this.ownerTypeIdentifier = ownerTypeIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This is the tax identification number (TIN) for individuals and entity identification number (EIN) for companies.")
    @JsonProperty(value="ownerTypeIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOwnerTypeIdentifier() {
        return this.ownerTypeIdentifier;
    }

    @JsonProperty(value="ownerTypeIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerTypeIdentifier(String ownerTypeIdentifier) {
        this.ownerTypeIdentifier = ownerTypeIdentifier;
    }

    public Account dob(LocalDate dob) {
        this.dob = dob;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="This is the individual's date of birth.")
    @JsonProperty(value="dob")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getDob() {
        return this.dob;
    }

    @JsonProperty(value="dob")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDob(LocalDate dob) {
        this.dob = dob;
    }

    public Account tasks(List<AccountStatusEntry> tasks) {
        this.tasks = tasks;
        return this;
    }

    public Account addTasksItem(AccountStatusEntry tasksItem) {
        if (this.tasks == null) {
            this.tasks = new ArrayList<AccountStatusEntry>();
        }
        this.tasks.add(tasksItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="tasks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AccountStatusEntry> getTasks() {
        return this.tasks;
    }

    @JsonProperty(value="tasks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTasks(List<AccountStatusEntry> tasks) {
        this.tasks = tasks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Account account = (Account)o;
        return Objects.equals(this.id, account.id) && Objects.equals(this.createdDate, account.createdDate) && Objects.equals(this.lastUpdate, account.lastUpdate) && Objects.equals(this.version, account.version) && Objects.equals((Object)this.type, (Object)account.type) && Objects.equals((Object)this.ownerType, (Object)account.ownerType) && Objects.equals(this.accountOwnerIdentifier, account.accountOwnerIdentifier) && Objects.equals(this.name, account.name) && Objects.equals(this.legalName, account.legalName) && Objects.equals(this.userIdentifier, account.userIdentifier) && Objects.equals(this.owner, account.owner) && Objects.equals(this.accountEmail, account.accountEmail) && Objects.equals(this.description, account.description) && Objects.equals(this.url, account.url) && Objects.equals((Object)this.status, (Object)account.status) && Objects.equals(this.currencyCode, account.currencyCode) && Objects.equals(this.address, account.address) && Objects.equals(this.acquirers, account.acquirers) && Objects.equals(this.bankAccounts, account.bankAccounts) && Objects.equals(this.ownerTypeIdentifier, account.ownerTypeIdentifier) && Objects.equals(this.dob, account.dob) && Objects.equals(this.tasks, account.tasks);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.createdDate, this.lastUpdate, this.version, this.type, this.ownerType, this.accountOwnerIdentifier, this.name, this.legalName, this.userIdentifier, this.owner, this.accountEmail, this.description, this.url, this.status, this.currencyCode, this.address, this.acquirers, this.bankAccounts, this.ownerTypeIdentifier, this.dob, this.tasks});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Account {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    ownerType: ").append(this.toIndentedString((Object)this.ownerType)).append("\n");
        sb.append("    accountOwnerIdentifier: ").append(this.toIndentedString(this.accountOwnerIdentifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    legalName: ").append(this.toIndentedString(this.legalName)).append("\n");
        sb.append("    userIdentifier: ").append(this.toIndentedString(this.userIdentifier)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    accountEmail: ").append(this.toIndentedString(this.accountEmail)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    acquirers: ").append(this.toIndentedString(this.acquirers)).append("\n");
        sb.append("    bankAccounts: ").append(this.toIndentedString(this.bankAccounts)).append("\n");
        sb.append("    ownerTypeIdentifier: ").append(this.toIndentedString(this.ownerTypeIdentifier)).append("\n");
        sb.append("    dob: ").append(this.toIndentedString(this.dob)).append("\n");
        sb.append("    tasks: ").append(this.toIndentedString(this.tasks)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        REGISTERED("REGISTERED"),
        REVIEW("REVIEW"),
        APPROVED("APPROVED"),
        DEACTIVATED("DEACTIVATED"),
        REJECTED("REJECTED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        MERCHANT("MERCHANT"),
        AFFILIATE("AFFILIATE"),
        AGENT("AGENT"),
        FACILITATOR("FACILITATOR"),
        RATE_PROVIDER("RATE_PROVIDER"),
        TRIP_PAY("TRIP_PAY");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum OwnerTypeEnum {
        COMPANY("COMPANY"),
        INDIVIDUAL("INDIVIDUAL");

        private String value;

        private OwnerTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OwnerTypeEnum fromValue(String value) {
            for (OwnerTypeEnum b : OwnerTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

