/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.trippay.sdk.payment.model.CompositeFilterDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@ApiModel(description="Descriptors used for filtering result set")
@JsonPropertyOrder(value={"logic", "filters"})
public class FilterDescriptor {
    public static final String JSON_PROPERTY_LOGIC = "logic";
    private LogicEnum logic;
    public static final String JSON_PROPERTY_FILTERS = "filters";
    private List<CompositeFilterDescriptor> filters = null;

    public FilterDescriptor logic(LogicEnum logic) {
        this.logic = logic;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="and", value="Whether to filter inclusively or exclusively")
    @JsonProperty(value="logic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogicEnum getLogic() {
        return this.logic;
    }

    @JsonProperty(value="logic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogic(LogicEnum logic) {
        this.logic = logic;
    }

    public FilterDescriptor filters(List<CompositeFilterDescriptor> filters) {
        this.filters = filters;
        return this;
    }

    public FilterDescriptor addFiltersItem(CompositeFilterDescriptor filtersItem) {
        if (this.filters == null) {
            this.filters = new ArrayList<CompositeFilterDescriptor>();
        }
        this.filters.add(filtersItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Descriptors used for filtering the result set")
    @JsonProperty(value="filters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CompositeFilterDescriptor> getFilters() {
        return this.filters;
    }

    @JsonProperty(value="filters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilters(List<CompositeFilterDescriptor> filters) {
        this.filters = filters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterDescriptor filterDescriptor = (FilterDescriptor)o;
        return Objects.equals((Object)this.logic, (Object)filterDescriptor.logic) && Objects.equals(this.filters, filterDescriptor.filters);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.logic, this.filters});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FilterDescriptor {\n");
        sb.append("    logic: ").append(this.toIndentedString((Object)this.logic)).append("\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum LogicEnum {
        AND("and"),
        OR("or");

        private String value;

        private LogicEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LogicEnum fromValue(String value) {
            for (LogicEnum b : LogicEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

