/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import io.trippay.sdk.payment.model.Moneys;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"refund", "description", "reasonType"})
public class RefundRequest {
    public static final String JSON_PROPERTY_REFUND = "refund";
    private Moneys refund;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_REASON_TYPE = "reasonType";
    private ReasonTypeEnum reasonType;

    public RefundRequest refund(Moneys refund) {
        this.refund = refund;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="refund")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getRefund() {
        return this.refund;
    }

    @JsonProperty(value="refund")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRefund(Moneys refund) {
        this.refund = refund;
    }

    public RefundRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Customer made a mistake", required=true, value="A description of the refund that can be displayed to booker")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(String description) {
        this.description = description;
    }

    public RefundRequest reasonType(ReasonTypeEnum reasonType) {
        this.reasonType = reasonType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="REQUESTED_BY_CUSTOMER", required=true, value="A description of the refund that can be displayed to booker")
    @JsonProperty(value="reasonType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ReasonTypeEnum getReasonType() {
        return this.reasonType;
    }

    @JsonProperty(value="reasonType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setReasonType(ReasonTypeEnum reasonType) {
        this.reasonType = reasonType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RefundRequest refundRequest = (RefundRequest)o;
        return Objects.equals(this.refund, refundRequest.refund) && Objects.equals(this.description, refundRequest.description) && Objects.equals((Object)this.reasonType, (Object)refundRequest.reasonType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.refund, this.description, this.reasonType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RefundRequest {\n");
        sb.append("    refund: ").append(this.toIndentedString(this.refund)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    reasonType: ").append(this.toIndentedString((Object)this.reasonType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ReasonTypeEnum {
        DUPLICATE("DUPLICATE"),
        FRAUDULENT("FRAUDULENT"),
        REQUESTED_BY_CUSTOMER("REQUESTED_BY_CUSTOMER"),
        GUEST_COMPLAINT("GUEST_COMPLAINT"),
        GUEST_BOOKED_INCORRECT_DATE("GUEST_BOOKED_INCORRECT_DATE"),
        GUEST_SICK("GUEST_SICK"),
        OVERBOOKING("OVERBOOKING"),
        EMERGENCY("EMERGENCY"),
        FLIGHT_CANCELLED("FLIGHT_CANCELLED"),
        DEATH_IN_FAMILY("DEATH_IN_FAMILY"),
        OTHER("OTHER"),
        EXPIRED_UNCAPTURED_CHARGE("EXPIRED_UNCAPTURED_CHARGE");

        private String value;

        private ReasonTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ReasonTypeEnum fromValue(String value) {
            for (ReasonTypeEnum b : ReasonTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

