/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 25.1.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * How we interact with the acquirer
 */
@JsonPropertyOrder({
  AcquirerCredentials.JSON_PROPERTY_TYPE,
  AcquirerCredentials.JSON_PROPERTY_KEY1,
  AcquirerCredentials.JSON_PROPERTY_KEY2
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-04-06T14:49:24.581831658+07:00[Asia/Bangkok]")
public class AcquirerCredentials {
  /**
   * Type of credentials
   */
  public enum TypeEnum {
    TOKEN("TOKEN"),
    
    PROCESSOR_ID("PROCESSOR_ID"),
    
    WEBHOOK("WEBHOOK"),
    
    SECRET("SECRET");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_KEY1 = "key1";
  private String key1;

  public static final String JSON_PROPERTY_KEY2 = "key2";
  private String key2;

  public AcquirerCredentials() {
  }

  public AcquirerCredentials type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of credentials
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public AcquirerCredentials key1(String key1) {
    
    this.key1 = key1;
    return this;
  }

   /**
   * A key that can be used as a token
   * @return key1
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_KEY1)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getKey1() {
    return key1;
  }


  @JsonProperty(JSON_PROPERTY_KEY1)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setKey1(String key1) {
    this.key1 = key1;
  }


  public AcquirerCredentials key2(String key2) {
    
    this.key2 = key2;
    return this;
  }

   /**
   * Can be used alongside key1 as credentials
   * @return key2
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_KEY2)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getKey2() {
    return key2;
  }


  @JsonProperty(JSON_PROPERTY_KEY2)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setKey2(String key2) {
    this.key2 = key2;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AcquirerCredentials acquirerCredentials = (AcquirerCredentials) o;
    return Objects.equals(this.type, acquirerCredentials.type) &&
        Objects.equals(this.key1, acquirerCredentials.key1) &&
        Objects.equals(this.key2, acquirerCredentials.key2);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, key1, key2);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AcquirerCredentials {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    key1: ").append(toIndentedString(key1)).append("\n");
    sb.append("    key2: ").append(toIndentedString(key2)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

