/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 25.1.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.Moneys;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Refund objects allow you to refund a charge that has previously been created but not yet refunded. Funds will be refunded to the credit or debit card that was originally charged.
 */
@JsonPropertyOrder({
  Refund.JSON_PROPERTY_IDENTIFIER,
  Refund.JSON_PROPERTY_ACQUIRER_REFUND_IDENTIFIER,
  Refund.JSON_PROPERTY_REQUESTED_BY_IDENTIFIER,
  Refund.JSON_PROPERTY_REFUND,
  Refund.JSON_PROPERTY_CREATED,
  Refund.JSON_PROPERTY_DESCRIPTION,
  Refund.JSON_PROPERTY_REASON_TYPE,
  Refund.JSON_PROPERTY_STATUS_TYPE,
  Refund.JSON_PROPERTY_REQUEST_TYPE,
  Refund.JSON_PROPERTY_REQUEST_STATUS,
  Refund.JSON_PROPERTY_REQUEST_RESPONSE,
  Refund.JSON_PROPERTY_RECEIPT_URL
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-04-06T14:49:24.581831658+07:00[Asia/Bangkok]")
public class Refund {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_ACQUIRER_REFUND_IDENTIFIER = "acquirerRefundIdentifier";
  private String acquirerRefundIdentifier;

  public static final String JSON_PROPERTY_REQUESTED_BY_IDENTIFIER = "requestedByIdentifier";
  private String requestedByIdentifier;

  public static final String JSON_PROPERTY_REFUND = "refund";
  private Moneys refund;

  public static final String JSON_PROPERTY_CREATED = "created";
  private java.time.LocalDateTime created;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  /**
   * A description of the refund that can be displayed to booker
   */
  public enum ReasonTypeEnum {
    DUPLICATE("DUPLICATE"),
    
    FRAUDULENT("FRAUDULENT"),
    
    REQUESTED_BY_CUSTOMER("REQUESTED_BY_CUSTOMER"),
    
    GUEST_COMPLAINT("GUEST_COMPLAINT"),
    
    GUEST_BOOKED_INCORRECT_DATE("GUEST_BOOKED_INCORRECT_DATE"),
    
    GUEST_SICK("GUEST_SICK"),
    
    OVERBOOKING("OVERBOOKING"),
    
    EMERGENCY("EMERGENCY"),
    
    FLIGHT_CANCELLED("FLIGHT_CANCELLED"),
    
    DEATH_IN_FAMILY("DEATH_IN_FAMILY"),
    
    OTHER("OTHER"),
    
    EXPIRED_UNCAPTURED_CHARGE("EXPIRED_UNCAPTURED_CHARGE");

    private String value;

    ReasonTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ReasonTypeEnum fromValue(String value) {
      for (ReasonTypeEnum b : ReasonTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REASON_TYPE = "reasonType";
  private ReasonTypeEnum reasonType;

  /**
   * Status of the refund
   */
  public enum StatusTypeEnum {
    PENDING("PENDING"),
    
    SUCCEEDED("SUCCEEDED"),
    
    CANCELED("CANCELED"),
    
    REQUIRES_ACTION("REQUIRES_ACTION"),
    
    FAILED("FAILED");

    private String value;

    StatusTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusTypeEnum fromValue(String value) {
      for (StatusTypeEnum b : StatusTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS_TYPE = "statusType";
  private StatusTypeEnum statusType;

  /**
   * The entity making the refund request
   */
  public enum RequestTypeEnum {
    SUPPLIER("BY_SUPPLIER"),
    
    ADMIN("BY_ADMIN"),
    
    STRIPE("BY_STRIPE"),
    
    SYSTEM("BY_SYSTEM");

    private String value;

    RequestTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RequestTypeEnum fromValue(String value) {
      for (RequestTypeEnum b : RequestTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REQUEST_TYPE = "requestType";
  private RequestTypeEnum requestType;

  /**
   * Status of the refund request
   */
  public enum RequestStatusEnum {
    PENDING("PENDING"),
    
    APPROVED("APPROVED"),
    
    REJECTED("REJECTED");

    private String value;

    RequestStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RequestStatusEnum fromValue(String value) {
      for (RequestStatusEnum b : RequestStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REQUEST_STATUS = "requestStatus";
  private RequestStatusEnum requestStatus;

  public static final String JSON_PROPERTY_REQUEST_RESPONSE = "requestResponse";
  private String requestResponse;

  public static final String JSON_PROPERTY_RECEIPT_URL = "receiptUrl";
  private String receiptUrl;

  public Refund() {
  }

  public Refund identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * A unique identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public Refund acquirerRefundIdentifier(String acquirerRefundIdentifier) {
    
    this.acquirerRefundIdentifier = acquirerRefundIdentifier;
    return this;
  }

   /**
   * The acquirer refund identifier. Will get attached once it comes in on the webhook.
   * @return acquirerRefundIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ACQUIRER_REFUND_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAcquirerRefundIdentifier() {
    return acquirerRefundIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ACQUIRER_REFUND_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAcquirerRefundIdentifier(String acquirerRefundIdentifier) {
    this.acquirerRefundIdentifier = acquirerRefundIdentifier;
  }


  public Refund requestedByIdentifier(String requestedByIdentifier) {
    
    this.requestedByIdentifier = requestedByIdentifier;
    return this;
  }

   /**
   * The SSO person / entity that requested the refund.
   * @return requestedByIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REQUESTED_BY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRequestedByIdentifier() {
    return requestedByIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_REQUESTED_BY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequestedByIdentifier(String requestedByIdentifier) {
    this.requestedByIdentifier = requestedByIdentifier;
  }


  public Refund refund(Moneys refund) {
    
    this.refund = refund;
    return this;
  }

   /**
   * Get refund
   * @return refund
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_REFUND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getRefund() {
    return refund;
  }


  @JsonProperty(JSON_PROPERTY_REFUND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRefund(Moneys refund) {
    this.refund = refund;
  }


  public Refund created(java.time.LocalDateTime created) {
    
    this.created = created;
    return this;
  }

   /**
   * When the amount was refunded
   * @return created
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.time.LocalDateTime getCreated() {
    return created;
  }


  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreated(java.time.LocalDateTime created) {
    this.created = created;
  }


  public Refund description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * A description of the refund that can be displayed to booker
   * @return description
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescription(String description) {
    this.description = description;
  }


  public Refund reasonType(ReasonTypeEnum reasonType) {
    
    this.reasonType = reasonType;
    return this;
  }

   /**
   * A description of the refund that can be displayed to booker
   * @return reasonType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_REASON_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ReasonTypeEnum getReasonType() {
    return reasonType;
  }


  @JsonProperty(JSON_PROPERTY_REASON_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setReasonType(ReasonTypeEnum reasonType) {
    this.reasonType = reasonType;
  }


  public Refund statusType(StatusTypeEnum statusType) {
    
    this.statusType = statusType;
    return this;
  }

   /**
   * Status of the refund
   * @return statusType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_STATUS_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusTypeEnum getStatusType() {
    return statusType;
  }


  @JsonProperty(JSON_PROPERTY_STATUS_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatusType(StatusTypeEnum statusType) {
    this.statusType = statusType;
  }


  public Refund requestType(RequestTypeEnum requestType) {
    
    this.requestType = requestType;
    return this;
  }

   /**
   * The entity making the refund request
   * @return requestType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_REQUEST_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RequestTypeEnum getRequestType() {
    return requestType;
  }


  @JsonProperty(JSON_PROPERTY_REQUEST_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRequestType(RequestTypeEnum requestType) {
    this.requestType = requestType;
  }


  public Refund requestStatus(RequestStatusEnum requestStatus) {
    
    this.requestStatus = requestStatus;
    return this;
  }

   /**
   * Status of the refund request
   * @return requestStatus
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_REQUEST_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RequestStatusEnum getRequestStatus() {
    return requestStatus;
  }


  @JsonProperty(JSON_PROPERTY_REQUEST_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRequestStatus(RequestStatusEnum requestStatus) {
    this.requestStatus = requestStatus;
  }


  public Refund requestResponse(String requestResponse) {
    
    this.requestResponse = requestResponse;
    return this;
  }

   /**
   * Admin may choose to respond to the refund request made by the hotel
   * @return requestResponse
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_REQUEST_RESPONSE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRequestResponse() {
    return requestResponse;
  }


  @JsonProperty(JSON_PROPERTY_REQUEST_RESPONSE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRequestResponse(String requestResponse) {
    this.requestResponse = requestResponse;
  }


  public Refund receiptUrl(String receiptUrl) {
    
    this.receiptUrl = receiptUrl;
    return this;
  }

   /**
   * This is the receipt url that contains a friendly web confirmation page. Comes in on the webhook.
   * @return receiptUrl
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RECEIPT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReceiptUrl() {
    return receiptUrl;
  }


  @JsonProperty(JSON_PROPERTY_RECEIPT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReceiptUrl(String receiptUrl) {
    this.receiptUrl = receiptUrl;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Refund refund = (Refund) o;
    return Objects.equals(this.identifier, refund.identifier) &&
        Objects.equals(this.acquirerRefundIdentifier, refund.acquirerRefundIdentifier) &&
        Objects.equals(this.requestedByIdentifier, refund.requestedByIdentifier) &&
        Objects.equals(this.refund, refund.refund) &&
        Objects.equals(this.created, refund.created) &&
        Objects.equals(this.description, refund.description) &&
        Objects.equals(this.reasonType, refund.reasonType) &&
        Objects.equals(this.statusType, refund.statusType) &&
        Objects.equals(this.requestType, refund.requestType) &&
        Objects.equals(this.requestStatus, refund.requestStatus) &&
        Objects.equals(this.requestResponse, refund.requestResponse) &&
        Objects.equals(this.receiptUrl, refund.receiptUrl);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, acquirerRefundIdentifier, requestedByIdentifier, refund, created, description, reasonType, statusType, requestType, requestStatus, requestResponse, receiptUrl);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Refund {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    acquirerRefundIdentifier: ").append(toIndentedString(acquirerRefundIdentifier)).append("\n");
    sb.append("    requestedByIdentifier: ").append(toIndentedString(requestedByIdentifier)).append("\n");
    sb.append("    refund: ").append(toIndentedString(refund)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    reasonType: ").append(toIndentedString(reasonType)).append("\n");
    sb.append("    statusType: ").append(toIndentedString(statusType)).append("\n");
    sb.append("    requestType: ").append(toIndentedString(requestType)).append("\n");
    sb.append("    requestStatus: ").append(toIndentedString(requestStatus)).append("\n");
    sb.append("    requestResponse: ").append(toIndentedString(requestResponse)).append("\n");
    sb.append("    receiptUrl: ").append(toIndentedString(receiptUrl)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

