/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"accountIdentifier", "accountName", "type", "totalItemsSold", "amount"})
public class BeneficiaryAggregateData {
    public static final String JSON_PROPERTY_ACCOUNT_IDENTIFIER = "accountIdentifier";
    private UUID accountIdentifier;
    public static final String JSON_PROPERTY_ACCOUNT_NAME = "accountName";
    private String accountName;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_TOTAL_ITEMS_SOLD = "totalItemsSold";
    private Long totalItemsSold;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Double amount;

    public BeneficiaryAggregateData accountIdentifier(UUID accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="accountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getAccountIdentifier() {
        return this.accountIdentifier;
    }

    @JsonProperty(value="accountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountIdentifier(UUID accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
    }

    public BeneficiaryAggregateData accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="accountName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountName() {
        return this.accountName;
    }

    @JsonProperty(value="accountName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public BeneficiaryAggregateData type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public BeneficiaryAggregateData totalItemsSold(Long totalItemsSold) {
        this.totalItemsSold = totalItemsSold;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="totalItemsSold")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getTotalItemsSold() {
        return this.totalItemsSold;
    }

    @JsonProperty(value="totalItemsSold")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalItemsSold(Long totalItemsSold) {
        this.totalItemsSold = totalItemsSold;
    }

    public BeneficiaryAggregateData amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Double getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeneficiaryAggregateData beneficiaryAggregateData = (BeneficiaryAggregateData)o;
        return Objects.equals(this.accountIdentifier, beneficiaryAggregateData.accountIdentifier) && Objects.equals(this.accountName, beneficiaryAggregateData.accountName) && Objects.equals((Object)this.type, (Object)beneficiaryAggregateData.type) && Objects.equals(this.totalItemsSold, beneficiaryAggregateData.totalItemsSold) && Objects.equals(this.amount, beneficiaryAggregateData.amount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountIdentifier, this.accountName, this.type, this.totalItemsSold, this.amount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BeneficiaryAggregateData {\n");
        sb.append("    accountIdentifier: ").append(this.toIndentedString(this.accountIdentifier)).append("\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    totalItemsSold: ").append(this.toIndentedString(this.totalItemsSold)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        COMMISSION("COMMISSION"),
        PLATFORM_FEE("PLATFORM_FEE"),
        TRIP_PAY("TRIP_PAY"),
        SALE("SALE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

