/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 25.2.3
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.Moneys;
import io.trippay.sdk.payment.model.SupplierContractItemPolicy;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Contract item cancellable object
 */
@JsonPropertyOrder({
  BookingContractItemCancellableResponse.JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE,
  BookingContractItemCancellableResponse.JSON_PROPERTY_NAME_IN_ENGLISH,
  BookingContractItemCancellableResponse.JSON_PROPERTY_POLICY,
  BookingContractItemCancellableResponse.JSON_PROPERTY_TYPE,
  BookingContractItemCancellableResponse.JSON_PROPERTY_SOURCE_PRICE,
  BookingContractItemCancellableResponse.JSON_PROPERTY_SUPPLIER_PRICE,
  BookingContractItemCancellableResponse.JSON_PROPERTY_DISPLAY_PRICE,
  BookingContractItemCancellableResponse.JSON_PROPERTY_INTERNAL_PRICE,
  BookingContractItemCancellableResponse.JSON_PROPERTY_CAPTURE_PRICE,
  BookingContractItemCancellableResponse.JSON_PROPERTY_CANCELLABLE_BY_TRAVELER,
  BookingContractItemCancellableResponse.JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER,
  BookingContractItemCancellableResponse.JSON_PROPERTY_CANCELLABLE_WITH_CHARGES,
  BookingContractItemCancellableResponse.JSON_PROPERTY_SOURCE_PRICE_AFTER_REFUND,
  BookingContractItemCancellableResponse.JSON_PROPERTY_SUPPLIER_PRICE_AFTER_REFUND,
  BookingContractItemCancellableResponse.JSON_PROPERTY_DISPLAY_PRICE_AFTER_REFUND,
  BookingContractItemCancellableResponse.JSON_PROPERTY_INTERNAL_PRICE_AFTER_REFUND,
  BookingContractItemCancellableResponse.JSON_PROPERTY_CAPTURE_PRICE_AFTER_REFUND
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-04-12T17:32:17.983408277+07:00[Asia/Bangkok]")
public class BookingContractItemCancellableResponse {
  public static final String JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE = "supplierItemBookingCode";
  private String supplierItemBookingCode;

  public static final String JSON_PROPERTY_NAME_IN_ENGLISH = "nameInEnglish";
  private String nameInEnglish;

  public static final String JSON_PROPERTY_POLICY = "policy";
  private SupplierContractItemPolicy policy;

  /**
   * Type of item this is.
   */
  public enum TypeEnum {
    LODGING("LODGING"),
    
    RAIL("RAIL"),
    
    AIR("AIR"),
    
    CAR("CAR"),
    
    CRUISE("CRUISE"),
    
    PACKAGE("PACKAGE"),
    
    ADD_ON("ADD_ON"),
    
    RENTAL("RENTAL"),
    
    EXPERIENCE("EXPERIENCE"),
    
    ANCILLARY_BOOKING("ANCILLARY_BOOKING"),
    
    ANCILLARY_FEE("ANCILLARY_FEE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_SOURCE_PRICE = "sourcePrice";
  private Moneys sourcePrice;

  public static final String JSON_PROPERTY_SUPPLIER_PRICE = "supplierPrice";
  private Moneys supplierPrice;

  public static final String JSON_PROPERTY_DISPLAY_PRICE = "displayPrice";
  private Moneys displayPrice;

  public static final String JSON_PROPERTY_INTERNAL_PRICE = "internalPrice";
  private Moneys internalPrice;

  public static final String JSON_PROPERTY_CAPTURE_PRICE = "capturePrice";
  private Moneys capturePrice;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
  private Boolean cancellableByTraveler;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
  private Boolean cancellableBySupplier;

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_CHARGES = "cancellableWithCharges";
  private Boolean cancellableWithCharges;

  public static final String JSON_PROPERTY_SOURCE_PRICE_AFTER_REFUND = "sourcePriceAfterRefund";
  private Moneys sourcePriceAfterRefund;

  public static final String JSON_PROPERTY_SUPPLIER_PRICE_AFTER_REFUND = "supplierPriceAfterRefund";
  private Moneys supplierPriceAfterRefund;

  public static final String JSON_PROPERTY_DISPLAY_PRICE_AFTER_REFUND = "displayPriceAfterRefund";
  private Moneys displayPriceAfterRefund;

  public static final String JSON_PROPERTY_INTERNAL_PRICE_AFTER_REFUND = "internalPriceAfterRefund";
  private Moneys internalPriceAfterRefund;

  public static final String JSON_PROPERTY_CAPTURE_PRICE_AFTER_REFUND = "capturePriceAfterRefund";
  private Moneys capturePriceAfterRefund;

  public BookingContractItemCancellableResponse() {
  }

  public BookingContractItemCancellableResponse supplierItemBookingCode(String supplierItemBookingCode) {
    
    this.supplierItemBookingCode = supplierItemBookingCode;
    return this;
  }

   /**
   * Booking code identifying the supplier line item.
   * @return supplierItemBookingCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSupplierItemBookingCode() {
    return supplierItemBookingCode;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierItemBookingCode(String supplierItemBookingCode) {
    this.supplierItemBookingCode = supplierItemBookingCode;
  }


  public BookingContractItemCancellableResponse nameInEnglish(String nameInEnglish) {
    
    this.nameInEnglish = nameInEnglish;
    return this;
  }

   /**
   * Name of item in English included in booking.
   * @return nameInEnglish
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNameInEnglish() {
    return nameInEnglish;
  }


  @JsonProperty(JSON_PROPERTY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNameInEnglish(String nameInEnglish) {
    this.nameInEnglish = nameInEnglish;
  }


  public BookingContractItemCancellableResponse policy(SupplierContractItemPolicy policy) {
    
    this.policy = policy;
    return this;
  }

   /**
   * Get policy
   * @return policy
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SupplierContractItemPolicy getPolicy() {
    return policy;
  }


  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPolicy(SupplierContractItemPolicy policy) {
    this.policy = policy;
  }


  public BookingContractItemCancellableResponse type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of item this is.
   * @return type
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public BookingContractItemCancellableResponse sourcePrice(Moneys sourcePrice) {
    
    this.sourcePrice = sourcePrice;
    return this;
  }

   /**
   * Get sourcePrice
   * @return sourcePrice
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getSourcePrice() {
    return sourcePrice;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourcePrice(Moneys sourcePrice) {
    this.sourcePrice = sourcePrice;
  }


  public BookingContractItemCancellableResponse supplierPrice(Moneys supplierPrice) {
    
    this.supplierPrice = supplierPrice;
    return this;
  }

   /**
   * Get supplierPrice
   * @return supplierPrice
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getSupplierPrice() {
    return supplierPrice;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierPrice(Moneys supplierPrice) {
    this.supplierPrice = supplierPrice;
  }


  public BookingContractItemCancellableResponse displayPrice(Moneys displayPrice) {
    
    this.displayPrice = displayPrice;
    return this;
  }

   /**
   * Get displayPrice
   * @return displayPrice
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getDisplayPrice() {
    return displayPrice;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayPrice(Moneys displayPrice) {
    this.displayPrice = displayPrice;
  }


  public BookingContractItemCancellableResponse internalPrice(Moneys internalPrice) {
    
    this.internalPrice = internalPrice;
    return this;
  }

   /**
   * Get internalPrice
   * @return internalPrice
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getInternalPrice() {
    return internalPrice;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalPrice(Moneys internalPrice) {
    this.internalPrice = internalPrice;
  }


  public BookingContractItemCancellableResponse capturePrice(Moneys capturePrice) {
    
    this.capturePrice = capturePrice;
    return this;
  }

   /**
   * Get capturePrice
   * @return capturePrice
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getCapturePrice() {
    return capturePrice;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCapturePrice(Moneys capturePrice) {
    this.capturePrice = capturePrice;
  }


  public BookingContractItemCancellableResponse cancellableByTraveler(Boolean cancellableByTraveler) {
    
    this.cancellableByTraveler = cancellableByTraveler;
    return this;
  }

   /**
   * Whether this item can be cancelled by traveler either fully or partially.
   * @return cancellableByTraveler
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByTraveler() {
    return cancellableByTraveler;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByTraveler(Boolean cancellableByTraveler) {
    this.cancellableByTraveler = cancellableByTraveler;
  }


  public BookingContractItemCancellableResponse cancellableBySupplier(Boolean cancellableBySupplier) {
    
    this.cancellableBySupplier = cancellableBySupplier;
    return this;
  }

   /**
   * Whether this item can be cancelled by supplier either fully or partially.
   * @return cancellableBySupplier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableBySupplier() {
    return cancellableBySupplier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableBySupplier(Boolean cancellableBySupplier) {
    this.cancellableBySupplier = cancellableBySupplier;
  }


  public BookingContractItemCancellableResponse cancellableWithCharges(Boolean cancellableWithCharges) {
    
    this.cancellableWithCharges = cancellableWithCharges;
    return this;
  }

   /**
   * Whether this item can be cancelled by supplier either fully or partially.
   * @return cancellableWithCharges
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithCharges() {
    return cancellableWithCharges;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithCharges(Boolean cancellableWithCharges) {
    this.cancellableWithCharges = cancellableWithCharges;
  }


  public BookingContractItemCancellableResponse sourcePriceAfterRefund(Moneys sourcePriceAfterRefund) {
    
    this.sourcePriceAfterRefund = sourcePriceAfterRefund;
    return this;
  }

   /**
   * Get sourcePriceAfterRefund
   * @return sourcePriceAfterRefund
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getSourcePriceAfterRefund() {
    return sourcePriceAfterRefund;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourcePriceAfterRefund(Moneys sourcePriceAfterRefund) {
    this.sourcePriceAfterRefund = sourcePriceAfterRefund;
  }


  public BookingContractItemCancellableResponse supplierPriceAfterRefund(Moneys supplierPriceAfterRefund) {
    
    this.supplierPriceAfterRefund = supplierPriceAfterRefund;
    return this;
  }

   /**
   * Get supplierPriceAfterRefund
   * @return supplierPriceAfterRefund
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getSupplierPriceAfterRefund() {
    return supplierPriceAfterRefund;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierPriceAfterRefund(Moneys supplierPriceAfterRefund) {
    this.supplierPriceAfterRefund = supplierPriceAfterRefund;
  }


  public BookingContractItemCancellableResponse displayPriceAfterRefund(Moneys displayPriceAfterRefund) {
    
    this.displayPriceAfterRefund = displayPriceAfterRefund;
    return this;
  }

   /**
   * Get displayPriceAfterRefund
   * @return displayPriceAfterRefund
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getDisplayPriceAfterRefund() {
    return displayPriceAfterRefund;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayPriceAfterRefund(Moneys displayPriceAfterRefund) {
    this.displayPriceAfterRefund = displayPriceAfterRefund;
  }


  public BookingContractItemCancellableResponse internalPriceAfterRefund(Moneys internalPriceAfterRefund) {
    
    this.internalPriceAfterRefund = internalPriceAfterRefund;
    return this;
  }

   /**
   * Get internalPriceAfterRefund
   * @return internalPriceAfterRefund
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getInternalPriceAfterRefund() {
    return internalPriceAfterRefund;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalPriceAfterRefund(Moneys internalPriceAfterRefund) {
    this.internalPriceAfterRefund = internalPriceAfterRefund;
  }


  public BookingContractItemCancellableResponse capturePriceAfterRefund(Moneys capturePriceAfterRefund) {
    
    this.capturePriceAfterRefund = capturePriceAfterRefund;
    return this;
  }

   /**
   * Get capturePriceAfterRefund
   * @return capturePriceAfterRefund
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getCapturePriceAfterRefund() {
    return capturePriceAfterRefund;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCapturePriceAfterRefund(Moneys capturePriceAfterRefund) {
    this.capturePriceAfterRefund = capturePriceAfterRefund;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingContractItemCancellableResponse bookingContractItemCancellableResponse = (BookingContractItemCancellableResponse) o;
    return Objects.equals(this.supplierItemBookingCode, bookingContractItemCancellableResponse.supplierItemBookingCode) &&
        Objects.equals(this.nameInEnglish, bookingContractItemCancellableResponse.nameInEnglish) &&
        Objects.equals(this.policy, bookingContractItemCancellableResponse.policy) &&
        Objects.equals(this.type, bookingContractItemCancellableResponse.type) &&
        Objects.equals(this.sourcePrice, bookingContractItemCancellableResponse.sourcePrice) &&
        Objects.equals(this.supplierPrice, bookingContractItemCancellableResponse.supplierPrice) &&
        Objects.equals(this.displayPrice, bookingContractItemCancellableResponse.displayPrice) &&
        Objects.equals(this.internalPrice, bookingContractItemCancellableResponse.internalPrice) &&
        Objects.equals(this.capturePrice, bookingContractItemCancellableResponse.capturePrice) &&
        Objects.equals(this.cancellableByTraveler, bookingContractItemCancellableResponse.cancellableByTraveler) &&
        Objects.equals(this.cancellableBySupplier, bookingContractItemCancellableResponse.cancellableBySupplier) &&
        Objects.equals(this.cancellableWithCharges, bookingContractItemCancellableResponse.cancellableWithCharges) &&
        Objects.equals(this.sourcePriceAfterRefund, bookingContractItemCancellableResponse.sourcePriceAfterRefund) &&
        Objects.equals(this.supplierPriceAfterRefund, bookingContractItemCancellableResponse.supplierPriceAfterRefund) &&
        Objects.equals(this.displayPriceAfterRefund, bookingContractItemCancellableResponse.displayPriceAfterRefund) &&
        Objects.equals(this.internalPriceAfterRefund, bookingContractItemCancellableResponse.internalPriceAfterRefund) &&
        Objects.equals(this.capturePriceAfterRefund, bookingContractItemCancellableResponse.capturePriceAfterRefund);
  }

  @Override
  public int hashCode() {
    return Objects.hash(supplierItemBookingCode, nameInEnglish, policy, type, sourcePrice, supplierPrice, displayPrice, internalPrice, capturePrice, cancellableByTraveler, cancellableBySupplier, cancellableWithCharges, sourcePriceAfterRefund, supplierPriceAfterRefund, displayPriceAfterRefund, internalPriceAfterRefund, capturePriceAfterRefund);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingContractItemCancellableResponse {\n");
    sb.append("    supplierItemBookingCode: ").append(toIndentedString(supplierItemBookingCode)).append("\n");
    sb.append("    nameInEnglish: ").append(toIndentedString(nameInEnglish)).append("\n");
    sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    sourcePrice: ").append(toIndentedString(sourcePrice)).append("\n");
    sb.append("    supplierPrice: ").append(toIndentedString(supplierPrice)).append("\n");
    sb.append("    displayPrice: ").append(toIndentedString(displayPrice)).append("\n");
    sb.append("    internalPrice: ").append(toIndentedString(internalPrice)).append("\n");
    sb.append("    capturePrice: ").append(toIndentedString(capturePrice)).append("\n");
    sb.append("    cancellableByTraveler: ").append(toIndentedString(cancellableByTraveler)).append("\n");
    sb.append("    cancellableBySupplier: ").append(toIndentedString(cancellableBySupplier)).append("\n");
    sb.append("    cancellableWithCharges: ").append(toIndentedString(cancellableWithCharges)).append("\n");
    sb.append("    sourcePriceAfterRefund: ").append(toIndentedString(sourcePriceAfterRefund)).append("\n");
    sb.append("    supplierPriceAfterRefund: ").append(toIndentedString(supplierPriceAfterRefund)).append("\n");
    sb.append("    displayPriceAfterRefund: ").append(toIndentedString(displayPriceAfterRefund)).append("\n");
    sb.append("    internalPriceAfterRefund: ").append(toIndentedString(internalPriceAfterRefund)).append("\n");
    sb.append("    capturePriceAfterRefund: ").append(toIndentedString(capturePriceAfterRefund)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

