/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 25.2.3
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.Cardholder;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Merchants can choose to be paid using a VCC. That VCC record is stored here.
 */
@JsonPropertyOrder({
  VirtualCreditCard.JSON_PROPERTY_IDENTIFIER,
  VirtualCreditCard.JSON_PROPERTY_CARDHOLDER,
  VirtualCreditCard.JSON_PROPERTY_EXPIRATION_MONTH,
  VirtualCreditCard.JSON_PROPERTY_EXPIRATION_YEAR,
  VirtualCreditCard.JSON_PROPERTY_LAST4,
  VirtualCreditCard.JSON_PROPERTY_BRAND,
  VirtualCreditCard.JSON_PROPERTY_STATUS,
  VirtualCreditCard.JSON_PROPERTY_TYPE,
  VirtualCreditCard.JSON_PROPERTY_CANCELLATION_REASON
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-04-12T17:32:17.983408277+07:00[Asia/Bangkok]")
public class VirtualCreditCard {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_CARDHOLDER = "cardholder";
  private Cardholder cardholder;

  public static final String JSON_PROPERTY_EXPIRATION_MONTH = "expirationMonth";
  private Integer expirationMonth;

  public static final String JSON_PROPERTY_EXPIRATION_YEAR = "expirationYear";
  private Integer expirationYear;

  public static final String JSON_PROPERTY_LAST4 = "last4";
  private String last4;

  public static final String JSON_PROPERTY_BRAND = "brand";
  private String brand;

  /**
   * Whether authorizations can be approved on this card. May be blocked from activating cards depending on past-due Cardholder requirements. Defaults to inactive.
   */
  public enum StatusEnum {
    ACTIVE("ACTIVE"),
    
    INACTIVE("INACTIVE"),
    
    CANCELLED("CANCELLED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  /**
   * The type of the card.
   */
  public enum TypeEnum {
    VIRTUAL("VIRTUAL"),
    
    PHYSICAL("PHYSICAL");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  /**
   * The reason why the card was canceled.
   */
  public enum CancellationReasonEnum {
    LOST("LOST"),
    
    STOLEN("STOLEN"),
    
    DESIGN_REJECTED("DESIGN_REJECTED");

    private String value;

    CancellationReasonEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CancellationReasonEnum fromValue(String value) {
      for (CancellationReasonEnum b : CancellationReasonEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CANCELLATION_REASON = "cancellationReason";
  private CancellationReasonEnum cancellationReason;

  public VirtualCreditCard() {
  }

  public VirtualCreditCard identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique VCC ID from Issuer.
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public VirtualCreditCard cardholder(Cardholder cardholder) {
    
    this.cardholder = cardholder;
    return this;
  }

   /**
   * Get cardholder
   * @return cardholder
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CARDHOLDER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Cardholder getCardholder() {
    return cardholder;
  }


  @JsonProperty(JSON_PROPERTY_CARDHOLDER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCardholder(Cardholder cardholder) {
    this.cardholder = cardholder;
  }


  public VirtualCreditCard expirationMonth(Integer expirationMonth) {
    
    this.expirationMonth = expirationMonth;
    return this;
  }

   /**
   * The expiration month of the card.
   * minimum: 1
   * @return expirationMonth
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(1)
  @JsonProperty(JSON_PROPERTY_EXPIRATION_MONTH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getExpirationMonth() {
    return expirationMonth;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRATION_MONTH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setExpirationMonth(Integer expirationMonth) {
    this.expirationMonth = expirationMonth;
  }


  public VirtualCreditCard expirationYear(Integer expirationYear) {
    
    this.expirationYear = expirationYear;
    return this;
  }

   /**
   * The expiration month of the card.
   * minimum: 2023
   * @return expirationYear
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(2023)
  @JsonProperty(JSON_PROPERTY_EXPIRATION_YEAR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getExpirationYear() {
    return expirationYear;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRATION_YEAR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setExpirationYear(Integer expirationYear) {
    this.expirationYear = expirationYear;
  }


  public VirtualCreditCard last4(String last4) {
    
    this.last4 = last4;
    return this;
  }

   /**
   * The last 4 digits of the card number.
   * @return last4
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_LAST4)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLast4() {
    return last4;
  }


  @JsonProperty(JSON_PROPERTY_LAST4)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLast4(String last4) {
    this.last4 = last4;
  }


  public VirtualCreditCard brand(String brand) {
    
    this.brand = brand;
    return this;
  }

   /**
   * The brand of the card.
   * @return brand
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getBrand() {
    return brand;
  }


  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBrand(String brand) {
    this.brand = brand;
  }


  public VirtualCreditCard status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Whether authorizations can be approved on this card. May be blocked from activating cards depending on past-due Cardholder requirements. Defaults to inactive.
   * @return status
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public VirtualCreditCard type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of the card.
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public VirtualCreditCard cancellationReason(CancellationReasonEnum cancellationReason) {
    
    this.cancellationReason = cancellationReason;
    return this;
  }

   /**
   * The reason why the card was canceled.
   * @return cancellationReason
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CANCELLATION_REASON)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CancellationReasonEnum getCancellationReason() {
    return cancellationReason;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_REASON)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCancellationReason(CancellationReasonEnum cancellationReason) {
    this.cancellationReason = cancellationReason;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VirtualCreditCard virtualCreditCard = (VirtualCreditCard) o;
    return Objects.equals(this.identifier, virtualCreditCard.identifier) &&
        Objects.equals(this.cardholder, virtualCreditCard.cardholder) &&
        Objects.equals(this.expirationMonth, virtualCreditCard.expirationMonth) &&
        Objects.equals(this.expirationYear, virtualCreditCard.expirationYear) &&
        Objects.equals(this.last4, virtualCreditCard.last4) &&
        Objects.equals(this.brand, virtualCreditCard.brand) &&
        Objects.equals(this.status, virtualCreditCard.status) &&
        Objects.equals(this.type, virtualCreditCard.type) &&
        Objects.equals(this.cancellationReason, virtualCreditCard.cancellationReason);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, cardholder, expirationMonth, expirationYear, last4, brand, status, type, cancellationReason);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VirtualCreditCard {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    cardholder: ").append(toIndentedString(cardholder)).append("\n");
    sb.append("    expirationMonth: ").append(toIndentedString(expirationMonth)).append("\n");
    sb.append("    expirationYear: ").append(toIndentedString(expirationYear)).append("\n");
    sb.append("    last4: ").append(toIndentedString(last4)).append("\n");
    sb.append("    brand: ").append(toIndentedString(brand)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    cancellationReason: ").append(toIndentedString(cancellationReason)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

