/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;
import io.trippay.sdk.payment.model.Account;
import io.trippay.sdk.payment.model.UpdateAccountStatusRequest;
import io.trippay.sdk.payment.model.UpsertAccountAcquirerRequest;
import io.trippay.sdk.payment.model.UpsertAccountTaskRequest;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class AdministrationAccountControllerApi {
    private ApiClient apiClient;

    public AdministrationAccountControllerApi() {
        this(new ApiClient());
    }

    @Autowired
    public AdministrationAccountControllerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createAccountAcquirerRequestCreation(String id, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest, String winkVersion) throws WebClientResponseException {
        UpsertAccountAcquirerRequest postBody = upsertAccountAcquirerRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling createAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertAccountAcquirerRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAccountAcquirerRequest' when calling createAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.apiClient.invokeAPI("/api/administration/account/{id}/acquirer", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> createAccountAcquirer(String id, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.createAccountAcquirerRequestCreation(id, upsertAccountAcquirerRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> createAccountAcquirerWithHttpInfo(String id, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.createAccountAcquirerRequestCreation(id, upsertAccountAcquirerRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createAccountAcquirerWithResponseSpec(String id, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest, String winkVersion) throws WebClientResponseException {
        return this.createAccountAcquirerRequestCreation(id, upsertAccountAcquirerRequest, winkVersion);
    }

    private WebClient.ResponseSpec createAccountTaskRequestCreation(String id, UpsertAccountTaskRequest upsertAccountTaskRequest, String winkVersion) throws WebClientResponseException {
        UpsertAccountTaskRequest postBody = upsertAccountTaskRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling createAccountTask", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertAccountTaskRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAccountTaskRequest' when calling createAccountTask", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.apiClient.invokeAPI("/api/administration/account/{id}/task", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> createAccountTask(String id, UpsertAccountTaskRequest upsertAccountTaskRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.createAccountTaskRequestCreation(id, upsertAccountTaskRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> createAccountTaskWithHttpInfo(String id, UpsertAccountTaskRequest upsertAccountTaskRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.createAccountTaskRequestCreation(id, upsertAccountTaskRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createAccountTaskWithResponseSpec(String id, UpsertAccountTaskRequest upsertAccountTaskRequest, String winkVersion) throws WebClientResponseException {
        return this.createAccountTaskRequestCreation(id, upsertAccountTaskRequest, winkVersion);
    }

    private WebClient.ResponseSpec removeAccountAcquirerRequestCreation(String id, String acquirerId, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (acquirerId == null) {
            throw new WebClientResponseException("Missing the required parameter 'acquirerId' when calling removeAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        pathParams.put("acquirerId", acquirerId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.apiClient.invokeAPI("/api/administration/account/{id}/acquirer/{acquirerId}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> removeAccountAcquirer(String id, String acquirerId, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.removeAccountAcquirerRequestCreation(id, acquirerId, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> removeAccountAcquirerWithHttpInfo(String id, String acquirerId, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.removeAccountAcquirerRequestCreation(id, acquirerId, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeAccountAcquirerWithResponseSpec(String id, String acquirerId, String winkVersion) throws WebClientResponseException {
        return this.removeAccountAcquirerRequestCreation(id, acquirerId, winkVersion);
    }

    private WebClient.ResponseSpec removeAccountTaskRequestCreation(String id, String taskId, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeAccountTask", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (taskId == null) {
            throw new WebClientResponseException("Missing the required parameter 'taskId' when calling removeAccountTask", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        pathParams.put("taskId", taskId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.apiClient.invokeAPI("/api/administration/account/{id}/task/{taskId}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> removeAccountTask(String id, String taskId, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.removeAccountTaskRequestCreation(id, taskId, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> removeAccountTaskWithHttpInfo(String id, String taskId, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.removeAccountTaskRequestCreation(id, taskId, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeAccountTaskWithResponseSpec(String id, String taskId, String winkVersion) throws WebClientResponseException {
        return this.removeAccountTaskRequestCreation(id, taskId, winkVersion);
    }

    private WebClient.ResponseSpec updateAccountAcquirerRequestCreation(String id, String acquirerId, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest, String winkVersion) throws WebClientResponseException {
        UpsertAccountAcquirerRequest postBody = upsertAccountAcquirerRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (acquirerId == null) {
            throw new WebClientResponseException("Missing the required parameter 'acquirerId' when calling updateAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertAccountAcquirerRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAccountAcquirerRequest' when calling updateAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        pathParams.put("acquirerId", acquirerId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.apiClient.invokeAPI("/api/administration/account/{id}/acquirer/{acquirerId}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> updateAccountAcquirer(String id, String acquirerId, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.updateAccountAcquirerRequestCreation(id, acquirerId, upsertAccountAcquirerRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> updateAccountAcquirerWithHttpInfo(String id, String acquirerId, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.updateAccountAcquirerRequestCreation(id, acquirerId, upsertAccountAcquirerRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateAccountAcquirerWithResponseSpec(String id, String acquirerId, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest, String winkVersion) throws WebClientResponseException {
        return this.updateAccountAcquirerRequestCreation(id, acquirerId, upsertAccountAcquirerRequest, winkVersion);
    }

    private WebClient.ResponseSpec updateAccountStatusRequestCreation(String id, UpdateAccountStatusRequest updateAccountStatusRequest, String winkVersion) throws WebClientResponseException {
        UpdateAccountStatusRequest postBody = updateAccountStatusRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateAccountStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (updateAccountStatusRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateAccountStatusRequest' when calling updateAccountStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.apiClient.invokeAPI("/api/administration/account/{id}/status", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> updateAccountStatus(String id, UpdateAccountStatusRequest updateAccountStatusRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.updateAccountStatusRequestCreation(id, updateAccountStatusRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> updateAccountStatusWithHttpInfo(String id, UpdateAccountStatusRequest updateAccountStatusRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.updateAccountStatusRequestCreation(id, updateAccountStatusRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateAccountStatusWithResponseSpec(String id, UpdateAccountStatusRequest updateAccountStatusRequest, String winkVersion) throws WebClientResponseException {
        return this.updateAccountStatusRequestCreation(id, updateAccountStatusRequest, winkVersion);
    }

    private WebClient.ResponseSpec updateAccountTaskRequestCreation(String id, String taskId, UpsertAccountTaskRequest upsertAccountTaskRequest, String winkVersion) throws WebClientResponseException {
        UpsertAccountTaskRequest postBody = upsertAccountTaskRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateAccountTask", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (taskId == null) {
            throw new WebClientResponseException("Missing the required parameter 'taskId' when calling updateAccountTask", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertAccountTaskRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAccountTaskRequest' when calling updateAccountTask", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        pathParams.put("taskId", taskId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.apiClient.invokeAPI("/api/administration/account/{id}/task/{taskId}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> updateAccountTask(String id, String taskId, UpsertAccountTaskRequest upsertAccountTaskRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.updateAccountTaskRequestCreation(id, taskId, upsertAccountTaskRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> updateAccountTaskWithHttpInfo(String id, String taskId, UpsertAccountTaskRequest upsertAccountTaskRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.updateAccountTaskRequestCreation(id, taskId, upsertAccountTaskRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateAccountTaskWithResponseSpec(String id, String taskId, UpsertAccountTaskRequest upsertAccountTaskRequest, String winkVersion) throws WebClientResponseException {
        return this.updateAccountTaskRequestCreation(id, taskId, upsertAccountTaskRequest, winkVersion);
    }
}

