/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.AcquirerCredentials;
import jakarta.annotation.Nonnull;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"priority", "vendor", "type", "currencyCode", "credentials"})
public class UpsertAccountAcquirerRequest {
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private Integer priority;
    public static final String JSON_PROPERTY_VENDOR = "vendor";
    private VendorEnum vendor;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
    private String currencyCode;
    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private List<AcquirerCredentials> credentials = new ArrayList<AcquirerCredentials>();

    public UpsertAccountAcquirerRequest priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getPriority() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public UpsertAccountAcquirerRequest vendor(VendorEnum vendor) {
        this.vendor = vendor;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="vendor")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public VendorEnum getVendor() {
        return this.vendor;
    }

    @JsonProperty(value="vendor")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVendor(VendorEnum vendor) {
        this.vendor = vendor;
    }

    public UpsertAccountAcquirerRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public UpsertAccountAcquirerRequest currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public UpsertAccountAcquirerRequest credentials(List<AcquirerCredentials> credentials) {
        this.credentials = credentials;
        return this;
    }

    public UpsertAccountAcquirerRequest addCredentialsItem(AcquirerCredentials credentialsItem) {
        this.credentials.add(credentialsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<AcquirerCredentials> getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCredentials(List<AcquirerCredentials> credentials) {
        this.credentials = credentials;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpsertAccountAcquirerRequest upsertAccountAcquirerRequest = (UpsertAccountAcquirerRequest)o;
        return Objects.equals(this.priority, upsertAccountAcquirerRequest.priority) && Objects.equals((Object)this.vendor, (Object)upsertAccountAcquirerRequest.vendor) && Objects.equals((Object)this.type, (Object)upsertAccountAcquirerRequest.type) && Objects.equals(this.currencyCode, upsertAccountAcquirerRequest.currencyCode) && Objects.equals(this.credentials, upsertAccountAcquirerRequest.credentials);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.priority, this.vendor, this.type, this.currencyCode, this.credentials});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpsertAccountAcquirerRequest {\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    vendor: ").append(this.toIndentedString((Object)this.vendor)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum VendorEnum {
        STRIPE("STRIPE"),
        YAPILY("YAPILY"),
        PAY_PAL("PAY_PAL"),
        NMI("NMI"),
        AGENT("AGENT");

        private String value;

        private VendorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static VendorEnum fromValue(String value) {
            for (VendorEnum b : VendorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        CREDIT_CARD("CREDIT_CARD"),
        BANK_TRANSFER("BANK_TRANSFER"),
        PAY_PAL("PAY_PAL"),
        CRYPTO("CRYPTO"),
        AGENT("AGENT"),
        CASH("CASH");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

