/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 25.2.7
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.PageBookingContract;
import io.trippay.sdk.payment.model.TotalAggregateFunds;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * BookingContractGridResponse
 */
@JsonPropertyOrder({
  BookingContractGridResponse.JSON_PROPERTY_PAGE,
  BookingContractGridResponse.JSON_PROPERTY_TOTAL_FUNDS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-04-26T14:25:21.883820559+07:00[Asia/Bangkok]")
public class BookingContractGridResponse {
  public static final String JSON_PROPERTY_PAGE = "page";
  private PageBookingContract page;

  public static final String JSON_PROPERTY_TOTAL_FUNDS = "totalFunds";
  private TotalAggregateFunds totalFunds;

  public BookingContractGridResponse() {
  }

  public BookingContractGridResponse page(PageBookingContract page) {
    
    this.page = page;
    return this;
  }

   /**
   * Get page
   * @return page
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PageBookingContract getPage() {
    return page;
  }


  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPage(PageBookingContract page) {
    this.page = page;
  }


  public BookingContractGridResponse totalFunds(TotalAggregateFunds totalFunds) {
    
    this.totalFunds = totalFunds;
    return this;
  }

   /**
   * Get totalFunds
   * @return totalFunds
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FUNDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TotalAggregateFunds getTotalFunds() {
    return totalFunds;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FUNDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTotalFunds(TotalAggregateFunds totalFunds) {
    this.totalFunds = totalFunds;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingContractGridResponse bookingContractGridResponse = (BookingContractGridResponse) o;
    return Objects.equals(this.page, bookingContractGridResponse.page) &&
        Objects.equals(this.totalFunds, bookingContractGridResponse.totalFunds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(page, totalFunds);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingContractGridResponse {\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    totalFunds: ").append(toIndentedString(totalFunds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

