/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 25.2.7
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.UpsertAddressRequest;
import java.time.LocalDate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * VerifyAccountRequest
 */
@JsonPropertyOrder({
  VerifyAccountRequest.JSON_PROPERTY_ADDRESS,
  VerifyAccountRequest.JSON_PROPERTY_OWNER_TYPE,
  VerifyAccountRequest.JSON_PROPERTY_OWNER_TYPE_IDENTIFIER,
  VerifyAccountRequest.JSON_PROPERTY_DOB,
  VerifyAccountRequest.JSON_PROPERTY_DISBURSEMENT_TYPE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-04-26T14:25:21.883820559+07:00[Asia/Bangkok]")
public class VerifyAccountRequest {
  public static final String JSON_PROPERTY_ADDRESS = "address";
  private UpsertAddressRequest address;

  /**
   * Whether the account is a company or individual.
   */
  public enum OwnerTypeEnum {
    COMPANY("COMPANY"),
    
    INDIVIDUAL("INDIVIDUAL");

    private String value;

    OwnerTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OwnerTypeEnum fromValue(String value) {
      for (OwnerTypeEnum b : OwnerTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
  private OwnerTypeEnum ownerType;

  public static final String JSON_PROPERTY_OWNER_TYPE_IDENTIFIER = "ownerTypeIdentifier";
  private String ownerTypeIdentifier;

  public static final String JSON_PROPERTY_DOB = "dob";
  private LocalDate dob;

  /**
   * The method which the account holder whishes to be paid.
   */
  public enum DisbursementTypeEnum {
    VIRTUAL_CREDIT_CARD("VIRTUAL_CREDIT_CARD"),
    
    BANK_TRANSFER("BANK_TRANSFER");

    private String value;

    DisbursementTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DisbursementTypeEnum fromValue(String value) {
      for (DisbursementTypeEnum b : DisbursementTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DISBURSEMENT_TYPE = "disbursementType";
  private DisbursementTypeEnum disbursementType = DisbursementTypeEnum.VIRTUAL_CREDIT_CARD;

  public VerifyAccountRequest() {
  }

  public VerifyAccountRequest address(UpsertAddressRequest address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UpsertAddressRequest getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(UpsertAddressRequest address) {
    this.address = address;
  }


  public VerifyAccountRequest ownerType(OwnerTypeEnum ownerType) {
    
    this.ownerType = ownerType;
    return this;
  }

   /**
   * Whether the account is a company or individual.
   * @return ownerType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OWNER_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OwnerTypeEnum getOwnerType() {
    return ownerType;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerType(OwnerTypeEnum ownerType) {
    this.ownerType = ownerType;
  }


  public VerifyAccountRequest ownerTypeIdentifier(String ownerTypeIdentifier) {
    
    this.ownerTypeIdentifier = ownerTypeIdentifier;
    return this;
  }

   /**
   * Either the TIN (individual) or the EIN (company) number of the individual.
   * @return ownerTypeIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OWNER_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOwnerTypeIdentifier() {
    return ownerTypeIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerTypeIdentifier(String ownerTypeIdentifier) {
    this.ownerTypeIdentifier = ownerTypeIdentifier;
  }


  public VerifyAccountRequest dob(LocalDate dob) {
    
    this.dob = dob;
    return this;
  }

   /**
   * Date of birth in the case of an individual.
   * @return dob
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DOB)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getDob() {
    return dob;
  }


  @JsonProperty(JSON_PROPERTY_DOB)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDob(LocalDate dob) {
    this.dob = dob;
  }


  public VerifyAccountRequest disbursementType(DisbursementTypeEnum disbursementType) {
    
    this.disbursementType = disbursementType;
    return this;
  }

   /**
   * The method which the account holder whishes to be paid.
   * @return disbursementType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISBURSEMENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DisbursementTypeEnum getDisbursementType() {
    return disbursementType;
  }


  @JsonProperty(JSON_PROPERTY_DISBURSEMENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisbursementType(DisbursementTypeEnum disbursementType) {
    this.disbursementType = disbursementType;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VerifyAccountRequest verifyAccountRequest = (VerifyAccountRequest) o;
    return Objects.equals(this.address, verifyAccountRequest.address) &&
        Objects.equals(this.ownerType, verifyAccountRequest.ownerType) &&
        Objects.equals(this.ownerTypeIdentifier, verifyAccountRequest.ownerTypeIdentifier) &&
        Objects.equals(this.dob, verifyAccountRequest.dob) &&
        Objects.equals(this.disbursementType, verifyAccountRequest.disbursementType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(address, ownerType, ownerTypeIdentifier, dob, disbursementType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VerifyAccountRequest {\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    ownerType: ").append(toIndentedString(ownerType)).append("\n");
    sb.append("    ownerTypeIdentifier: ").append(toIndentedString(ownerTypeIdentifier)).append("\n");
    sb.append("    dob: ").append(toIndentedString(dob)).append("\n");
    sb.append("    disbursementType: ").append(toIndentedString(disbursementType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

