/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.trippay.sdk.payment.model.Acquirer;
import io.trippay.sdk.payment.model.Moneys;
import io.trippay.sdk.payment.model.PricedSupplierContractItemWithAcquirer;
import io.trippay.sdk.payment.model.Quote;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"identifier", "supplierIdentifier", "supplierName", "displayPriceQuote", "supplierPriceQuote", "internalPriceQuote", "capturePriceQuote", "itemList", "acquirer", "externalSupplierIdentifier", "externalSupplierBookingCode", "externalTransactionIdentifier", "totalCapturePrice", "totalPrice", "totalDisplayPrice", "totalSupplierPrice", "totalInternalPrice"})
public class PricedSupplierContractWithAcquirer {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
    private UUID supplierIdentifier;
    public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
    private String supplierName;
    public static final String JSON_PROPERTY_DISPLAY_PRICE_QUOTE = "displayPriceQuote";
    private Quote displayPriceQuote;
    public static final String JSON_PROPERTY_SUPPLIER_PRICE_QUOTE = "supplierPriceQuote";
    private Quote supplierPriceQuote;
    public static final String JSON_PROPERTY_INTERNAL_PRICE_QUOTE = "internalPriceQuote";
    private Quote internalPriceQuote;
    public static final String JSON_PROPERTY_CAPTURE_PRICE_QUOTE = "capturePriceQuote";
    private Quote capturePriceQuote;
    public static final String JSON_PROPERTY_ITEM_LIST = "itemList";
    private List<PricedSupplierContractItemWithAcquirer> itemList = new ArrayList<PricedSupplierContractItemWithAcquirer>();
    public static final String JSON_PROPERTY_ACQUIRER = "acquirer";
    private List<Acquirer> acquirer = new ArrayList<Acquirer>();
    public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER = "externalSupplierIdentifier";
    private String externalSupplierIdentifier;
    public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
    private String externalSupplierBookingCode;
    public static final String JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER = "externalTransactionIdentifier";
    private String externalTransactionIdentifier;
    public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE = "totalCapturePrice";
    private Moneys totalCapturePrice;
    public static final String JSON_PROPERTY_TOTAL_PRICE = "totalPrice";
    private Moneys totalPrice;
    public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE = "totalDisplayPrice";
    private Moneys totalDisplayPrice;
    public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE = "totalSupplierPrice";
    private Moneys totalSupplierPrice;
    public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE = "totalInternalPrice";
    private Moneys totalInternalPrice;

    public PricedSupplierContractWithAcquirer() {
    }

    @JsonCreator
    public PricedSupplierContractWithAcquirer(@JsonProperty(value="itemList") List<PricedSupplierContractItemWithAcquirer> itemList) {
        this();
        this.itemList = itemList;
    }

    public PricedSupplierContractWithAcquirer identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public PricedSupplierContractWithAcquirer supplierIdentifier(UUID supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getSupplierIdentifier() {
        return this.supplierIdentifier;
    }

    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierIdentifier(UUID supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
    }

    public PricedSupplierContractWithAcquirer supplierName(String supplierName) {
        this.supplierName = supplierName;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="supplierName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSupplierName() {
        return this.supplierName;
    }

    @JsonProperty(value="supplierName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public PricedSupplierContractWithAcquirer displayPriceQuote(Quote displayPriceQuote) {
        this.displayPriceQuote = displayPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="displayPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Quote getDisplayPriceQuote() {
        return this.displayPriceQuote;
    }

    @JsonProperty(value="displayPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayPriceQuote(Quote displayPriceQuote) {
        this.displayPriceQuote = displayPriceQuote;
    }

    public PricedSupplierContractWithAcquirer supplierPriceQuote(Quote supplierPriceQuote) {
        this.supplierPriceQuote = supplierPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="supplierPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Quote getSupplierPriceQuote() {
        return this.supplierPriceQuote;
    }

    @JsonProperty(value="supplierPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierPriceQuote(Quote supplierPriceQuote) {
        this.supplierPriceQuote = supplierPriceQuote;
    }

    public PricedSupplierContractWithAcquirer internalPriceQuote(Quote internalPriceQuote) {
        this.internalPriceQuote = internalPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="internalPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Quote getInternalPriceQuote() {
        return this.internalPriceQuote;
    }

    @JsonProperty(value="internalPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalPriceQuote(Quote internalPriceQuote) {
        this.internalPriceQuote = internalPriceQuote;
    }

    public PricedSupplierContractWithAcquirer capturePriceQuote(Quote capturePriceQuote) {
        this.capturePriceQuote = capturePriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="capturePriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Quote getCapturePriceQuote() {
        return this.capturePriceQuote;
    }

    @JsonProperty(value="capturePriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCapturePriceQuote(Quote capturePriceQuote) {
        this.capturePriceQuote = capturePriceQuote;
    }

    @Nonnull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="itemList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @Valid @Size(min=1, max=0x7FFFFFFF) List<PricedSupplierContractItemWithAcquirer> getItemList() {
        return this.itemList;
    }

    public PricedSupplierContractWithAcquirer acquirer(List<Acquirer> acquirer) {
        this.acquirer = acquirer;
        return this;
    }

    public PricedSupplierContractWithAcquirer addAcquirerItem(Acquirer acquirerItem) {
        this.acquirer.add(acquirerItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="acquirer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Acquirer> getAcquirer() {
        return this.acquirer;
    }

    @JsonProperty(value="acquirer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAcquirer(List<Acquirer> acquirer) {
        this.acquirer = acquirer;
    }

    public PricedSupplierContractWithAcquirer externalSupplierIdentifier(String externalSupplierIdentifier) {
        this.externalSupplierIdentifier = externalSupplierIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="externalSupplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getExternalSupplierIdentifier() {
        return this.externalSupplierIdentifier;
    }

    @JsonProperty(value="externalSupplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExternalSupplierIdentifier(String externalSupplierIdentifier) {
        this.externalSupplierIdentifier = externalSupplierIdentifier;
    }

    public PricedSupplierContractWithAcquirer externalSupplierBookingCode(String externalSupplierBookingCode) {
        this.externalSupplierBookingCode = externalSupplierBookingCode;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="externalSupplierBookingCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getExternalSupplierBookingCode() {
        return this.externalSupplierBookingCode;
    }

    @JsonProperty(value="externalSupplierBookingCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExternalSupplierBookingCode(String externalSupplierBookingCode) {
        this.externalSupplierBookingCode = externalSupplierBookingCode;
    }

    public PricedSupplierContractWithAcquirer externalTransactionIdentifier(String externalTransactionIdentifier) {
        this.externalTransactionIdentifier = externalTransactionIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="externalTransactionIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getExternalTransactionIdentifier() {
        return this.externalTransactionIdentifier;
    }

    @JsonProperty(value="externalTransactionIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExternalTransactionIdentifier(String externalTransactionIdentifier) {
        this.externalTransactionIdentifier = externalTransactionIdentifier;
    }

    public PricedSupplierContractWithAcquirer totalCapturePrice(Moneys totalCapturePrice) {
        this.totalCapturePrice = totalCapturePrice;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalCapturePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalCapturePrice() {
        return this.totalCapturePrice;
    }

    @JsonProperty(value="totalCapturePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalCapturePrice(Moneys totalCapturePrice) {
        this.totalCapturePrice = totalCapturePrice;
    }

    public PricedSupplierContractWithAcquirer totalPrice(Moneys totalPrice) {
        this.totalPrice = totalPrice;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalPrice() {
        return this.totalPrice;
    }

    @JsonProperty(value="totalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalPrice(Moneys totalPrice) {
        this.totalPrice = totalPrice;
    }

    public PricedSupplierContractWithAcquirer totalDisplayPrice(Moneys totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalDisplayPrice() {
        return this.totalDisplayPrice;
    }

    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalDisplayPrice(Moneys totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
    }

    public PricedSupplierContractWithAcquirer totalSupplierPrice(Moneys totalSupplierPrice) {
        this.totalSupplierPrice = totalSupplierPrice;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalSupplierPrice() {
        return this.totalSupplierPrice;
    }

    @JsonProperty(value="totalSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSupplierPrice(Moneys totalSupplierPrice) {
        this.totalSupplierPrice = totalSupplierPrice;
    }

    public PricedSupplierContractWithAcquirer totalInternalPrice(Moneys totalInternalPrice) {
        this.totalInternalPrice = totalInternalPrice;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalInternalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalInternalPrice() {
        return this.totalInternalPrice;
    }

    @JsonProperty(value="totalInternalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalInternalPrice(Moneys totalInternalPrice) {
        this.totalInternalPrice = totalInternalPrice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PricedSupplierContractWithAcquirer pricedSupplierContractWithAcquirer = (PricedSupplierContractWithAcquirer)o;
        return Objects.equals(this.identifier, pricedSupplierContractWithAcquirer.identifier) && Objects.equals(this.supplierIdentifier, pricedSupplierContractWithAcquirer.supplierIdentifier) && Objects.equals(this.supplierName, pricedSupplierContractWithAcquirer.supplierName) && Objects.equals(this.displayPriceQuote, pricedSupplierContractWithAcquirer.displayPriceQuote) && Objects.equals(this.supplierPriceQuote, pricedSupplierContractWithAcquirer.supplierPriceQuote) && Objects.equals(this.internalPriceQuote, pricedSupplierContractWithAcquirer.internalPriceQuote) && Objects.equals(this.capturePriceQuote, pricedSupplierContractWithAcquirer.capturePriceQuote) && Objects.equals(this.itemList, pricedSupplierContractWithAcquirer.itemList) && Objects.equals(this.acquirer, pricedSupplierContractWithAcquirer.acquirer) && Objects.equals(this.externalSupplierIdentifier, pricedSupplierContractWithAcquirer.externalSupplierIdentifier) && Objects.equals(this.externalSupplierBookingCode, pricedSupplierContractWithAcquirer.externalSupplierBookingCode) && Objects.equals(this.externalTransactionIdentifier, pricedSupplierContractWithAcquirer.externalTransactionIdentifier) && Objects.equals(this.totalCapturePrice, pricedSupplierContractWithAcquirer.totalCapturePrice) && Objects.equals(this.totalPrice, pricedSupplierContractWithAcquirer.totalPrice) && Objects.equals(this.totalDisplayPrice, pricedSupplierContractWithAcquirer.totalDisplayPrice) && Objects.equals(this.totalSupplierPrice, pricedSupplierContractWithAcquirer.totalSupplierPrice) && Objects.equals(this.totalInternalPrice, pricedSupplierContractWithAcquirer.totalInternalPrice);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.supplierIdentifier, this.supplierName, this.displayPriceQuote, this.supplierPriceQuote, this.internalPriceQuote, this.capturePriceQuote, this.itemList, this.acquirer, this.externalSupplierIdentifier, this.externalSupplierBookingCode, this.externalTransactionIdentifier, this.totalCapturePrice, this.totalPrice, this.totalDisplayPrice, this.totalSupplierPrice, this.totalInternalPrice);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PricedSupplierContractWithAcquirer {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    supplierIdentifier: ").append(this.toIndentedString(this.supplierIdentifier)).append("\n");
        sb.append("    supplierName: ").append(this.toIndentedString(this.supplierName)).append("\n");
        sb.append("    displayPriceQuote: ").append(this.toIndentedString(this.displayPriceQuote)).append("\n");
        sb.append("    supplierPriceQuote: ").append(this.toIndentedString(this.supplierPriceQuote)).append("\n");
        sb.append("    internalPriceQuote: ").append(this.toIndentedString(this.internalPriceQuote)).append("\n");
        sb.append("    capturePriceQuote: ").append(this.toIndentedString(this.capturePriceQuote)).append("\n");
        sb.append("    itemList: ").append(this.toIndentedString(this.itemList)).append("\n");
        sb.append("    acquirer: ").append(this.toIndentedString(this.acquirer)).append("\n");
        sb.append("    externalSupplierIdentifier: ").append(this.toIndentedString(this.externalSupplierIdentifier)).append("\n");
        sb.append("    externalSupplierBookingCode: ").append(this.toIndentedString(this.externalSupplierBookingCode)).append("\n");
        sb.append("    externalTransactionIdentifier: ").append(this.toIndentedString(this.externalTransactionIdentifier)).append("\n");
        sb.append("    totalCapturePrice: ").append(this.toIndentedString(this.totalCapturePrice)).append("\n");
        sb.append("    totalPrice: ").append(this.toIndentedString(this.totalPrice)).append("\n");
        sb.append("    totalDisplayPrice: ").append(this.toIndentedString(this.totalDisplayPrice)).append("\n");
        sb.append("    totalSupplierPrice: ").append(this.toIndentedString(this.totalSupplierPrice)).append("\n");
        sb.append("    totalInternalPrice: ").append(this.toIndentedString(this.totalInternalPrice)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

