/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.Moneys;
import io.trippay.sdk.payment.model.PricedSupplierContract;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"affiliateAccountIdentifier", "affiliateAccountIdentifierType", "displayCurrency", "sourceUrl", "contractList", "totalDisplayPrice"})
public class PricedBookingContract {
    public static final String JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER = "affiliateAccountIdentifier";
    private UUID affiliateAccountIdentifier;
    public static final String JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER_TYPE = "affiliateAccountIdentifierType";
    private AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType;
    public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
    private String displayCurrency = "USD";
    public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
    private String sourceUrl;
    public static final String JSON_PROPERTY_CONTRACT_LIST = "contractList";
    private List<PricedSupplierContract> contractList = new ArrayList<PricedSupplierContract>();
    public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE = "totalDisplayPrice";
    private Moneys totalDisplayPrice;

    public PricedBookingContract affiliateAccountIdentifier(UUID affiliateAccountIdentifier) {
        this.affiliateAccountIdentifier = affiliateAccountIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="affiliateAccountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getAffiliateAccountIdentifier() {
        return this.affiliateAccountIdentifier;
    }

    @JsonProperty(value="affiliateAccountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAffiliateAccountIdentifier(UUID affiliateAccountIdentifier) {
        this.affiliateAccountIdentifier = affiliateAccountIdentifier;
    }

    public PricedBookingContract affiliateAccountIdentifierType(AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType) {
        this.affiliateAccountIdentifierType = affiliateAccountIdentifierType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="affiliateAccountIdentifierType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AffiliateAccountIdentifierTypeEnum getAffiliateAccountIdentifierType() {
        return this.affiliateAccountIdentifierType;
    }

    @JsonProperty(value="affiliateAccountIdentifierType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAffiliateAccountIdentifierType(AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType) {
        this.affiliateAccountIdentifierType = affiliateAccountIdentifierType;
    }

    public PricedBookingContract displayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDisplayCurrency() {
        return this.displayCurrency;
    }

    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
    }

    public PricedBookingContract sourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public PricedBookingContract contractList(List<PricedSupplierContract> contractList) {
        this.contractList = contractList;
        return this;
    }

    public PricedBookingContract addContractListItem(PricedSupplierContract contractListItem) {
        this.contractList.add(contractListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="contractList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<PricedSupplierContract> getContractList() {
        return this.contractList;
    }

    @JsonProperty(value="contractList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContractList(List<PricedSupplierContract> contractList) {
        this.contractList = contractList;
    }

    public PricedBookingContract totalDisplayPrice(Moneys totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalDisplayPrice() {
        return this.totalDisplayPrice;
    }

    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalDisplayPrice(Moneys totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PricedBookingContract pricedBookingContract = (PricedBookingContract)o;
        return Objects.equals(this.affiliateAccountIdentifier, pricedBookingContract.affiliateAccountIdentifier) && Objects.equals((Object)this.affiliateAccountIdentifierType, (Object)pricedBookingContract.affiliateAccountIdentifierType) && Objects.equals(this.displayCurrency, pricedBookingContract.displayCurrency) && Objects.equals(this.sourceUrl, pricedBookingContract.sourceUrl) && Objects.equals(this.contractList, pricedBookingContract.contractList) && Objects.equals(this.totalDisplayPrice, pricedBookingContract.totalDisplayPrice);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.affiliateAccountIdentifier, this.affiliateAccountIdentifierType, this.displayCurrency, this.sourceUrl, this.contractList, this.totalDisplayPrice});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PricedBookingContract {\n");
        sb.append("    affiliateAccountIdentifier: ").append(this.toIndentedString(this.affiliateAccountIdentifier)).append("\n");
        sb.append("    affiliateAccountIdentifierType: ").append(this.toIndentedString((Object)this.affiliateAccountIdentifierType)).append("\n");
        sb.append("    displayCurrency: ").append(this.toIndentedString(this.displayCurrency)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    contractList: ").append(this.toIndentedString(this.contractList)).append("\n");
        sb.append("    totalDisplayPrice: ").append(this.toIndentedString(this.totalDisplayPrice)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AffiliateAccountIdentifierTypeEnum {
        INTERNAL("INTERNAL"),
        EXTERNAL("EXTERNAL");

        private String value;

        private AffiliateAccountIdentifierTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AffiliateAccountIdentifierTypeEnum fromValue(String value) {
            for (AffiliateAccountIdentifierTypeEnum b : AffiliateAccountIdentifierTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

