/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.BookingUser;
import io.trippay.sdk.payment.model.Itinerary;
import io.trippay.sdk.payment.model.Moneys;
import io.trippay.sdk.payment.model.PricedDailyRate;
import io.trippay.sdk.payment.model.RawBeneficiary;
import io.trippay.sdk.payment.model.SupplierContractItemPolicy;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"user", "nameInEnglish", "descriptionInEnglish", "price", "displayPrice", "supplierPrice", "internalPrice", "itinerary", "pricingType", "type", "perUseQuantity", "beneficiaryList", "payable", "policy", "externalIdentifier", "dailyRateList", "totalPrice", "totalDisplayPrice", "totalSupplierPrice", "totalInternalPrice"})
public class PricedSupplierContractItem {
    public static final String JSON_PROPERTY_USER = "user";
    private BookingUser user;
    public static final String JSON_PROPERTY_NAME_IN_ENGLISH = "nameInEnglish";
    private String nameInEnglish;
    public static final String JSON_PROPERTY_DESCRIPTION_IN_ENGLISH = "descriptionInEnglish";
    private String descriptionInEnglish;
    public static final String JSON_PROPERTY_PRICE = "price";
    private Moneys price;
    public static final String JSON_PROPERTY_DISPLAY_PRICE = "displayPrice";
    private Moneys displayPrice;
    public static final String JSON_PROPERTY_SUPPLIER_PRICE = "supplierPrice";
    private Moneys supplierPrice;
    public static final String JSON_PROPERTY_INTERNAL_PRICE = "internalPrice";
    private Moneys internalPrice;
    public static final String JSON_PROPERTY_ITINERARY = "itinerary";
    private Itinerary itinerary;
    public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
    private PricingTypeEnum pricingType;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_PER_USE_QUANTITY = "perUseQuantity";
    private Integer perUseQuantity;
    public static final String JSON_PROPERTY_BENEFICIARY_LIST = "beneficiaryList";
    private List<RawBeneficiary> beneficiaryList = new ArrayList<RawBeneficiary>();
    public static final String JSON_PROPERTY_PAYABLE = "payable";
    private PayableEnum payable;
    public static final String JSON_PROPERTY_POLICY = "policy";
    private SupplierContractItemPolicy policy;
    public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
    private String externalIdentifier;
    public static final String JSON_PROPERTY_DAILY_RATE_LIST = "dailyRateList";
    private List<PricedDailyRate> dailyRateList = new ArrayList<PricedDailyRate>();
    public static final String JSON_PROPERTY_TOTAL_PRICE = "totalPrice";
    private Moneys totalPrice;
    public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE = "totalDisplayPrice";
    private Moneys totalDisplayPrice;
    public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE = "totalSupplierPrice";
    private Moneys totalSupplierPrice;
    public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE = "totalInternalPrice";
    private Moneys totalInternalPrice;

    public PricedSupplierContractItem user(BookingUser user) {
        this.user = user;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BookingUser getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUser(BookingUser user) {
        this.user = user;
    }

    public PricedSupplierContractItem nameInEnglish(String nameInEnglish) {
        this.nameInEnglish = nameInEnglish;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="nameInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getNameInEnglish() {
        return this.nameInEnglish;
    }

    @JsonProperty(value="nameInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNameInEnglish(String nameInEnglish) {
        this.nameInEnglish = nameInEnglish;
    }

    public PricedSupplierContractItem descriptionInEnglish(String descriptionInEnglish) {
        this.descriptionInEnglish = descriptionInEnglish;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="descriptionInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescriptionInEnglish() {
        return this.descriptionInEnglish;
    }

    @JsonProperty(value="descriptionInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptionInEnglish(String descriptionInEnglish) {
        this.descriptionInEnglish = descriptionInEnglish;
    }

    public PricedSupplierContractItem price(Moneys price) {
        this.price = price;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPrice(Moneys price) {
        this.price = price;
    }

    public PricedSupplierContractItem displayPrice(Moneys displayPrice) {
        this.displayPrice = displayPrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="displayPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getDisplayPrice() {
        return this.displayPrice;
    }

    @JsonProperty(value="displayPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayPrice(Moneys displayPrice) {
        this.displayPrice = displayPrice;
    }

    public PricedSupplierContractItem supplierPrice(Moneys supplierPrice) {
        this.supplierPrice = supplierPrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="supplierPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getSupplierPrice() {
        return this.supplierPrice;
    }

    @JsonProperty(value="supplierPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierPrice(Moneys supplierPrice) {
        this.supplierPrice = supplierPrice;
    }

    public PricedSupplierContractItem internalPrice(Moneys internalPrice) {
        this.internalPrice = internalPrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="internalPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getInternalPrice() {
        return this.internalPrice;
    }

    @JsonProperty(value="internalPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalPrice(Moneys internalPrice) {
        this.internalPrice = internalPrice;
    }

    public PricedSupplierContractItem itinerary(Itinerary itinerary) {
        this.itinerary = itinerary;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Itinerary getItinerary() {
        return this.itinerary;
    }

    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItinerary(Itinerary itinerary) {
        this.itinerary = itinerary;
    }

    public PricedSupplierContractItem pricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public PricedSupplierContractItem type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PricedSupplierContractItem perUseQuantity(Integer perUseQuantity) {
        this.perUseQuantity = perUseQuantity;
        return this;
    }

    @Nullable
    @JsonProperty(value="perUseQuantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPerUseQuantity() {
        return this.perUseQuantity;
    }

    @JsonProperty(value="perUseQuantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPerUseQuantity(Integer perUseQuantity) {
        this.perUseQuantity = perUseQuantity;
    }

    public PricedSupplierContractItem beneficiaryList(List<RawBeneficiary> beneficiaryList) {
        this.beneficiaryList = beneficiaryList;
        return this;
    }

    public PricedSupplierContractItem addBeneficiaryListItem(RawBeneficiary beneficiaryListItem) {
        this.beneficiaryList.add(beneficiaryListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="beneficiaryList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<RawBeneficiary> getBeneficiaryList() {
        return this.beneficiaryList;
    }

    @JsonProperty(value="beneficiaryList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBeneficiaryList(List<RawBeneficiary> beneficiaryList) {
        this.beneficiaryList = beneficiaryList;
    }

    public PricedSupplierContractItem payable(PayableEnum payable) {
        this.payable = payable;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="payable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PayableEnum getPayable() {
        return this.payable;
    }

    @JsonProperty(value="payable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPayable(PayableEnum payable) {
        this.payable = payable;
    }

    public PricedSupplierContractItem policy(SupplierContractItemPolicy policy) {
        this.policy = policy;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SupplierContractItemPolicy getPolicy() {
        return this.policy;
    }

    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolicy(SupplierContractItemPolicy policy) {
        this.policy = policy;
    }

    public PricedSupplierContractItem externalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public PricedSupplierContractItem dailyRateList(List<PricedDailyRate> dailyRateList) {
        this.dailyRateList = dailyRateList;
        return this;
    }

    public PricedSupplierContractItem addDailyRateListItem(PricedDailyRate dailyRateListItem) {
        if (this.dailyRateList == null) {
            this.dailyRateList = new ArrayList<PricedDailyRate>();
        }
        this.dailyRateList.add(dailyRateListItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="dailyRateList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PricedDailyRate> getDailyRateList() {
        return this.dailyRateList;
    }

    @JsonProperty(value="dailyRateList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDailyRateList(List<PricedDailyRate> dailyRateList) {
        this.dailyRateList = dailyRateList;
    }

    public PricedSupplierContractItem totalPrice(Moneys totalPrice) {
        this.totalPrice = totalPrice;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalPrice() {
        return this.totalPrice;
    }

    @JsonProperty(value="totalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalPrice(Moneys totalPrice) {
        this.totalPrice = totalPrice;
    }

    public PricedSupplierContractItem totalDisplayPrice(Moneys totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalDisplayPrice() {
        return this.totalDisplayPrice;
    }

    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalDisplayPrice(Moneys totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
    }

    public PricedSupplierContractItem totalSupplierPrice(Moneys totalSupplierPrice) {
        this.totalSupplierPrice = totalSupplierPrice;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalSupplierPrice() {
        return this.totalSupplierPrice;
    }

    @JsonProperty(value="totalSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSupplierPrice(Moneys totalSupplierPrice) {
        this.totalSupplierPrice = totalSupplierPrice;
    }

    public PricedSupplierContractItem totalInternalPrice(Moneys totalInternalPrice) {
        this.totalInternalPrice = totalInternalPrice;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalInternalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalInternalPrice() {
        return this.totalInternalPrice;
    }

    @JsonProperty(value="totalInternalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalInternalPrice(Moneys totalInternalPrice) {
        this.totalInternalPrice = totalInternalPrice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PricedSupplierContractItem pricedSupplierContractItem = (PricedSupplierContractItem)o;
        return Objects.equals(this.user, pricedSupplierContractItem.user) && Objects.equals(this.nameInEnglish, pricedSupplierContractItem.nameInEnglish) && Objects.equals(this.descriptionInEnglish, pricedSupplierContractItem.descriptionInEnglish) && Objects.equals(this.price, pricedSupplierContractItem.price) && Objects.equals(this.displayPrice, pricedSupplierContractItem.displayPrice) && Objects.equals(this.supplierPrice, pricedSupplierContractItem.supplierPrice) && Objects.equals(this.internalPrice, pricedSupplierContractItem.internalPrice) && Objects.equals(this.itinerary, pricedSupplierContractItem.itinerary) && Objects.equals((Object)this.pricingType, (Object)pricedSupplierContractItem.pricingType) && Objects.equals((Object)this.type, (Object)pricedSupplierContractItem.type) && Objects.equals(this.perUseQuantity, pricedSupplierContractItem.perUseQuantity) && Objects.equals(this.beneficiaryList, pricedSupplierContractItem.beneficiaryList) && Objects.equals((Object)this.payable, (Object)pricedSupplierContractItem.payable) && Objects.equals(this.policy, pricedSupplierContractItem.policy) && Objects.equals(this.externalIdentifier, pricedSupplierContractItem.externalIdentifier) && Objects.equals(this.dailyRateList, pricedSupplierContractItem.dailyRateList) && Objects.equals(this.totalPrice, pricedSupplierContractItem.totalPrice) && Objects.equals(this.totalDisplayPrice, pricedSupplierContractItem.totalDisplayPrice) && Objects.equals(this.totalSupplierPrice, pricedSupplierContractItem.totalSupplierPrice) && Objects.equals(this.totalInternalPrice, pricedSupplierContractItem.totalInternalPrice);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.user, this.nameInEnglish, this.descriptionInEnglish, this.price, this.displayPrice, this.supplierPrice, this.internalPrice, this.itinerary, this.pricingType, this.type, this.perUseQuantity, this.beneficiaryList, this.payable, this.policy, this.externalIdentifier, this.dailyRateList, this.totalPrice, this.totalDisplayPrice, this.totalSupplierPrice, this.totalInternalPrice});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PricedSupplierContractItem {\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    nameInEnglish: ").append(this.toIndentedString(this.nameInEnglish)).append("\n");
        sb.append("    descriptionInEnglish: ").append(this.toIndentedString(this.descriptionInEnglish)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    displayPrice: ").append(this.toIndentedString(this.displayPrice)).append("\n");
        sb.append("    supplierPrice: ").append(this.toIndentedString(this.supplierPrice)).append("\n");
        sb.append("    internalPrice: ").append(this.toIndentedString(this.internalPrice)).append("\n");
        sb.append("    itinerary: ").append(this.toIndentedString(this.itinerary)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    perUseQuantity: ").append(this.toIndentedString(this.perUseQuantity)).append("\n");
        sb.append("    beneficiaryList: ").append(this.toIndentedString(this.beneficiaryList)).append("\n");
        sb.append("    payable: ").append(this.toIndentedString((Object)this.payable)).append("\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("    externalIdentifier: ").append(this.toIndentedString(this.externalIdentifier)).append("\n");
        sb.append("    dailyRateList: ").append(this.toIndentedString(this.dailyRateList)).append("\n");
        sb.append("    totalPrice: ").append(this.toIndentedString(this.totalPrice)).append("\n");
        sb.append("    totalDisplayPrice: ").append(this.toIndentedString(this.totalDisplayPrice)).append("\n");
        sb.append("    totalSupplierPrice: ").append(this.toIndentedString(this.totalSupplierPrice)).append("\n");
        sb.append("    totalInternalPrice: ").append(this.toIndentedString(this.totalInternalPrice)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricingTypeEnum {
        STAY("PER_STAY"),
        DAY("PER_DAY"),
        NIGHT("PER_NIGHT"),
        USE("PER_USE"),
        HOUR("PER_HOUR"),
        PERSON("PER_PERSON"),
        PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
        PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
        ADULT("PER_ADULT"),
        ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
        ADULT_PER_HOUR("PER_ADULT_PER_HOUR"),
        CHILD("PER_CHILD"),
        CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
        CHILD_PER_HOUR("PER_CHILD_PER_HOUR");

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String value) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        LODGING("LODGING"),
        RAIL("RAIL"),
        AIR("AIR"),
        CAR("CAR"),
        CRUISE("CRUISE"),
        PACKAGE("PACKAGE"),
        ADD_ON("ADD_ON"),
        RENTAL("RENTAL"),
        EXPERIENCE("EXPERIENCE"),
        ANCILLARY_BOOKING("ANCILLARY_BOOKING"),
        ANCILLARY_FEE("ANCILLARY_FEE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PayableEnum {
        IMMEDIATE("IMMEDIATE"),
        ARRIVAL("ARRIVAL"),
        DEPARTURE("DEPARTURE"),
        AGENT("AGENT");

        private String value;

        private PayableEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PayableEnum fromValue(String value) {
            for (PayableEnum b : PayableEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

