/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 25.6.4
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Details of the payment. Payment details will be empty if account type is AGENT
 */
@JsonPropertyOrder({
  BookingContractPaymentDetails.JSON_PROPERTY_ACQUIRER_IDENTIFIER,
  BookingContractPaymentDetails.JSON_PROPERTY_VENDOR,
  BookingContractPaymentDetails.JSON_PROPERTY_TYPE,
  BookingContractPaymentDetails.JSON_PROPERTY_TRANSACTION_IDENTIFIER,
  BookingContractPaymentDetails.JSON_PROPERTY_AGENT_INVOICED_DATE,
  BookingContractPaymentDetails.JSON_PROPERTY_AGENT_INVOICE_IDENTIFIER,
  BookingContractPaymentDetails.JSON_PROPERTY_VENDOR_SPECIFIC
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-06-04T14:40:10.835175620+07:00[Asia/Bangkok]")
public class BookingContractPaymentDetails {
  public static final String JSON_PROPERTY_ACQUIRER_IDENTIFIER = "acquirerIdentifier";
  private String acquirerIdentifier;

  /**
   * Name of acquiring vendor
   */
  public enum VendorEnum {
    STRIPE("STRIPE"),
    
    YAPILY("YAPILY"),
    
    PAY_PAL("PAY_PAL"),
    
    NMI("NMI"),
    
    AGENT("AGENT");

    private String value;

    VendorEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static VendorEnum fromValue(String value) {
      for (VendorEnum b : VendorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_VENDOR = "vendor";
  private VendorEnum vendor;

  /**
   * Technology taking the charge
   */
  public enum TypeEnum {
    CREDIT_CARD("CREDIT_CARD"),
    
    BANK_TRANSFER("BANK_TRANSFER"),
    
    PAY_PAL("PAY_PAL"),
    
    CRYPTO("CRYPTO"),
    
    AGENT("AGENT"),
    
    CASH("CASH");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_TRANSACTION_IDENTIFIER = "transactionIdentifier";
  private String transactionIdentifier;

  public static final String JSON_PROPERTY_AGENT_INVOICED_DATE = "agentInvoicedDate";
  private java.time.LocalDateTime agentInvoicedDate;

  public static final String JSON_PROPERTY_AGENT_INVOICE_IDENTIFIER = "agentInvoiceIdentifier";
  private String agentInvoiceIdentifier;

  public static final String JSON_PROPERTY_VENDOR_SPECIFIC = "vendorSpecific";
  private Map<String, String> vendorSpecific = new HashMap<>();

  public BookingContractPaymentDetails() {
  }

  public BookingContractPaymentDetails acquirerIdentifier(String acquirerIdentifier) {
    
    this.acquirerIdentifier = acquirerIdentifier;
    return this;
  }

   /**
   * Unique acquiring identifier. Blank for agent payment
   * @return acquirerIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ACQUIRER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAcquirerIdentifier() {
    return acquirerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ACQUIRER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAcquirerIdentifier(String acquirerIdentifier) {
    this.acquirerIdentifier = acquirerIdentifier;
  }


  public BookingContractPaymentDetails vendor(VendorEnum vendor) {
    
    this.vendor = vendor;
    return this;
  }

   /**
   * Name of acquiring vendor
   * @return vendor
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_VENDOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public VendorEnum getVendor() {
    return vendor;
  }


  @JsonProperty(JSON_PROPERTY_VENDOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVendor(VendorEnum vendor) {
    this.vendor = vendor;
  }


  public BookingContractPaymentDetails type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Technology taking the charge
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public BookingContractPaymentDetails transactionIdentifier(String transactionIdentifier) {
    
    this.transactionIdentifier = transactionIdentifier;
    return this;
  }

   /**
   * Unique transaction id from the vendor upon a successful sale. Agent adds their transaction identifier.
   * @return transactionIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TRANSACTION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTransactionIdentifier() {
    return transactionIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_TRANSACTION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTransactionIdentifier(String transactionIdentifier) {
    this.transactionIdentifier = transactionIdentifier;
  }


  public BookingContractPaymentDetails agentInvoicedDate(java.time.LocalDateTime agentInvoicedDate) {
    
    this.agentInvoicedDate = agentInvoicedDate;
    return this;
  }

   /**
   * The date/time the invoice was generated
   * @return agentInvoicedDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_AGENT_INVOICED_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.time.LocalDateTime getAgentInvoicedDate() {
    return agentInvoicedDate;
  }


  @JsonProperty(JSON_PROPERTY_AGENT_INVOICED_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAgentInvoicedDate(java.time.LocalDateTime agentInvoicedDate) {
    this.agentInvoicedDate = agentInvoicedDate;
  }


  public BookingContractPaymentDetails agentInvoiceIdentifier(String agentInvoiceIdentifier) {
    
    this.agentInvoiceIdentifier = agentInvoiceIdentifier;
    return this;
  }

   /**
   * The specific invoice this booking was registered on
   * @return agentInvoiceIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_AGENT_INVOICE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAgentInvoiceIdentifier() {
    return agentInvoiceIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_AGENT_INVOICE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAgentInvoiceIdentifier(String agentInvoiceIdentifier) {
    this.agentInvoiceIdentifier = agentInvoiceIdentifier;
  }


  public BookingContractPaymentDetails vendorSpecific(Map<String, String> vendorSpecific) {
    
    this.vendorSpecific = vendorSpecific;
    return this;
  }

  public BookingContractPaymentDetails putVendorSpecificItem(String key, String vendorSpecificItem) {
    this.vendorSpecific.put(key, vendorSpecificItem);
    return this;
  }

   /**
   * Vendor specific values that are returned in a successful response
   * @return vendorSpecific
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_VENDOR_SPECIFIC)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Map<String, String> getVendorSpecific() {
    return vendorSpecific;
  }


  @JsonProperty(JSON_PROPERTY_VENDOR_SPECIFIC)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVendorSpecific(Map<String, String> vendorSpecific) {
    this.vendorSpecific = vendorSpecific;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingContractPaymentDetails bookingContractPaymentDetails = (BookingContractPaymentDetails) o;
    return Objects.equals(this.acquirerIdentifier, bookingContractPaymentDetails.acquirerIdentifier) &&
        Objects.equals(this.vendor, bookingContractPaymentDetails.vendor) &&
        Objects.equals(this.type, bookingContractPaymentDetails.type) &&
        Objects.equals(this.transactionIdentifier, bookingContractPaymentDetails.transactionIdentifier) &&
        Objects.equals(this.agentInvoicedDate, bookingContractPaymentDetails.agentInvoicedDate) &&
        Objects.equals(this.agentInvoiceIdentifier, bookingContractPaymentDetails.agentInvoiceIdentifier) &&
        Objects.equals(this.vendorSpecific, bookingContractPaymentDetails.vendorSpecific);
  }

  @Override
  public int hashCode() {
    return Objects.hash(acquirerIdentifier, vendor, type, transactionIdentifier, agentInvoicedDate, agentInvoiceIdentifier, vendorSpecific);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingContractPaymentDetails {\n");
    sb.append("    acquirerIdentifier: ").append(toIndentedString(acquirerIdentifier)).append("\n");
    sb.append("    vendor: ").append(toIndentedString(vendor)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    transactionIdentifier: ").append(toIndentedString(transactionIdentifier)).append("\n");
    sb.append("    agentInvoicedDate: ").append(toIndentedString(agentInvoicedDate)).append("\n");
    sb.append("    agentInvoiceIdentifier: ").append(toIndentedString(agentInvoiceIdentifier)).append("\n");
    sb.append("    vendorSpecific: ").append(toIndentedString(vendorSpecific)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

