/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.trippay.sdk.payment.model.GeoName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@JsonPropertyOrder(value={"address1", "address2", "state", "postalCode", "county", "city"})
public class Address {
    public static final String JSON_PROPERTY_ADDRESS1 = "address1";
    private String address1;
    public static final String JSON_PROPERTY_ADDRESS2 = "address2";
    private String address2;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;
    public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
    private String postalCode;
    public static final String JSON_PROPERTY_COUNTY = "county";
    private String county;
    public static final String JSON_PROPERTY_CITY = "city";
    private GeoName city;

    public Address address1(String address1) {
        this.address1 = address1;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="address1")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAddress1() {
        return this.address1;
    }

    @JsonProperty(value="address1")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    public Address address2(String address2) {
        this.address2 = address2;
        return this;
    }

    @Nullable
    @JsonProperty(value="address2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAddress2() {
        return this.address2;
    }

    @JsonProperty(value="address2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    public Address state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(String state) {
        this.state = state;
    }

    public Address postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPostalCode() {
        return this.postalCode;
    }

    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public Address county(String county) {
        this.county = county;
        return this;
    }

    @Nullable
    @JsonProperty(value="county")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCounty() {
        return this.county;
    }

    @JsonProperty(value="county")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCounty(String county) {
        this.county = county;
    }

    public Address city(GeoName city) {
        this.city = city;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GeoName getCity() {
        return this.city;
    }

    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCity(GeoName city) {
        this.city = city;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return Objects.equals(this.address1, address.address1) && Objects.equals(this.address2, address.address2) && Objects.equals(this.state, address.state) && Objects.equals(this.postalCode, address.postalCode) && Objects.equals(this.county, address.county) && Objects.equals(this.city, address.city);
    }

    public int hashCode() {
        return Objects.hash(this.address1, this.address2, this.state, this.postalCode, this.county, this.city);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Address {\n");
        sb.append("    address1: ").append(this.toIndentedString(this.address1)).append("\n");
        sb.append("    address2: ").append(this.toIndentedString(this.address2)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    county: ").append(this.toIndentedString(this.county)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

