/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.UpsertAddressRequest;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.time.LocalDate;
import java.util.Objects;

@JsonPropertyOrder(value={"address", "ownerType", "ownerTypeIdentifier", "dob", "disbursementType"})
public class VerifyAccountRequest {
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private UpsertAddressRequest address;
    public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
    private OwnerTypeEnum ownerType;
    public static final String JSON_PROPERTY_OWNER_TYPE_IDENTIFIER = "ownerTypeIdentifier";
    private String ownerTypeIdentifier;
    public static final String JSON_PROPERTY_DOB = "dob";
    private LocalDate dob;
    public static final String JSON_PROPERTY_DISBURSEMENT_TYPE = "disbursementType";
    private DisbursementTypeEnum disbursementType = DisbursementTypeEnum.VIRTUAL_CREDIT_CARD;

    public VerifyAccountRequest address(UpsertAddressRequest address) {
        this.address = address;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UpsertAddressRequest getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(UpsertAddressRequest address) {
        this.address = address;
    }

    public VerifyAccountRequest ownerType(OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
        return this;
    }

    @Nullable
    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OwnerTypeEnum getOwnerType() {
        return this.ownerType;
    }

    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerType(OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
    }

    public VerifyAccountRequest ownerTypeIdentifier(String ownerTypeIdentifier) {
        this.ownerTypeIdentifier = ownerTypeIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="ownerTypeIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOwnerTypeIdentifier() {
        return this.ownerTypeIdentifier;
    }

    @JsonProperty(value="ownerTypeIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerTypeIdentifier(String ownerTypeIdentifier) {
        this.ownerTypeIdentifier = ownerTypeIdentifier;
    }

    public VerifyAccountRequest dob(LocalDate dob) {
        this.dob = dob;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="dob")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getDob() {
        return this.dob;
    }

    @JsonProperty(value="dob")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDob(LocalDate dob) {
        this.dob = dob;
    }

    public VerifyAccountRequest disbursementType(DisbursementTypeEnum disbursementType) {
        this.disbursementType = disbursementType;
        return this;
    }

    @Nullable
    @JsonProperty(value="disbursementType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DisbursementTypeEnum getDisbursementType() {
        return this.disbursementType;
    }

    @JsonProperty(value="disbursementType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisbursementType(DisbursementTypeEnum disbursementType) {
        this.disbursementType = disbursementType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerifyAccountRequest verifyAccountRequest = (VerifyAccountRequest)o;
        return Objects.equals(this.address, verifyAccountRequest.address) && Objects.equals((Object)this.ownerType, (Object)verifyAccountRequest.ownerType) && Objects.equals(this.ownerTypeIdentifier, verifyAccountRequest.ownerTypeIdentifier) && Objects.equals(this.dob, verifyAccountRequest.dob) && Objects.equals((Object)this.disbursementType, (Object)verifyAccountRequest.disbursementType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.ownerType, this.ownerTypeIdentifier, this.dob, this.disbursementType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VerifyAccountRequest {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    ownerType: ").append(this.toIndentedString((Object)this.ownerType)).append("\n");
        sb.append("    ownerTypeIdentifier: ").append(this.toIndentedString(this.ownerTypeIdentifier)).append("\n");
        sb.append("    dob: ").append(this.toIndentedString(this.dob)).append("\n");
        sb.append("    disbursementType: ").append(this.toIndentedString((Object)this.disbursementType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DisbursementTypeEnum {
        VIRTUAL_CREDIT_CARD("VIRTUAL_CREDIT_CARD"),
        BANK_TRANSFER("BANK_TRANSFER");

        private String value;

        private DisbursementTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DisbursementTypeEnum fromValue(String value) {
            for (DisbursementTypeEnum b : DisbursementTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum OwnerTypeEnum {
        COMPANY("COMPANY"),
        INDIVIDUAL("INDIVIDUAL");

        private String value;

        private OwnerTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OwnerTypeEnum fromValue(String value) {
            for (OwnerTypeEnum b : OwnerTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

