/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 26.0.3
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.RawSupplierContract;
import io.trippay.sdk.payment.model.StripeCardholder;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CreateStripeSaleRequest
 */
@JsonPropertyOrder({
  CreateStripeSaleRequest.JSON_PROPERTY_ACQUIRER_IDENTIFIER,
  CreateStripeSaleRequest.JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER,
  CreateStripeSaleRequest.JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER_TYPE,
  CreateStripeSaleRequest.JSON_PROPERTY_DISPLAY_CURRENCY,
  CreateStripeSaleRequest.JSON_PROPERTY_SOURCE_URL,
  CreateStripeSaleRequest.JSON_PROPERTY_TRACE_ID,
  CreateStripeSaleRequest.JSON_PROPERTY_CONTRACT,
  CreateStripeSaleRequest.JSON_PROPERTY_CARDHOLDER,
  CreateStripeSaleRequest.JSON_PROPERTY_STRIPE_CUSTOMER_IDENTIFIER,
  CreateStripeSaleRequest.JSON_PROPERTY_STRIPE_PAYMENT_METHOD_IDENTIFIER,
  CreateStripeSaleRequest.JSON_PROPERTY_STRIPE_PAYMENT_INTENT_IDENTIFIER
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-06-10T15:06:09.660511147+07:00[Asia/Bangkok]")
public class CreateStripeSaleRequest {
  public static final String JSON_PROPERTY_ACQUIRER_IDENTIFIER = "acquirerIdentifier";
  private String acquirerIdentifier;

  public static final String JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER = "affiliateAccountIdentifier";
  private UUID affiliateAccountIdentifier;

  /**
   * Type of identifier this is
   */
  public enum AffiliateAccountIdentifierTypeEnum {
    INTERNAL("INTERNAL"),
    
    EXTERNAL("EXTERNAL");

    private String value;

    AffiliateAccountIdentifierTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AffiliateAccountIdentifierTypeEnum fromValue(String value) {
      for (AffiliateAccountIdentifierTypeEnum b : AffiliateAccountIdentifierTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER_TYPE = "affiliateAccountIdentifierType";
  private AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType;

  public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
  private String displayCurrency = "USD";

  public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
  private String sourceUrl;

  public static final String JSON_PROPERTY_TRACE_ID = "traceId";
  private String traceId;

  public static final String JSON_PROPERTY_CONTRACT = "contract";
  private RawSupplierContract contract;

  public static final String JSON_PROPERTY_CARDHOLDER = "cardholder";
  private StripeCardholder cardholder;

  public static final String JSON_PROPERTY_STRIPE_CUSTOMER_IDENTIFIER = "stripeCustomerIdentifier";
  private String stripeCustomerIdentifier;

  public static final String JSON_PROPERTY_STRIPE_PAYMENT_METHOD_IDENTIFIER = "stripePaymentMethodIdentifier";
  private String stripePaymentMethodIdentifier;

  public static final String JSON_PROPERTY_STRIPE_PAYMENT_INTENT_IDENTIFIER = "stripePaymentIntentIdentifier";
  private String stripePaymentIntentIdentifier;

  public CreateStripeSaleRequest() {
  }

  public CreateStripeSaleRequest acquirerIdentifier(String acquirerIdentifier) {
    
    this.acquirerIdentifier = acquirerIdentifier;
    return this;
  }

   /**
   * Stripe&#39;s acquirer coverage record
   * @return acquirerIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ACQUIRER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAcquirerIdentifier() {
    return acquirerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ACQUIRER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAcquirerIdentifier(String acquirerIdentifier) {
    this.acquirerIdentifier = acquirerIdentifier;
  }


  public CreateStripeSaleRequest affiliateAccountIdentifier(UUID affiliateAccountIdentifier) {
    
    this.affiliateAccountIdentifier = affiliateAccountIdentifier;
    return this;
  }

   /**
   * affiliate account making the request
   * @return affiliateAccountIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getAffiliateAccountIdentifier() {
    return affiliateAccountIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAffiliateAccountIdentifier(UUID affiliateAccountIdentifier) {
    this.affiliateAccountIdentifier = affiliateAccountIdentifier;
  }


  public CreateStripeSaleRequest affiliateAccountIdentifierType(AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType) {
    
    this.affiliateAccountIdentifierType = affiliateAccountIdentifierType;
    return this;
  }

   /**
   * Type of identifier this is
   * @return affiliateAccountIdentifierType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AffiliateAccountIdentifierTypeEnum getAffiliateAccountIdentifierType() {
    return affiliateAccountIdentifierType;
  }


  @JsonProperty(JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAffiliateAccountIdentifierType(AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType) {
    this.affiliateAccountIdentifierType = affiliateAccountIdentifierType;
  }


  public CreateStripeSaleRequest displayCurrency(String displayCurrency) {
    
    this.displayCurrency = displayCurrency;
    return this;
  }

   /**
   * The desired quote
   * @return displayCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDisplayCurrency() {
    return displayCurrency;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayCurrency(String displayCurrency) {
    this.displayCurrency = displayCurrency;
  }


  public CreateStripeSaleRequest sourceUrl(String sourceUrl) {
    
    this.sourceUrl = sourceUrl;
    return this;
  }

   /**
   * Where did the booking occur
   * @return sourceUrl
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSourceUrl() {
    return sourceUrl;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceUrl(String sourceUrl) {
    this.sourceUrl = sourceUrl;
  }


  public CreateStripeSaleRequest traceId(String traceId) {
    
    this.traceId = traceId;
    return this;
  }

   /**
   * Integrator can choose to include a unique identifier to help identify the collection of bookings
   * @return traceId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTraceId() {
    return traceId;
  }


  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTraceId(String traceId) {
    this.traceId = traceId;
  }


  public CreateStripeSaleRequest contract(RawSupplierContract contract) {
    
    this.contract = contract;
    return this;
  }

   /**
   * Get contract
   * @return contract
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CONTRACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RawSupplierContract getContract() {
    return contract;
  }


  @JsonProperty(JSON_PROPERTY_CONTRACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContract(RawSupplierContract contract) {
    this.contract = contract;
  }


  public CreateStripeSaleRequest cardholder(StripeCardholder cardholder) {
    
    this.cardholder = cardholder;
    return this;
  }

   /**
   * Get cardholder
   * @return cardholder
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CARDHOLDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StripeCardholder getCardholder() {
    return cardholder;
  }


  @JsonProperty(JSON_PROPERTY_CARDHOLDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCardholder(StripeCardholder cardholder) {
    this.cardholder = cardholder;
  }


  public CreateStripeSaleRequest stripeCustomerIdentifier(String stripeCustomerIdentifier) {
    
    this.stripeCustomerIdentifier = stripeCustomerIdentifier;
    return this;
  }

   /**
   * Vendor, like Stripe, will create a customer identifier to refer to this customer on their end.
   * @return stripeCustomerIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_STRIPE_CUSTOMER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getStripeCustomerIdentifier() {
    return stripeCustomerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_STRIPE_CUSTOMER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStripeCustomerIdentifier(String stripeCustomerIdentifier) {
    this.stripeCustomerIdentifier = stripeCustomerIdentifier;
  }


  public CreateStripeSaleRequest stripePaymentMethodIdentifier(String stripePaymentMethodIdentifier) {
    
    this.stripePaymentMethodIdentifier = stripePaymentMethodIdentifier;
    return this;
  }

   /**
   * Reference to payment method that was used to pay. Can be re-used to make an offline payment.
   * @return stripePaymentMethodIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_STRIPE_PAYMENT_METHOD_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getStripePaymentMethodIdentifier() {
    return stripePaymentMethodIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_STRIPE_PAYMENT_METHOD_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStripePaymentMethodIdentifier(String stripePaymentMethodIdentifier) {
    this.stripePaymentMethodIdentifier = stripePaymentMethodIdentifier;
  }


  public CreateStripeSaleRequest stripePaymentIntentIdentifier(String stripePaymentIntentIdentifier) {
    
    this.stripePaymentIntentIdentifier = stripePaymentIntentIdentifier;
    return this;
  }

   /**
   * Reference to payment intent that charged the card. If empty, we need to capture the charge. This occurs when existing customer is using an existing payment method.
   * @return stripePaymentIntentIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STRIPE_PAYMENT_INTENT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStripePaymentIntentIdentifier() {
    return stripePaymentIntentIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_STRIPE_PAYMENT_INTENT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStripePaymentIntentIdentifier(String stripePaymentIntentIdentifier) {
    this.stripePaymentIntentIdentifier = stripePaymentIntentIdentifier;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateStripeSaleRequest createStripeSaleRequest = (CreateStripeSaleRequest) o;
    return Objects.equals(this.acquirerIdentifier, createStripeSaleRequest.acquirerIdentifier) &&
        Objects.equals(this.affiliateAccountIdentifier, createStripeSaleRequest.affiliateAccountIdentifier) &&
        Objects.equals(this.affiliateAccountIdentifierType, createStripeSaleRequest.affiliateAccountIdentifierType) &&
        Objects.equals(this.displayCurrency, createStripeSaleRequest.displayCurrency) &&
        Objects.equals(this.sourceUrl, createStripeSaleRequest.sourceUrl) &&
        Objects.equals(this.traceId, createStripeSaleRequest.traceId) &&
        Objects.equals(this.contract, createStripeSaleRequest.contract) &&
        Objects.equals(this.cardholder, createStripeSaleRequest.cardholder) &&
        Objects.equals(this.stripeCustomerIdentifier, createStripeSaleRequest.stripeCustomerIdentifier) &&
        Objects.equals(this.stripePaymentMethodIdentifier, createStripeSaleRequest.stripePaymentMethodIdentifier) &&
        Objects.equals(this.stripePaymentIntentIdentifier, createStripeSaleRequest.stripePaymentIntentIdentifier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(acquirerIdentifier, affiliateAccountIdentifier, affiliateAccountIdentifierType, displayCurrency, sourceUrl, traceId, contract, cardholder, stripeCustomerIdentifier, stripePaymentMethodIdentifier, stripePaymentIntentIdentifier);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateStripeSaleRequest {\n");
    sb.append("    acquirerIdentifier: ").append(toIndentedString(acquirerIdentifier)).append("\n");
    sb.append("    affiliateAccountIdentifier: ").append(toIndentedString(affiliateAccountIdentifier)).append("\n");
    sb.append("    affiliateAccountIdentifierType: ").append(toIndentedString(affiliateAccountIdentifierType)).append("\n");
    sb.append("    displayCurrency: ").append(toIndentedString(displayCurrency)).append("\n");
    sb.append("    sourceUrl: ").append(toIndentedString(sourceUrl)).append("\n");
    sb.append("    traceId: ").append(toIndentedString(traceId)).append("\n");
    sb.append("    contract: ").append(toIndentedString(contract)).append("\n");
    sb.append("    cardholder: ").append(toIndentedString(cardholder)).append("\n");
    sb.append("    stripeCustomerIdentifier: ").append(toIndentedString(stripeCustomerIdentifier)).append("\n");
    sb.append("    stripePaymentMethodIdentifier: ").append(toIndentedString(stripePaymentMethodIdentifier)).append("\n");
    sb.append("    stripePaymentIntentIdentifier: ").append(toIndentedString(stripePaymentIntentIdentifier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

