/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.CardholderBilling;
import io.trippay.sdk.payment.model.CardholderCompany;
import io.trippay.sdk.payment.model.CardholderIndividual;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@JsonPropertyOrder(value={"identifier", "type", "name", "email", "phoneNumber", "billing", "company", "individual"})
public class Cardholder {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
    private String phoneNumber;
    public static final String JSON_PROPERTY_BILLING = "billing";
    private CardholderBilling billing;
    public static final String JSON_PROPERTY_COMPANY = "company";
    private CardholderCompany company;
    public static final String JSON_PROPERTY_INDIVIDUAL = "individual";
    private CardholderIndividual individual;

    public Cardholder identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Cardholder type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Cardholder name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public Cardholder email(String email) {
        this.email = email;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEmail(String email) {
        this.email = email;
    }

    public Cardholder phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public Cardholder billing(CardholderBilling billing) {
        this.billing = billing;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="billing")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CardholderBilling getBilling() {
        return this.billing;
    }

    @JsonProperty(value="billing")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBilling(CardholderBilling billing) {
        this.billing = billing;
    }

    public Cardholder company(CardholderCompany company) {
        this.company = company;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="company")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CardholderCompany getCompany() {
        return this.company;
    }

    @JsonProperty(value="company")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompany(CardholderCompany company) {
        this.company = company;
    }

    public Cardholder individual(CardholderIndividual individual) {
        this.individual = individual;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="individual")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CardholderIndividual getIndividual() {
        return this.individual;
    }

    @JsonProperty(value="individual")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIndividual(CardholderIndividual individual) {
        this.individual = individual;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cardholder cardholder = (Cardholder)o;
        return Objects.equals(this.identifier, cardholder.identifier) && Objects.equals((Object)this.type, (Object)cardholder.type) && Objects.equals(this.name, cardholder.name) && Objects.equals(this.email, cardholder.email) && Objects.equals(this.phoneNumber, cardholder.phoneNumber) && Objects.equals(this.billing, cardholder.billing) && Objects.equals(this.company, cardholder.company) && Objects.equals(this.individual, cardholder.individual);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.type, this.name, this.email, this.phoneNumber, this.billing, this.company, this.individual});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Cardholder {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    billing: ").append(this.toIndentedString(this.billing)).append("\n");
        sb.append("    company: ").append(this.toIndentedString(this.company)).append("\n");
        sb.append("    individual: ").append(this.toIndentedString(this.individual)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        COMPANY("COMPANY"),
        INDIVIDUAL("INDIVIDUAL");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

