/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.Cardholder;
import jakarta.annotation.Nonnull;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@JsonPropertyOrder(value={"identifier", "cardholder", "expirationMonth", "expirationYear", "last4", "brand", "status", "type", "cancellationReason"})
public class VirtualCreditCard {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_CARDHOLDER = "cardholder";
    private Cardholder cardholder;
    public static final String JSON_PROPERTY_EXPIRATION_MONTH = "expirationMonth";
    private Integer expirationMonth;
    public static final String JSON_PROPERTY_EXPIRATION_YEAR = "expirationYear";
    private Integer expirationYear;
    public static final String JSON_PROPERTY_LAST4 = "last4";
    private String last4;
    public static final String JSON_PROPERTY_BRAND = "brand";
    private String brand;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_CANCELLATION_REASON = "cancellationReason";
    private CancellationReasonEnum cancellationReason;

    public VirtualCreditCard identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public VirtualCreditCard cardholder(Cardholder cardholder) {
        this.cardholder = cardholder;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="cardholder")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Cardholder getCardholder() {
        return this.cardholder;
    }

    @JsonProperty(value="cardholder")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCardholder(Cardholder cardholder) {
        this.cardholder = cardholder;
    }

    public VirtualCreditCard expirationMonth(Integer expirationMonth) {
        this.expirationMonth = expirationMonth;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="expirationMonth")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getExpirationMonth() {
        return this.expirationMonth;
    }

    @JsonProperty(value="expirationMonth")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExpirationMonth(Integer expirationMonth) {
        this.expirationMonth = expirationMonth;
    }

    public VirtualCreditCard expirationYear(Integer expirationYear) {
        this.expirationYear = expirationYear;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=2023L)
    @JsonProperty(value="expirationYear")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=2023L) Integer getExpirationYear() {
        return this.expirationYear;
    }

    @JsonProperty(value="expirationYear")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExpirationYear(Integer expirationYear) {
        this.expirationYear = expirationYear;
    }

    public VirtualCreditCard last4(String last4) {
        this.last4 = last4;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="last4")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLast4() {
        return this.last4;
    }

    @JsonProperty(value="last4")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLast4(String last4) {
        this.last4 = last4;
    }

    public VirtualCreditCard brand(String brand) {
        this.brand = brand;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getBrand() {
        return this.brand;
    }

    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBrand(String brand) {
        this.brand = brand;
    }

    public VirtualCreditCard status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public VirtualCreditCard type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public VirtualCreditCard cancellationReason(CancellationReasonEnum cancellationReason) {
        this.cancellationReason = cancellationReason;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="cancellationReason")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CancellationReasonEnum getCancellationReason() {
        return this.cancellationReason;
    }

    @JsonProperty(value="cancellationReason")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCancellationReason(CancellationReasonEnum cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualCreditCard virtualCreditCard = (VirtualCreditCard)o;
        return Objects.equals(this.identifier, virtualCreditCard.identifier) && Objects.equals(this.cardholder, virtualCreditCard.cardholder) && Objects.equals(this.expirationMonth, virtualCreditCard.expirationMonth) && Objects.equals(this.expirationYear, virtualCreditCard.expirationYear) && Objects.equals(this.last4, virtualCreditCard.last4) && Objects.equals(this.brand, virtualCreditCard.brand) && Objects.equals((Object)this.status, (Object)virtualCreditCard.status) && Objects.equals((Object)this.type, (Object)virtualCreditCard.type) && Objects.equals((Object)this.cancellationReason, (Object)virtualCreditCard.cancellationReason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.cardholder, this.expirationMonth, this.expirationYear, this.last4, this.brand, this.status, this.type, this.cancellationReason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VirtualCreditCard {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    cardholder: ").append(this.toIndentedString(this.cardholder)).append("\n");
        sb.append("    expirationMonth: ").append(this.toIndentedString(this.expirationMonth)).append("\n");
        sb.append("    expirationYear: ").append(this.toIndentedString(this.expirationYear)).append("\n");
        sb.append("    last4: ").append(this.toIndentedString(this.last4)).append("\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    cancellationReason: ").append(this.toIndentedString((Object)this.cancellationReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        INACTIVE("INACTIVE"),
        CANCELLED("CANCELLED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        VIRTUAL("VIRTUAL"),
        PHYSICAL("PHYSICAL");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CancellationReasonEnum {
        LOST("LOST"),
        STOLEN("STOLEN"),
        DESIGN_REJECTED("DESIGN_REJECTED");

        private String value;

        private CancellationReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CancellationReasonEnum fromValue(String value) {
            for (CancellationReasonEnum b : CancellationReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

