/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 27.1.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.CustomMonetaryAmount;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CreatePaymentIntentRequest
 */
@JsonPropertyOrder({
  CreatePaymentIntentRequest.JSON_PROPERTY_ACQUIRER_IDENTIFIER,
  CreatePaymentIntentRequest.JSON_PROPERTY_CHARGE,
  CreatePaymentIntentRequest.JSON_PROPERTY_NAME,
  CreatePaymentIntentRequest.JSON_PROPERTY_DESCRIPTION,
  CreatePaymentIntentRequest.JSON_PROPERTY_CUSTOMER_IDENTIFIER
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-07-24T11:18:43.312245924+07:00[Asia/Bangkok]")
public class CreatePaymentIntentRequest {
  public static final String JSON_PROPERTY_ACQUIRER_IDENTIFIER = "acquirerIdentifier";
  private String acquirerIdentifier;

  public static final String JSON_PROPERTY_CHARGE = "charge";
  private CustomMonetaryAmount charge;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_CUSTOMER_IDENTIFIER = "customerIdentifier";
  private String customerIdentifier;

  public CreatePaymentIntentRequest() {
  }

  public CreatePaymentIntentRequest acquirerIdentifier(String acquirerIdentifier) {
    
    this.acquirerIdentifier = acquirerIdentifier;
    return this;
  }

   /**
   * Which coverage area is Stripe customer occurring in.
   * @return acquirerIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ACQUIRER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAcquirerIdentifier() {
    return acquirerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ACQUIRER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAcquirerIdentifier(String acquirerIdentifier) {
    this.acquirerIdentifier = acquirerIdentifier;
  }


  public CreatePaymentIntentRequest charge(CustomMonetaryAmount charge) {
    
    this.charge = charge;
    return this;
  }

   /**
   * Get charge
   * @return charge
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CHARGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getCharge() {
    return charge;
  }


  @JsonProperty(JSON_PROPERTY_CHARGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCharge(CustomMonetaryAmount charge) {
    this.charge = charge;
  }


  public CreatePaymentIntentRequest name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of hotel
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public CreatePaymentIntentRequest description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Details of the booking
   * @return description
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescription(String description) {
    this.description = description;
  }


  public CreatePaymentIntentRequest customerIdentifier(String customerIdentifier) {
    
    this.customerIdentifier = customerIdentifier;
    return this;
  }

   /**
   * Optional Stripe customer identifier.
   * @return customerIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CUSTOMER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCustomerIdentifier() {
    return customerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomerIdentifier(String customerIdentifier) {
    this.customerIdentifier = customerIdentifier;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreatePaymentIntentRequest createPaymentIntentRequest = (CreatePaymentIntentRequest) o;
    return Objects.equals(this.acquirerIdentifier, createPaymentIntentRequest.acquirerIdentifier) &&
        Objects.equals(this.charge, createPaymentIntentRequest.charge) &&
        Objects.equals(this.name, createPaymentIntentRequest.name) &&
        Objects.equals(this.description, createPaymentIntentRequest.description) &&
        Objects.equals(this.customerIdentifier, createPaymentIntentRequest.customerIdentifier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(acquirerIdentifier, charge, name, description, customerIdentifier);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreatePaymentIntentRequest {\n");
    sb.append("    acquirerIdentifier: ").append(toIndentedString(acquirerIdentifier)).append("\n");
    sb.append("    charge: ").append(toIndentedString(charge)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    customerIdentifier: ").append(toIndentedString(customerIdentifier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

