package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;

import io.trippay.sdk.payment.model.AggregateBookingContractCancellationState;
import io.trippay.sdk.payment.model.AggregateBookingContractCaptureCurrenciesByAccountResponse;
import io.trippay.sdk.payment.model.BeneficiaryAggregateData;
import io.trippay.sdk.payment.model.BookingContract;
import io.trippay.sdk.payment.model.BookingContractCancellableResponse;
import io.trippay.sdk.payment.model.CancelBookingContractRequest;
import io.trippay.sdk.payment.model.ImmediateRefundRequest;
import io.trippay.sdk.payment.model.PageBookingContract;
import io.trippay.sdk.payment.model.PriceBookingContractRequest;
import io.trippay.sdk.payment.model.PriceBookingContractResponse;
import io.trippay.sdk.payment.model.PriceSupplierContractWithAcquirerRequest;
import io.trippay.sdk.payment.model.PriceSupplierContractWithAcquirerResponse;
import io.trippay.sdk.payment.model.RefundRequest;
import io.trippay.sdk.payment.model.TotalAggregateFunds;
import io.trippay.sdk.payment.model.ValidateBookingContractRequest;
import io.trippay.sdk.payment.model.ValidateBookingContractResponse;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-07-31T08:59:00.067927603+07:00[Asia/Bangkok]")
public class ContractApi {
    private ApiClient apiClient;

    public ContractApi() {
        this(new ApiClient());
    }

    @Autowired
    public ContractApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Cancel booking
     * Cancels a booking contract. Based on the type of cancellation policy, will do a refund or partial refund to the payment method.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec cancelBookingContractRequestCreation(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = cancelBookingContractRequest;
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling cancelBookingContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancelBookingContractRequest' is set
        if (cancelBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancelBookingContractRequest' when calling cancelBookingContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return apiClient.invokeAPI("/api/contract/{identifier}/cancel", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Cancel booking
     * Cancels a booking contract. Based on the type of cancellation policy, will do a refund or partial refund to the payment method.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingContract> cancelBookingContract(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return cancelBookingContractRequestCreation(identifier, cancelBookingContractRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Cancel booking
     * Cancels a booking contract. Based on the type of cancellation policy, will do a refund or partial refund to the payment method.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingContract>> cancelBookingContractWithHttpInfo(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return cancelBookingContractRequestCreation(identifier, cancelBookingContractRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Cancel booking
     * Cancels a booking contract. Based on the type of cancellation policy, will do a refund or partial refund to the payment method.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec cancelBookingContractWithResponseSpec(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        return cancelBookingContractRequestCreation(identifier, cancelBookingContractRequest, winkVersion);
    }
    /**
     * Cancel group bookings
     * Cancels a group booking contract. All bookings under the same traceId.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec cancelGroupBookingContractRequestCreation(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = cancelBookingContractRequest;
        // verify the required parameter 'traceId' is set
        if (traceId == null) {
            throw new WebClientResponseException("Missing the required parameter 'traceId' when calling cancelGroupBookingContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancelBookingContractRequest' is set
        if (cancelBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancelBookingContractRequest' when calling cancelGroupBookingContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("traceId", traceId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return apiClient.invokeAPI("/api/contract/list/{traceId}/cancel", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Cancel group bookings
     * Cancels a group booking contract. All bookings under the same traceId.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BookingContract> cancelGroupBookingContract(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return cancelGroupBookingContractRequestCreation(traceId, cancelBookingContractRequest, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Cancel group bookings
     * Cancels a group booking contract. All bookings under the same traceId.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;BookingContract&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<BookingContract>>> cancelGroupBookingContractWithHttpInfo(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return cancelGroupBookingContractRequestCreation(traceId, cancelBookingContractRequest, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Cancel group bookings
     * Cancels a group booking contract. All bookings under the same traceId.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec cancelGroupBookingContractWithResponseSpec(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        return cancelGroupBookingContractRequestCreation(traceId, cancelBookingContractRequest, winkVersion);
    }
    /**
     * Immediate group refund
     * In the event that a booking is not possible on the partner site due to lack of availability, or similar. This endpoint offers a 3-minute window to let that partner refund the traveler 100% of her funds.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param immediateRefundRequest Accompanying payload that described the optional reason for using this endpoint.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec immediateGroupRefundRequestCreation(String traceId, ImmediateRefundRequest immediateRefundRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = immediateRefundRequest;
        // verify the required parameter 'traceId' is set
        if (traceId == null) {
            throw new WebClientResponseException("Missing the required parameter 'traceId' when calling immediateGroupRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'immediateRefundRequest' is set
        if (immediateRefundRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'immediateRefundRequest' when calling immediateGroupRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("traceId", traceId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return apiClient.invokeAPI("/api/contract/list/{traceId}/immediate-refund", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Immediate group refund
     * In the event that a booking is not possible on the partner site due to lack of availability, or similar. This endpoint offers a 3-minute window to let that partner refund the traveler 100% of her funds.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param immediateRefundRequest Accompanying payload that described the optional reason for using this endpoint.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BookingContract> immediateGroupRefund(String traceId, ImmediateRefundRequest immediateRefundRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return immediateGroupRefundRequestCreation(traceId, immediateRefundRequest, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Immediate group refund
     * In the event that a booking is not possible on the partner site due to lack of availability, or similar. This endpoint offers a 3-minute window to let that partner refund the traveler 100% of her funds.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param immediateRefundRequest Accompanying payload that described the optional reason for using this endpoint.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;BookingContract&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<BookingContract>>> immediateGroupRefundWithHttpInfo(String traceId, ImmediateRefundRequest immediateRefundRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return immediateGroupRefundRequestCreation(traceId, immediateRefundRequest, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Immediate group refund
     * In the event that a booking is not possible on the partner site due to lack of availability, or similar. This endpoint offers a 3-minute window to let that partner refund the traveler 100% of her funds.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param immediateRefundRequest Accompanying payload that described the optional reason for using this endpoint.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec immediateGroupRefundWithResponseSpec(String traceId, ImmediateRefundRequest immediateRefundRequest, String winkVersion) throws WebClientResponseException {
        return immediateGroupRefundRequestCreation(traceId, immediateRefundRequest, winkVersion);
    }
    /**
     * Immediate refund
     * In the event that a booking is not possible on the partner site due to lack of availability, or similar. This endpoint offers a 3-minute window to let that partner refund the traveler 100% of her funds.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param immediateRefundRequest Accompanying payload that described the optional reason for using this endpoint.
     * @param winkVersion The winkVersion parameter
     * @return BookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec immediateRefundRequestCreation(String identifier, ImmediateRefundRequest immediateRefundRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = immediateRefundRequest;
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling immediateRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'immediateRefundRequest' is set
        if (immediateRefundRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'immediateRefundRequest' when calling immediateRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return apiClient.invokeAPI("/api/contract/{identifier}/immediate-refund", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Immediate refund
     * In the event that a booking is not possible on the partner site due to lack of availability, or similar. This endpoint offers a 3-minute window to let that partner refund the traveler 100% of her funds.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param immediateRefundRequest Accompanying payload that described the optional reason for using this endpoint.
     * @param winkVersion The winkVersion parameter
     * @return BookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingContract> immediateRefund(String identifier, ImmediateRefundRequest immediateRefundRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return immediateRefundRequestCreation(identifier, immediateRefundRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Immediate refund
     * In the event that a booking is not possible on the partner site due to lack of availability, or similar. This endpoint offers a 3-minute window to let that partner refund the traveler 100% of her funds.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param immediateRefundRequest Accompanying payload that described the optional reason for using this endpoint.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingContract>> immediateRefundWithHttpInfo(String identifier, ImmediateRefundRequest immediateRefundRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return immediateRefundRequestCreation(identifier, immediateRefundRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Immediate refund
     * In the event that a booking is not possible on the partner site due to lack of availability, or similar. This endpoint offers a 3-minute window to let that partner refund the traveler 100% of her funds.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param immediateRefundRequest Accompanying payload that described the optional reason for using this endpoint.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec immediateRefundWithResponseSpec(String identifier, ImmediateRefundRequest immediateRefundRequest, String winkVersion) throws WebClientResponseException {
        return immediateRefundRequestCreation(identifier, immediateRefundRequest, winkVersion);
    }
    /**
     * Contract cancellable
     * Returns whether a booking can be cancelled or not and any rules associated with cancelling.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingContractCancellableResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec isContractCancellableRequestCreation(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = cancelBookingContractRequest;
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling isContractCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancelBookingContractRequest' is set
        if (cancelBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancelBookingContractRequest' when calling isContractCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>() {};
        return apiClient.invokeAPI("/api/contract/{identifier}/cancellable", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Contract cancellable
     * Returns whether a booking can be cancelled or not and any rules associated with cancelling.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingContractCancellableResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingContractCancellableResponse> isContractCancellable(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>() {};
        return isContractCancellableRequestCreation(identifier, cancelBookingContractRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Contract cancellable
     * Returns whether a booking can be cancelled or not and any rules associated with cancelling.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BookingContractCancellableResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingContractCancellableResponse>> isContractCancellableWithHttpInfo(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>() {};
        return isContractCancellableRequestCreation(identifier, cancelBookingContractRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Contract cancellable
     * Returns whether a booking can be cancelled or not and any rules associated with cancelling.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec isContractCancellableWithResponseSpec(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        return isContractCancellableRequestCreation(identifier, cancelBookingContractRequest, winkVersion);
    }
    /**
     * Group contract cancellable
     * Returns whether a booking can be cancelled or not and any rules associated with cancelling.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingContractCancellableResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec isGroupContractCancellableRequestCreation(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = cancelBookingContractRequest;
        // verify the required parameter 'traceId' is set
        if (traceId == null) {
            throw new WebClientResponseException("Missing the required parameter 'traceId' when calling isGroupContractCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancelBookingContractRequest' is set
        if (cancelBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancelBookingContractRequest' when calling isGroupContractCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("traceId", traceId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>() {};
        return apiClient.invokeAPI("/api/contract/list/{traceId}/cancellable", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Group contract cancellable
     * Returns whether a booking can be cancelled or not and any rules associated with cancelling.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingContractCancellableResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BookingContractCancellableResponse> isGroupContractCancellable(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>() {};
        return isGroupContractCancellableRequestCreation(traceId, cancelBookingContractRequest, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Group contract cancellable
     * Returns whether a booking can be cancelled or not and any rules associated with cancelling.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;BookingContractCancellableResponse&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<BookingContractCancellableResponse>>> isGroupContractCancellableWithHttpInfo(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>() {};
        return isGroupContractCancellableRequestCreation(traceId, cancelBookingContractRequest, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Group contract cancellable
     * Returns whether a booking can be cancelled or not and any rules associated with cancelling.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec isGroupContractCancellableWithResponseSpec(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        return isGroupContractCancellableRequestCreation(traceId, cancelBookingContractRequest, winkVersion);
    }
    /**
     * Price acquirer contract
     * Displays booking contract in requested display quote as well as the selected acquirer&#39;s currency
     * <p><b>200</b> - OK
     * @param priceSupplierContractWithAcquirerRequest The priceSupplierContractWithAcquirerRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return PriceSupplierContractWithAcquirerResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec priceRequestCreation(PriceSupplierContractWithAcquirerRequest priceSupplierContractWithAcquirerRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = priceSupplierContractWithAcquirerRequest;
        // verify the required parameter 'priceSupplierContractWithAcquirerRequest' is set
        if (priceSupplierContractWithAcquirerRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'priceSupplierContractWithAcquirerRequest' when calling price", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PriceSupplierContractWithAcquirerResponse> localVarReturnType = new ParameterizedTypeReference<PriceSupplierContractWithAcquirerResponse>() {};
        return apiClient.invokeAPI("/contract/price/acquirer", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Price acquirer contract
     * Displays booking contract in requested display quote as well as the selected acquirer&#39;s currency
     * <p><b>200</b> - OK
     * @param priceSupplierContractWithAcquirerRequest The priceSupplierContractWithAcquirerRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return PriceSupplierContractWithAcquirerResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PriceSupplierContractWithAcquirerResponse> price(PriceSupplierContractWithAcquirerRequest priceSupplierContractWithAcquirerRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PriceSupplierContractWithAcquirerResponse> localVarReturnType = new ParameterizedTypeReference<PriceSupplierContractWithAcquirerResponse>() {};
        return priceRequestCreation(priceSupplierContractWithAcquirerRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Price acquirer contract
     * Displays booking contract in requested display quote as well as the selected acquirer&#39;s currency
     * <p><b>200</b> - OK
     * @param priceSupplierContractWithAcquirerRequest The priceSupplierContractWithAcquirerRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PriceSupplierContractWithAcquirerResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PriceSupplierContractWithAcquirerResponse>> priceWithHttpInfo(PriceSupplierContractWithAcquirerRequest priceSupplierContractWithAcquirerRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PriceSupplierContractWithAcquirerResponse> localVarReturnType = new ParameterizedTypeReference<PriceSupplierContractWithAcquirerResponse>() {};
        return priceRequestCreation(priceSupplierContractWithAcquirerRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Price acquirer contract
     * Displays booking contract in requested display quote as well as the selected acquirer&#39;s currency
     * <p><b>200</b> - OK
     * @param priceSupplierContractWithAcquirerRequest The priceSupplierContractWithAcquirerRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec priceWithResponseSpec(PriceSupplierContractWithAcquirerRequest priceSupplierContractWithAcquirerRequest, String winkVersion) throws WebClientResponseException {
        return priceRequestCreation(priceSupplierContractWithAcquirerRequest, winkVersion);
    }
    /**
     * Price contract
     * Displays booking contract in requested display quote
     * <p><b>200</b> - OK
     * @param priceBookingContractRequest The priceBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return PriceBookingContractResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec price1RequestCreation(PriceBookingContractRequest priceBookingContractRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = priceBookingContractRequest;
        // verify the required parameter 'priceBookingContractRequest' is set
        if (priceBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'priceBookingContractRequest' when calling price1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PriceBookingContractResponse> localVarReturnType = new ParameterizedTypeReference<PriceBookingContractResponse>() {};
        return apiClient.invokeAPI("/contract/price", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Price contract
     * Displays booking contract in requested display quote
     * <p><b>200</b> - OK
     * @param priceBookingContractRequest The priceBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return PriceBookingContractResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PriceBookingContractResponse> price1(PriceBookingContractRequest priceBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PriceBookingContractResponse> localVarReturnType = new ParameterizedTypeReference<PriceBookingContractResponse>() {};
        return price1RequestCreation(priceBookingContractRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Price contract
     * Displays booking contract in requested display quote
     * <p><b>200</b> - OK
     * @param priceBookingContractRequest The priceBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PriceBookingContractResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PriceBookingContractResponse>> price1WithHttpInfo(PriceBookingContractRequest priceBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PriceBookingContractResponse> localVarReturnType = new ParameterizedTypeReference<PriceBookingContractResponse>() {};
        return price1RequestCreation(priceBookingContractRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Price contract
     * Displays booking contract in requested display quote
     * <p><b>200</b> - OK
     * @param priceBookingContractRequest The priceBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec price1WithResponseSpec(PriceBookingContractRequest priceBookingContractRequest, String winkVersion) throws WebClientResponseException {
        return price1RequestCreation(priceBookingContractRequest, winkVersion);
    }
    /**
     * Request refund
     * Requests a refund for a booking contract. Creates a refund request record that needs to be approved by a payment admin.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param refundRequest The refundRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec requestRefundRequestCreation(String identifier, RefundRequest refundRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = refundRequest;
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling requestRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'refundRequest' is set
        if (refundRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'refundRequest' when calling requestRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return apiClient.invokeAPI("/api/contract/{identifier}/request-refund", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Request refund
     * Requests a refund for a booking contract. Creates a refund request record that needs to be approved by a payment admin.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param refundRequest The refundRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingContract> requestRefund(String identifier, RefundRequest refundRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return requestRefundRequestCreation(identifier, refundRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Request refund
     * Requests a refund for a booking contract. Creates a refund request record that needs to be approved by a payment admin.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param refundRequest The refundRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingContract>> requestRefundWithHttpInfo(String identifier, RefundRequest refundRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return requestRefundRequestCreation(identifier, refundRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Request refund
     * Requests a refund for a booking contract. Creates a refund request record that needs to be approved by a payment admin.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param refundRequest The refundRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec requestRefundWithResponseSpec(String identifier, RefundRequest refundRequest, String winkVersion) throws WebClientResponseException {
        return requestRefundRequestCreation(identifier, refundRequest, winkVersion);
    }
    /**
     * Retrieve aggregate beneficiary data
     * Returns aggregate contract data this account identifier has participated in.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param type The type parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BeneficiaryAggregateData&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAggregateBookingContractDataRequestCreation(String accountIdentifier, String type, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling showAggregateBookingContractData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "type", type));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BeneficiaryAggregateData> localVarReturnType = new ParameterizedTypeReference<BeneficiaryAggregateData>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/contract/aggregate/beneficiary", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve aggregate beneficiary data
     * Returns aggregate contract data this account identifier has participated in.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param type The type parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BeneficiaryAggregateData&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BeneficiaryAggregateData> showAggregateBookingContractData(String accountIdentifier, String type, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BeneficiaryAggregateData> localVarReturnType = new ParameterizedTypeReference<BeneficiaryAggregateData>() {};
        return showAggregateBookingContractDataRequestCreation(accountIdentifier, type, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Retrieve aggregate beneficiary data
     * Returns aggregate contract data this account identifier has participated in.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param type The type parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;BeneficiaryAggregateData&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<BeneficiaryAggregateData>>> showAggregateBookingContractDataWithHttpInfo(String accountIdentifier, String type, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BeneficiaryAggregateData> localVarReturnType = new ParameterizedTypeReference<BeneficiaryAggregateData>() {};
        return showAggregateBookingContractDataRequestCreation(accountIdentifier, type, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Retrieve aggregate beneficiary data
     * Returns aggregate contract data this account identifier has participated in.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param type The type parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAggregateBookingContractDataWithResponseSpec(String accountIdentifier, String type, String winkVersion) throws WebClientResponseException {
        return showAggregateBookingContractDataRequestCreation(accountIdentifier, type, winkVersion);
    }
    /**
     * Retrieve aggregate cancellation data
     * Returns aggregate cancellation data this account identifier has participated in.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;AggregateBookingContractCancellationState&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAggregateCancellationDataRequestCreation(String accountIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling showAggregateCancellationData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AggregateBookingContractCancellationState> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCancellationState>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/contract/aggregate/cancellation", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve aggregate cancellation data
     * Returns aggregate cancellation data this account identifier has participated in.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;AggregateBookingContractCancellationState&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<AggregateBookingContractCancellationState> showAggregateCancellationData(String accountIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AggregateBookingContractCancellationState> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCancellationState>() {};
        return showAggregateCancellationDataRequestCreation(accountIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Retrieve aggregate cancellation data
     * Returns aggregate cancellation data this account identifier has participated in.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;AggregateBookingContractCancellationState&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<AggregateBookingContractCancellationState>>> showAggregateCancellationDataWithHttpInfo(String accountIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AggregateBookingContractCancellationState> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCancellationState>() {};
        return showAggregateCancellationDataRequestCreation(accountIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Retrieve aggregate cancellation data
     * Returns aggregate cancellation data this account identifier has participated in.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAggregateCancellationDataWithResponseSpec(String accountIdentifier, String winkVersion) throws WebClientResponseException {
        return showAggregateCancellationDataRequestCreation(accountIdentifier, winkVersion);
    }
    /**
     * Retrieve capture currencies
     * Returns a list of capture currencies and amounts for the account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @return AggregateBookingContractCaptureCurrenciesByAccountResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCaptureCurrenciesRequestCreation(String accountIdentifier, String state, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling showCaptureCurrencies", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "state", state));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AggregateBookingContractCaptureCurrenciesByAccountResponse> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCaptureCurrenciesByAccountResponse>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/contract/capture", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve capture currencies
     * Returns a list of capture currencies and amounts for the account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @return AggregateBookingContractCaptureCurrenciesByAccountResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AggregateBookingContractCaptureCurrenciesByAccountResponse> showCaptureCurrencies(String accountIdentifier, String state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AggregateBookingContractCaptureCurrenciesByAccountResponse> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCaptureCurrenciesByAccountResponse>() {};
        return showCaptureCurrenciesRequestCreation(accountIdentifier, state, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Retrieve capture currencies
     * Returns a list of capture currencies and amounts for the account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;AggregateBookingContractCaptureCurrenciesByAccountResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AggregateBookingContractCaptureCurrenciesByAccountResponse>> showCaptureCurrenciesWithHttpInfo(String accountIdentifier, String state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AggregateBookingContractCaptureCurrenciesByAccountResponse> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCaptureCurrenciesByAccountResponse>() {};
        return showCaptureCurrenciesRequestCreation(accountIdentifier, state, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Retrieve capture currencies
     * Returns a list of capture currencies and amounts for the account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCaptureCurrenciesWithResponseSpec(String accountIdentifier, String state, String winkVersion) throws WebClientResponseException {
        return showCaptureCurrenciesRequestCreation(accountIdentifier, state, winkVersion);
    }
    /**
     * Retrieve single contract
     * Returns a booking contract by its unique identifier.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param winkVersion The winkVersion parameter
     * @return BookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showContractRequestCreation(String identifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling showContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return apiClient.invokeAPI("/api/contract/{identifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve single contract
     * Returns a booking contract by its unique identifier.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param winkVersion The winkVersion parameter
     * @return BookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingContract> showContract(String identifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return showContractRequestCreation(identifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Retrieve single contract
     * Returns a booking contract by its unique identifier.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingContract>> showContractWithHttpInfo(String identifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return showContractRequestCreation(identifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Retrieve single contract
     * Returns a booking contract by its unique identifier.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showContractWithResponseSpec(String identifier, String winkVersion) throws WebClientResponseException {
        return showContractRequestCreation(identifier, winkVersion);
    }
    /**
     * Retrieve contract funds
     * Returns booking contract funds for account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The account owner
     * @param state The optional state to want to receive funds for
     * @param accountFundsOnly Whether to only returns funds for that account identifier or total funds that account identifier was part of. (defaults to false).
     * @param winkVersion The winkVersion parameter
     * @return TotalAggregateFunds
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showContractFundsRequestCreation(String accountIdentifier, String state, Boolean accountFundsOnly, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling showContractFunds", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "state", state));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "accountFundsOnly", accountFundsOnly));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<TotalAggregateFunds> localVarReturnType = new ParameterizedTypeReference<TotalAggregateFunds>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/contract/funds", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve contract funds
     * Returns booking contract funds for account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The account owner
     * @param state The optional state to want to receive funds for
     * @param accountFundsOnly Whether to only returns funds for that account identifier or total funds that account identifier was part of. (defaults to false).
     * @param winkVersion The winkVersion parameter
     * @return TotalAggregateFunds
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<TotalAggregateFunds> showContractFunds(String accountIdentifier, String state, Boolean accountFundsOnly, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<TotalAggregateFunds> localVarReturnType = new ParameterizedTypeReference<TotalAggregateFunds>() {};
        return showContractFundsRequestCreation(accountIdentifier, state, accountFundsOnly, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Retrieve contract funds
     * Returns booking contract funds for account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The account owner
     * @param state The optional state to want to receive funds for
     * @param accountFundsOnly Whether to only returns funds for that account identifier or total funds that account identifier was part of. (defaults to false).
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;TotalAggregateFunds&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<TotalAggregateFunds>> showContractFundsWithHttpInfo(String accountIdentifier, String state, Boolean accountFundsOnly, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<TotalAggregateFunds> localVarReturnType = new ParameterizedTypeReference<TotalAggregateFunds>() {};
        return showContractFundsRequestCreation(accountIdentifier, state, accountFundsOnly, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Retrieve contract funds
     * Returns booking contract funds for account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The account owner
     * @param state The optional state to want to receive funds for
     * @param accountFundsOnly Whether to only returns funds for that account identifier or total funds that account identifier was part of. (defaults to false).
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showContractFundsWithResponseSpec(String accountIdentifier, String state, Boolean accountFundsOnly, String winkVersion) throws WebClientResponseException {
        return showContractFundsRequestCreation(accountIdentifier, state, accountFundsOnly, winkVersion);
    }
    /**
     * Retrieve contract grid
     * Returns booking contracts for account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The account owner
     * @param state The optional state to want to receive funds for
     * @param page Pagination page number to go to
     * @param size Pagination number of elements to return
     * @param winkVersion The winkVersion parameter
     * @return PageBookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showContractGridRequestCreation(String accountIdentifier, String state, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling showContractGrid", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "state", state));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "size", size));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageBookingContract> localVarReturnType = new ParameterizedTypeReference<PageBookingContract>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/contract/grid", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve contract grid
     * Returns booking contracts for account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The account owner
     * @param state The optional state to want to receive funds for
     * @param page Pagination page number to go to
     * @param size Pagination number of elements to return
     * @param winkVersion The winkVersion parameter
     * @return PageBookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageBookingContract> showContractGrid(String accountIdentifier, String state, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingContract> localVarReturnType = new ParameterizedTypeReference<PageBookingContract>() {};
        return showContractGridRequestCreation(accountIdentifier, state, page, size, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Retrieve contract grid
     * Returns booking contracts for account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The account owner
     * @param state The optional state to want to receive funds for
     * @param page Pagination page number to go to
     * @param size Pagination number of elements to return
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageBookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageBookingContract>> showContractGridWithHttpInfo(String accountIdentifier, String state, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingContract> localVarReturnType = new ParameterizedTypeReference<PageBookingContract>() {};
        return showContractGridRequestCreation(accountIdentifier, state, page, size, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Retrieve contract grid
     * Returns booking contracts for account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The account owner
     * @param state The optional state to want to receive funds for
     * @param page Pagination page number to go to
     * @param size Pagination number of elements to return
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showContractGridWithResponseSpec(String accountIdentifier, String state, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        return showContractGridRequestCreation(accountIdentifier, state, page, size, winkVersion);
    }
    /**
     * Retrieve multiple contracts
     * Returns booking contracts matching traceId.
     * <p><b>200</b> - OK
     * @param traceId Trace identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showContractsRequestCreation(String traceId, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'traceId' is set
        if (traceId == null) {
            throw new WebClientResponseException("Missing the required parameter 'traceId' when calling showContracts", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("traceId", traceId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return apiClient.invokeAPI("/api/contract/list/{traceId}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve multiple contracts
     * Returns booking contracts matching traceId.
     * <p><b>200</b> - OK
     * @param traceId Trace identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BookingContract> showContracts(String traceId, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return showContractsRequestCreation(traceId, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Retrieve multiple contracts
     * Returns booking contracts matching traceId.
     * <p><b>200</b> - OK
     * @param traceId Trace identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;BookingContract&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<BookingContract>>> showContractsWithHttpInfo(String traceId, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return showContractsRequestCreation(traceId, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Retrieve multiple contracts
     * Returns booking contracts matching traceId.
     * <p><b>200</b> - OK
     * @param traceId Trace identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showContractsWithResponseSpec(String traceId, String winkVersion) throws WebClientResponseException {
        return showContractsRequestCreation(traceId, winkVersion);
    }
    /**
     * Validate contract
     * Validates an incoming raw booking contract request for syntax, price and more.
     * <p><b>200</b> - OK
     * @param validateBookingContractRequest The validateBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ValidateBookingContractResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec validateRequestCreation(ValidateBookingContractRequest validateBookingContractRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = validateBookingContractRequest;
        // verify the required parameter 'validateBookingContractRequest' is set
        if (validateBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'validateBookingContractRequest' when calling validate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ValidateBookingContractResponse> localVarReturnType = new ParameterizedTypeReference<ValidateBookingContractResponse>() {};
        return apiClient.invokeAPI("/contract/validate", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Validate contract
     * Validates an incoming raw booking contract request for syntax, price and more.
     * <p><b>200</b> - OK
     * @param validateBookingContractRequest The validateBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ValidateBookingContractResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ValidateBookingContractResponse> validate(ValidateBookingContractRequest validateBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ValidateBookingContractResponse> localVarReturnType = new ParameterizedTypeReference<ValidateBookingContractResponse>() {};
        return validateRequestCreation(validateBookingContractRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Validate contract
     * Validates an incoming raw booking contract request for syntax, price and more.
     * <p><b>200</b> - OK
     * @param validateBookingContractRequest The validateBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;ValidateBookingContractResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ValidateBookingContractResponse>> validateWithHttpInfo(ValidateBookingContractRequest validateBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ValidateBookingContractResponse> localVarReturnType = new ParameterizedTypeReference<ValidateBookingContractResponse>() {};
        return validateRequestCreation(validateBookingContractRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Validate contract
     * Validates an incoming raw booking contract request for syntax, price and more.
     * <p><b>200</b> - OK
     * @param validateBookingContractRequest The validateBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec validateWithResponseSpec(ValidateBookingContractRequest validateBookingContractRequest, String winkVersion) throws WebClientResponseException {
        return validateRequestCreation(validateBookingContractRequest, winkVersion);
    }
}
