/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.UpsertAddressRequest;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;

@JsonPropertyOrder(value={"name", "legalName", "description", "url", "accountEmail", "currencyCode", "address", "preferredDisbursementType"})
public class UpdateAccountRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_LEGAL_NAME = "legalName";
    private String legalName;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    public static final String JSON_PROPERTY_ACCOUNT_EMAIL = "accountEmail";
    private String accountEmail;
    public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
    private String currencyCode;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private UpsertAddressRequest address;
    public static final String JSON_PROPERTY_PREFERRED_DISBURSEMENT_TYPE = "preferredDisbursementType";
    private PreferredDisbursementTypeEnum preferredDisbursementType = PreferredDisbursementTypeEnum.BANK_TRANSFER;

    public UpdateAccountRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public UpdateAccountRequest legalName(String legalName) {
        this.legalName = legalName;
        return this;
    }

    @Nullable
    @JsonProperty(value="legalName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalName() {
        return this.legalName;
    }

    @JsonProperty(value="legalName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public UpdateAccountRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(String description) {
        this.description = description;
    }

    public UpdateAccountRequest url(String url) {
        this.url = url;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUrl(String url) {
        this.url = url;
    }

    public UpdateAccountRequest accountEmail(String accountEmail) {
        this.accountEmail = accountEmail;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="accountEmail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountEmail() {
        return this.accountEmail;
    }

    @JsonProperty(value="accountEmail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountEmail(String accountEmail) {
        this.accountEmail = accountEmail;
    }

    public UpdateAccountRequest currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=3, max=3)
    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=3, max=3) String getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public UpdateAccountRequest address(UpsertAddressRequest address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UpsertAddressRequest getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(UpsertAddressRequest address) {
        this.address = address;
    }

    public UpdateAccountRequest preferredDisbursementType(PreferredDisbursementTypeEnum preferredDisbursementType) {
        this.preferredDisbursementType = preferredDisbursementType;
        return this;
    }

    @Nullable
    @JsonProperty(value="preferredDisbursementType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PreferredDisbursementTypeEnum getPreferredDisbursementType() {
        return this.preferredDisbursementType;
    }

    @JsonProperty(value="preferredDisbursementType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPreferredDisbursementType(PreferredDisbursementTypeEnum preferredDisbursementType) {
        this.preferredDisbursementType = preferredDisbursementType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateAccountRequest updateAccountRequest = (UpdateAccountRequest)o;
        return Objects.equals(this.name, updateAccountRequest.name) && Objects.equals(this.legalName, updateAccountRequest.legalName) && Objects.equals(this.description, updateAccountRequest.description) && Objects.equals(this.url, updateAccountRequest.url) && Objects.equals(this.accountEmail, updateAccountRequest.accountEmail) && Objects.equals(this.currencyCode, updateAccountRequest.currencyCode) && Objects.equals(this.address, updateAccountRequest.address) && Objects.equals((Object)this.preferredDisbursementType, (Object)updateAccountRequest.preferredDisbursementType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.legalName, this.description, this.url, this.accountEmail, this.currencyCode, this.address, this.preferredDisbursementType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateAccountRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    legalName: ").append(this.toIndentedString(this.legalName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    accountEmail: ").append(this.toIndentedString(this.accountEmail)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    preferredDisbursementType: ").append(this.toIndentedString((Object)this.preferredDisbursementType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PreferredDisbursementTypeEnum {
        VIRTUAL_CREDIT_CARD("VIRTUAL_CREDIT_CARD"),
        BANK_TRANSFER("BANK_TRANSFER");

        private String value;

        private PreferredDisbursementTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PreferredDisbursementTypeEnum fromValue(String value) {
            for (PreferredDisbursementTypeEnum b : PreferredDisbursementTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

