/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;
import io.trippay.sdk.payment.model.AggregateBookingContractCancellationState;
import io.trippay.sdk.payment.model.AggregateBookingContractCaptureCurrenciesByAccountResponse;
import io.trippay.sdk.payment.model.BeneficiaryAggregateData;
import io.trippay.sdk.payment.model.BookingContract;
import io.trippay.sdk.payment.model.BookingContractCancellableResponse;
import io.trippay.sdk.payment.model.CancelBookingContractRequest;
import io.trippay.sdk.payment.model.ExternalBookingContract;
import io.trippay.sdk.payment.model.ImmediateRefundRequest;
import io.trippay.sdk.payment.model.PageBookingContract;
import io.trippay.sdk.payment.model.PriceBookingContractRequest;
import io.trippay.sdk.payment.model.PriceBookingContractResponse;
import io.trippay.sdk.payment.model.PriceSupplierContractWithAcquirerRequest;
import io.trippay.sdk.payment.model.PriceSupplierContractWithAcquirerResponse;
import io.trippay.sdk.payment.model.RefundRequest;
import io.trippay.sdk.payment.model.State;
import io.trippay.sdk.payment.model.TotalAggregateFunds;
import io.trippay.sdk.payment.model.ValidateBookingContractRequest;
import io.trippay.sdk.payment.model.ValidateBookingContractResponse;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ContractApi {
    private ApiClient apiClient;

    public ContractApi() {
        this(new ApiClient());
    }

    @Autowired
    public ContractApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec cancelBookingContractRequestCreation(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        CancelBookingContractRequest postBody = cancelBookingContractRequest;
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling cancelBookingContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (cancelBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancelBookingContractRequest' when calling cancelBookingContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("identifier", identifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(this){};
        return this.apiClient.invokeAPI("/api/contract/{identifier}/cancel", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingContract> cancelBookingContract(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(this){};
        return this.cancelBookingContractRequestCreation(identifier, cancelBookingContractRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingContract>> cancelBookingContractWithHttpInfo(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(this){};
        return this.cancelBookingContractRequestCreation(identifier, cancelBookingContractRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec cancelBookingContractWithResponseSpec(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        return this.cancelBookingContractRequestCreation(identifier, cancelBookingContractRequest, winkVersion);
    }

    private WebClient.ResponseSpec cancelGroupBookingContractRequestCreation(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        CancelBookingContractRequest postBody = cancelBookingContractRequest;
        if (traceId == null) {
            throw new WebClientResponseException("Missing the required parameter 'traceId' when calling cancelGroupBookingContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (cancelBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancelBookingContractRequest' when calling cancelGroupBookingContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("traceId", traceId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(this){};
        return this.apiClient.invokeAPI("/api/contract/list/{traceId}/cancel", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<BookingContract> cancelGroupBookingContract(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(this){};
        return this.cancelGroupBookingContractRequestCreation(traceId, cancelBookingContractRequest, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<BookingContract>>> cancelGroupBookingContractWithHttpInfo(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(this){};
        return this.cancelGroupBookingContractRequestCreation(traceId, cancelBookingContractRequest, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec cancelGroupBookingContractWithResponseSpec(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        return this.cancelGroupBookingContractRequestCreation(traceId, cancelBookingContractRequest, winkVersion);
    }

    private WebClient.ResponseSpec immediateGroupRefundRequestCreation(String traceId, ImmediateRefundRequest immediateRefundRequest, String winkVersion) throws WebClientResponseException {
        ImmediateRefundRequest postBody = immediateRefundRequest;
        if (traceId == null) {
            throw new WebClientResponseException("Missing the required parameter 'traceId' when calling immediateGroupRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (immediateRefundRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'immediateRefundRequest' when calling immediateGroupRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("traceId", traceId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(this){};
        return this.apiClient.invokeAPI("/api/contract/list/{traceId}/immediate-refund", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<BookingContract> immediateGroupRefund(String traceId, ImmediateRefundRequest immediateRefundRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(this){};
        return this.immediateGroupRefundRequestCreation(traceId, immediateRefundRequest, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<BookingContract>>> immediateGroupRefundWithHttpInfo(String traceId, ImmediateRefundRequest immediateRefundRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(this){};
        return this.immediateGroupRefundRequestCreation(traceId, immediateRefundRequest, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec immediateGroupRefundWithResponseSpec(String traceId, ImmediateRefundRequest immediateRefundRequest, String winkVersion) throws WebClientResponseException {
        return this.immediateGroupRefundRequestCreation(traceId, immediateRefundRequest, winkVersion);
    }

    private WebClient.ResponseSpec immediateRefundRequestCreation(String identifier, ImmediateRefundRequest immediateRefundRequest, String winkVersion) throws WebClientResponseException {
        ImmediateRefundRequest postBody = immediateRefundRequest;
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling immediateRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (immediateRefundRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'immediateRefundRequest' when calling immediateRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("identifier", identifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(this){};
        return this.apiClient.invokeAPI("/api/contract/{identifier}/immediate-refund", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingContract> immediateRefund(String identifier, ImmediateRefundRequest immediateRefundRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(this){};
        return this.immediateRefundRequestCreation(identifier, immediateRefundRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingContract>> immediateRefundWithHttpInfo(String identifier, ImmediateRefundRequest immediateRefundRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(this){};
        return this.immediateRefundRequestCreation(identifier, immediateRefundRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec immediateRefundWithResponseSpec(String identifier, ImmediateRefundRequest immediateRefundRequest, String winkVersion) throws WebClientResponseException {
        return this.immediateRefundRequestCreation(identifier, immediateRefundRequest, winkVersion);
    }

    private WebClient.ResponseSpec isContractCancellableRequestCreation(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        CancelBookingContractRequest postBody = cancelBookingContractRequest;
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling isContractCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (cancelBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancelBookingContractRequest' when calling isContractCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("identifier", identifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>(this){};
        return this.apiClient.invokeAPI("/api/contract/{identifier}/cancellable", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingContractCancellableResponse> isContractCancellable(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>(this){};
        return this.isContractCancellableRequestCreation(identifier, cancelBookingContractRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingContractCancellableResponse>> isContractCancellableWithHttpInfo(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>(this){};
        return this.isContractCancellableRequestCreation(identifier, cancelBookingContractRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec isContractCancellableWithResponseSpec(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        return this.isContractCancellableRequestCreation(identifier, cancelBookingContractRequest, winkVersion);
    }

    private WebClient.ResponseSpec isGroupContractCancellableRequestCreation(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        CancelBookingContractRequest postBody = cancelBookingContractRequest;
        if (traceId == null) {
            throw new WebClientResponseException("Missing the required parameter 'traceId' when calling isGroupContractCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (cancelBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancelBookingContractRequest' when calling isGroupContractCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("traceId", traceId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>(this){};
        return this.apiClient.invokeAPI("/api/contract/list/{traceId}/cancellable", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<BookingContractCancellableResponse> isGroupContractCancellable(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>(this){};
        return this.isGroupContractCancellableRequestCreation(traceId, cancelBookingContractRequest, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<BookingContractCancellableResponse>>> isGroupContractCancellableWithHttpInfo(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>(this){};
        return this.isGroupContractCancellableRequestCreation(traceId, cancelBookingContractRequest, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec isGroupContractCancellableWithResponseSpec(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        return this.isGroupContractCancellableRequestCreation(traceId, cancelBookingContractRequest, winkVersion);
    }

    private WebClient.ResponseSpec priceRequestCreation(PriceSupplierContractWithAcquirerRequest priceSupplierContractWithAcquirerRequest, String winkVersion) throws WebClientResponseException {
        PriceSupplierContractWithAcquirerRequest postBody = priceSupplierContractWithAcquirerRequest;
        if (priceSupplierContractWithAcquirerRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'priceSupplierContractWithAcquirerRequest' when calling price", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PriceSupplierContractWithAcquirerResponse> localVarReturnType = new ParameterizedTypeReference<PriceSupplierContractWithAcquirerResponse>(this){};
        return this.apiClient.invokeAPI("/contract/price/acquirer", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PriceSupplierContractWithAcquirerResponse> price(PriceSupplierContractWithAcquirerRequest priceSupplierContractWithAcquirerRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PriceSupplierContractWithAcquirerResponse> localVarReturnType = new ParameterizedTypeReference<PriceSupplierContractWithAcquirerResponse>(this){};
        return this.priceRequestCreation(priceSupplierContractWithAcquirerRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PriceSupplierContractWithAcquirerResponse>> priceWithHttpInfo(PriceSupplierContractWithAcquirerRequest priceSupplierContractWithAcquirerRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PriceSupplierContractWithAcquirerResponse> localVarReturnType = new ParameterizedTypeReference<PriceSupplierContractWithAcquirerResponse>(this){};
        return this.priceRequestCreation(priceSupplierContractWithAcquirerRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec priceWithResponseSpec(PriceSupplierContractWithAcquirerRequest priceSupplierContractWithAcquirerRequest, String winkVersion) throws WebClientResponseException {
        return this.priceRequestCreation(priceSupplierContractWithAcquirerRequest, winkVersion);
    }

    private WebClient.ResponseSpec price1RequestCreation(PriceBookingContractRequest priceBookingContractRequest, String winkVersion) throws WebClientResponseException {
        PriceBookingContractRequest postBody = priceBookingContractRequest;
        if (priceBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'priceBookingContractRequest' when calling price1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PriceBookingContractResponse> localVarReturnType = new ParameterizedTypeReference<PriceBookingContractResponse>(this){};
        return this.apiClient.invokeAPI("/contract/price", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PriceBookingContractResponse> price1(PriceBookingContractRequest priceBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PriceBookingContractResponse> localVarReturnType = new ParameterizedTypeReference<PriceBookingContractResponse>(this){};
        return this.price1RequestCreation(priceBookingContractRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PriceBookingContractResponse>> price1WithHttpInfo(PriceBookingContractRequest priceBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PriceBookingContractResponse> localVarReturnType = new ParameterizedTypeReference<PriceBookingContractResponse>(this){};
        return this.price1RequestCreation(priceBookingContractRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec price1WithResponseSpec(PriceBookingContractRequest priceBookingContractRequest, String winkVersion) throws WebClientResponseException {
        return this.price1RequestCreation(priceBookingContractRequest, winkVersion);
    }

    private WebClient.ResponseSpec requestRefundRequestCreation(String identifier, RefundRequest refundRequest, String winkVersion) throws WebClientResponseException {
        RefundRequest postBody = refundRequest;
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling requestRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (refundRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'refundRequest' when calling requestRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("identifier", identifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(this){};
        return this.apiClient.invokeAPI("/api/contract/{identifier}/request-refund", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingContract> requestRefund(String identifier, RefundRequest refundRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(this){};
        return this.requestRefundRequestCreation(identifier, refundRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingContract>> requestRefundWithHttpInfo(String identifier, RefundRequest refundRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(this){};
        return this.requestRefundRequestCreation(identifier, refundRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec requestRefundWithResponseSpec(String identifier, RefundRequest refundRequest, String winkVersion) throws WebClientResponseException {
        return this.requestRefundRequestCreation(identifier, refundRequest, winkVersion);
    }

    private WebClient.ResponseSpec showAggregateBookingContractDataRequestCreation(String accountIdentifier, String type, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling showAggregateBookingContractData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("accountIdentifier", accountIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "type", type));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BeneficiaryAggregateData> localVarReturnType = new ParameterizedTypeReference<BeneficiaryAggregateData>(this){};
        return this.apiClient.invokeAPI("/api/account/{accountIdentifier}/contract/aggregate/beneficiary", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<BeneficiaryAggregateData> showAggregateBookingContractData(String accountIdentifier, String type, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BeneficiaryAggregateData> localVarReturnType = new ParameterizedTypeReference<BeneficiaryAggregateData>(this){};
        return this.showAggregateBookingContractDataRequestCreation(accountIdentifier, type, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<BeneficiaryAggregateData>>> showAggregateBookingContractDataWithHttpInfo(String accountIdentifier, String type, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BeneficiaryAggregateData> localVarReturnType = new ParameterizedTypeReference<BeneficiaryAggregateData>(this){};
        return this.showAggregateBookingContractDataRequestCreation(accountIdentifier, type, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAggregateBookingContractDataWithResponseSpec(String accountIdentifier, String type, String winkVersion) throws WebClientResponseException {
        return this.showAggregateBookingContractDataRequestCreation(accountIdentifier, type, winkVersion);
    }

    private WebClient.ResponseSpec showAggregateCancellationDataRequestCreation(String accountIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling showAggregateCancellationData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("accountIdentifier", accountIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AggregateBookingContractCancellationState> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCancellationState>(this){};
        return this.apiClient.invokeAPI("/api/account/{accountIdentifier}/contract/aggregate/cancellation", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<AggregateBookingContractCancellationState> showAggregateCancellationData(String accountIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AggregateBookingContractCancellationState> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCancellationState>(this){};
        return this.showAggregateCancellationDataRequestCreation(accountIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<AggregateBookingContractCancellationState>>> showAggregateCancellationDataWithHttpInfo(String accountIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AggregateBookingContractCancellationState> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCancellationState>(this){};
        return this.showAggregateCancellationDataRequestCreation(accountIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAggregateCancellationDataWithResponseSpec(String accountIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showAggregateCancellationDataRequestCreation(accountIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showCaptureCurrenciesRequestCreation(String accountIdentifier, String state, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling showCaptureCurrencies", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("accountIdentifier", accountIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "state", state));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AggregateBookingContractCaptureCurrenciesByAccountResponse> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCaptureCurrenciesByAccountResponse>(this){};
        return this.apiClient.invokeAPI("/api/account/{accountIdentifier}/contract/capture", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AggregateBookingContractCaptureCurrenciesByAccountResponse> showCaptureCurrencies(String accountIdentifier, String state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AggregateBookingContractCaptureCurrenciesByAccountResponse> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCaptureCurrenciesByAccountResponse>(this){};
        return this.showCaptureCurrenciesRequestCreation(accountIdentifier, state, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AggregateBookingContractCaptureCurrenciesByAccountResponse>> showCaptureCurrenciesWithHttpInfo(String accountIdentifier, String state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AggregateBookingContractCaptureCurrenciesByAccountResponse> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCaptureCurrenciesByAccountResponse>(this){};
        return this.showCaptureCurrenciesRequestCreation(accountIdentifier, state, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCaptureCurrenciesWithResponseSpec(String accountIdentifier, String state, String winkVersion) throws WebClientResponseException {
        return this.showCaptureCurrenciesRequestCreation(accountIdentifier, state, winkVersion);
    }

    private WebClient.ResponseSpec showContractRequestCreation(String identifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling showContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("identifier", identifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(this){};
        return this.apiClient.invokeAPI("/api/contract/{identifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingContract> showContract(String identifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(this){};
        return this.showContractRequestCreation(identifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingContract>> showContractWithHttpInfo(String identifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(this){};
        return this.showContractRequestCreation(identifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showContractWithResponseSpec(String identifier, String winkVersion) throws WebClientResponseException {
        return this.showContractRequestCreation(identifier, winkVersion);
    }

    private WebClient.ResponseSpec showContractForExternalAccountRequestCreation(String externalAccountIdentifier, String bookingContractIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (externalAccountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'externalAccountIdentifier' when calling showContractForExternalAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingContractIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingContractIdentifier' when calling showContractForExternalAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("externalAccountIdentifier", externalAccountIdentifier);
        pathParams.put("bookingContractIdentifier", bookingContractIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ExternalBookingContract> localVarReturnType = new ParameterizedTypeReference<ExternalBookingContract>(this){};
        return this.apiClient.invokeAPI("/api/account/external/{externalAccountIdentifier}/contract/{bookingContractIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ExternalBookingContract> showContractForExternalAccount(String externalAccountIdentifier, String bookingContractIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ExternalBookingContract> localVarReturnType = new ParameterizedTypeReference<ExternalBookingContract>(this){};
        return this.showContractForExternalAccountRequestCreation(externalAccountIdentifier, bookingContractIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ExternalBookingContract>> showContractForExternalAccountWithHttpInfo(String externalAccountIdentifier, String bookingContractIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ExternalBookingContract> localVarReturnType = new ParameterizedTypeReference<ExternalBookingContract>(this){};
        return this.showContractForExternalAccountRequestCreation(externalAccountIdentifier, bookingContractIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showContractForExternalAccountWithResponseSpec(String externalAccountIdentifier, String bookingContractIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showContractForExternalAccountRequestCreation(externalAccountIdentifier, bookingContractIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showContractFundsRequestCreation(String accountIdentifier, String state, Boolean accountFundsOnly, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling showContractFunds", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("accountIdentifier", accountIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "state", state));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "accountFundsOnly", accountFundsOnly));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<TotalAggregateFunds> localVarReturnType = new ParameterizedTypeReference<TotalAggregateFunds>(this){};
        return this.apiClient.invokeAPI("/api/account/{accountIdentifier}/contract/funds", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<TotalAggregateFunds> showContractFunds(String accountIdentifier, String state, Boolean accountFundsOnly, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<TotalAggregateFunds> localVarReturnType = new ParameterizedTypeReference<TotalAggregateFunds>(this){};
        return this.showContractFundsRequestCreation(accountIdentifier, state, accountFundsOnly, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<TotalAggregateFunds>> showContractFundsWithHttpInfo(String accountIdentifier, String state, Boolean accountFundsOnly, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<TotalAggregateFunds> localVarReturnType = new ParameterizedTypeReference<TotalAggregateFunds>(this){};
        return this.showContractFundsRequestCreation(accountIdentifier, state, accountFundsOnly, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showContractFundsWithResponseSpec(String accountIdentifier, String state, Boolean accountFundsOnly, String winkVersion) throws WebClientResponseException {
        return this.showContractFundsRequestCreation(accountIdentifier, state, accountFundsOnly, winkVersion);
    }

    private WebClient.ResponseSpec showContractGridRequestCreation(String accountIdentifier, State state2, String state, String winkVersion) throws WebClientResponseException {
        State postBody = state2;
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling showContractGrid", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (state2 == null) {
            throw new WebClientResponseException("Missing the required parameter 'state2' when calling showContractGrid", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("accountIdentifier", accountIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "state", state));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageBookingContract> localVarReturnType = new ParameterizedTypeReference<PageBookingContract>(this){};
        return this.apiClient.invokeAPI("/api/account/{accountIdentifier}/contract/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageBookingContract> showContractGrid(String accountIdentifier, State state2, String state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingContract> localVarReturnType = new ParameterizedTypeReference<PageBookingContract>(this){};
        return this.showContractGridRequestCreation(accountIdentifier, state2, state, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageBookingContract>> showContractGridWithHttpInfo(String accountIdentifier, State state2, String state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingContract> localVarReturnType = new ParameterizedTypeReference<PageBookingContract>(this){};
        return this.showContractGridRequestCreation(accountIdentifier, state2, state, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showContractGridWithResponseSpec(String accountIdentifier, State state2, String state, String winkVersion) throws WebClientResponseException {
        return this.showContractGridRequestCreation(accountIdentifier, state2, state, winkVersion);
    }

    private WebClient.ResponseSpec showContractsRequestCreation(String traceId, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (traceId == null) {
            throw new WebClientResponseException("Missing the required parameter 'traceId' when calling showContracts", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("traceId", traceId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(this){};
        return this.apiClient.invokeAPI("/api/contract/list/{traceId}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<BookingContract> showContracts(String traceId, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(this){};
        return this.showContractsRequestCreation(traceId, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<BookingContract>>> showContractsWithHttpInfo(String traceId, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(this){};
        return this.showContractsRequestCreation(traceId, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showContractsWithResponseSpec(String traceId, String winkVersion) throws WebClientResponseException {
        return this.showContractsRequestCreation(traceId, winkVersion);
    }

    private WebClient.ResponseSpec showExternalContractRequestCreation(String externalAccountIdentifier, String externalBookingContractIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (externalAccountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'externalAccountIdentifier' when calling showExternalContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (externalBookingContractIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'externalBookingContractIdentifier' when calling showExternalContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("externalAccountIdentifier", externalAccountIdentifier);
        pathParams.put("externalBookingContractIdentifier", externalBookingContractIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ExternalBookingContract> localVarReturnType = new ParameterizedTypeReference<ExternalBookingContract>(this){};
        return this.apiClient.invokeAPI("/api/account/external/{externalAccountIdentifier}/contract/external/{externalBookingContractIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ExternalBookingContract> showExternalContract(String externalAccountIdentifier, String externalBookingContractIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ExternalBookingContract> localVarReturnType = new ParameterizedTypeReference<ExternalBookingContract>(this){};
        return this.showExternalContractRequestCreation(externalAccountIdentifier, externalBookingContractIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ExternalBookingContract>> showExternalContractWithHttpInfo(String externalAccountIdentifier, String externalBookingContractIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ExternalBookingContract> localVarReturnType = new ParameterizedTypeReference<ExternalBookingContract>(this){};
        return this.showExternalContractRequestCreation(externalAccountIdentifier, externalBookingContractIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showExternalContractWithResponseSpec(String externalAccountIdentifier, String externalBookingContractIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showExternalContractRequestCreation(externalAccountIdentifier, externalBookingContractIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec validateRequestCreation(ValidateBookingContractRequest validateBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ValidateBookingContractRequest postBody = validateBookingContractRequest;
        if (validateBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'validateBookingContractRequest' when calling validate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ValidateBookingContractResponse> localVarReturnType = new ParameterizedTypeReference<ValidateBookingContractResponse>(this){};
        return this.apiClient.invokeAPI("/contract/validate", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ValidateBookingContractResponse> validate(ValidateBookingContractRequest validateBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ValidateBookingContractResponse> localVarReturnType = new ParameterizedTypeReference<ValidateBookingContractResponse>(this){};
        return this.validateRequestCreation(validateBookingContractRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ValidateBookingContractResponse>> validateWithHttpInfo(ValidateBookingContractRequest validateBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ValidateBookingContractResponse> localVarReturnType = new ParameterizedTypeReference<ValidateBookingContractResponse>(this){};
        return this.validateRequestCreation(validateBookingContractRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec validateWithResponseSpec(ValidateBookingContractRequest validateBookingContractRequest, String winkVersion) throws WebClientResponseException {
        return this.validateRequestCreation(validateBookingContractRequest, winkVersion);
    }
}

