/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.trippay.sdk.payment.model.CustomMonetaryAmount;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"acquirerIdentifier", "charge", "name", "description", "customerIdentifier", "metadata"})
public class CreatePaymentIntentRequest {
    public static final String JSON_PROPERTY_ACQUIRER_IDENTIFIER = "acquirerIdentifier";
    private String acquirerIdentifier;
    public static final String JSON_PROPERTY_CHARGE = "charge";
    private CustomMonetaryAmount charge;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_CUSTOMER_IDENTIFIER = "customerIdentifier";
    private String customerIdentifier;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, String> metadata = new HashMap<String, String>();

    public CreatePaymentIntentRequest acquirerIdentifier(String acquirerIdentifier) {
        this.acquirerIdentifier = acquirerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="acquirerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAcquirerIdentifier() {
        return this.acquirerIdentifier;
    }

    @JsonProperty(value="acquirerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAcquirerIdentifier(String acquirerIdentifier) {
        this.acquirerIdentifier = acquirerIdentifier;
    }

    public CreatePaymentIntentRequest charge(CustomMonetaryAmount charge) {
        this.charge = charge;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="charge")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomMonetaryAmount getCharge() {
        return this.charge;
    }

    @JsonProperty(value="charge")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCharge(CustomMonetaryAmount charge) {
        this.charge = charge;
    }

    public CreatePaymentIntentRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public CreatePaymentIntentRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CreatePaymentIntentRequest customerIdentifier(String customerIdentifier) {
        this.customerIdentifier = customerIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="customerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerIdentifier() {
        return this.customerIdentifier;
    }

    @JsonProperty(value="customerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerIdentifier(String customerIdentifier) {
        this.customerIdentifier = customerIdentifier;
    }

    public CreatePaymentIntentRequest metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public CreatePaymentIntentRequest putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePaymentIntentRequest createPaymentIntentRequest = (CreatePaymentIntentRequest)o;
        return Objects.equals(this.acquirerIdentifier, createPaymentIntentRequest.acquirerIdentifier) && Objects.equals(this.charge, createPaymentIntentRequest.charge) && Objects.equals(this.name, createPaymentIntentRequest.name) && Objects.equals(this.description, createPaymentIntentRequest.description) && Objects.equals(this.customerIdentifier, createPaymentIntentRequest.customerIdentifier) && Objects.equals(this.metadata, createPaymentIntentRequest.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.acquirerIdentifier, this.charge, this.name, this.description, this.customerIdentifier, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreatePaymentIntentRequest {\n");
        sb.append("    acquirerIdentifier: ").append(this.toIndentedString(this.acquirerIdentifier)).append("\n");
        sb.append("    charge: ").append(this.toIndentedString(this.charge)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    customerIdentifier: ").append(this.toIndentedString(this.customerIdentifier)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

