/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 29.19.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Itinerary outlines stay dates, number of adults and children
 */
@JsonPropertyOrder({
  Itinerary.JSON_PROPERTY_START_DATE,
  Itinerary.JSON_PROPERTY_END_DATE,
  Itinerary.JSON_PROPERTY_ADULTS,
  Itinerary.JSON_PROPERTY_CHILDREN,
  Itinerary.JSON_PROPERTY_HOURS,
  Itinerary.JSON_PROPERTY_GUESTS,
  Itinerary.JSON_PROPERTY_NIGHTS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-29T12:34:35.620697187+07:00[Asia/Bangkok]")
public class Itinerary {
  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private java.time.LocalDateTime startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private java.time.LocalDateTime endDate;

  public static final String JSON_PROPERTY_ADULTS = "adults";
  private Integer adults;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  private Integer children;

  public static final String JSON_PROPERTY_HOURS = "hours";
  private Long hours;

  public static final String JSON_PROPERTY_GUESTS = "guests";
  private Integer guests;

  public static final String JSON_PROPERTY_NIGHTS = "nights";
  private Long nights;

  public Itinerary() {
  }

  @JsonCreator
  public Itinerary(
    @JsonProperty(JSON_PROPERTY_HOURS) Long hours, 
    @JsonProperty(JSON_PROPERTY_GUESTS) Integer guests, 
    @JsonProperty(JSON_PROPERTY_NIGHTS) Long nights
  ) {
    this();
    this.hours = hours;
    this.guests = guests;
    this.nights = nights;
  }

  public Itinerary startDate(java.time.LocalDateTime startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Start date
   * @return startDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.time.LocalDateTime getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStartDate(java.time.LocalDateTime startDate) {
    this.startDate = startDate;
  }


  public Itinerary endDate(java.time.LocalDateTime endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * End date
   * @return endDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.time.LocalDateTime getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEndDate(java.time.LocalDateTime endDate) {
    this.endDate = endDate;
  }


  public Itinerary adults(Integer adults) {
    
    this.adults = adults;
    return this;
  }

   /**
   * Number of adults
   * minimum: 0
   * @return adults
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0)
  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAdults() {
    return adults;
  }


  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAdults(Integer adults) {
    this.adults = adults;
  }


  public Itinerary children(Integer children) {
    
    this.children = children;
    return this;
  }

   /**
   * Number of children
   * minimum: 0
   * @return children
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0)
  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getChildren() {
    return children;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChildren(Integer children) {
    this.children = children;
  }


   /**
   * Number of hours between start and end dates. Used for itineraries that require bookings that occur within hours and not days. E.g. Meeting room reservation.
   * @return hours
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOURS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getHours() {
    return hours;
  }




   /**
   * Total number of adults and children
   * @return guests
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getGuests() {
    return guests;
  }




   /**
   * Total number of room nights
   * @return nights
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getNights() {
    return nights;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Itinerary itinerary = (Itinerary) o;
    return Objects.equals(this.startDate, itinerary.startDate) &&
        Objects.equals(this.endDate, itinerary.endDate) &&
        Objects.equals(this.adults, itinerary.adults) &&
        Objects.equals(this.children, itinerary.children) &&
        Objects.equals(this.hours, itinerary.hours) &&
        Objects.equals(this.guests, itinerary.guests) &&
        Objects.equals(this.nights, itinerary.nights);
  }

  @Override
  public int hashCode() {
    return Objects.hash(startDate, endDate, adults, children, hours, guests, nights);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Itinerary {\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    adults: ").append(toIndentedString(adults)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    hours: ").append(toIndentedString(hours)).append("\n");
    sb.append("    guests: ").append(toIndentedString(guests)).append("\n");
    sb.append("    nights: ").append(toIndentedString(nights)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

