/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"id", "createdDate", "lastUpdate", "version", "instant", "sender", "receiver", "type", "entityIdentifier", "request", "response", "mediaType", "httpResponseCode", "score"})
public class ExternalEvent {
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    private LocalDateTime createdDate;
    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    private LocalDateTime lastUpdate;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Long version;
    public static final String JSON_PROPERTY_INSTANT = "instant";
    private LocalDateTime instant;
    public static final String JSON_PROPERTY_SENDER = "sender";
    private SenderEnum sender;
    public static final String JSON_PROPERTY_RECEIVER = "receiver";
    private ReceiverEnum receiver;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_ENTITY_IDENTIFIER = "entityIdentifier";
    private String entityIdentifier;
    public static final String JSON_PROPERTY_REQUEST = "request";
    private String request;
    public static final String JSON_PROPERTY_RESPONSE = "response";
    private String response;
    public static final String JSON_PROPERTY_MEDIA_TYPE = "mediaType";
    private String mediaType;
    public static final String JSON_PROPERTY_HTTP_RESPONSE_CODE = "httpResponseCode";
    private Integer httpResponseCode;
    public static final String JSON_PROPERTY_SCORE = "score";
    private Float score;

    public ExternalEvent() {
    }

    @JsonCreator
    public ExternalEvent(@JsonProperty(value="id") UUID id, @JsonProperty(value="createdDate") LocalDateTime createdDate, @JsonProperty(value="lastUpdate") LocalDateTime lastUpdate, @JsonProperty(value="version") Long version) {
        this();
        this.id = id;
        this.createdDate = createdDate;
        this.lastUpdate = lastUpdate;
        this.version = version;
    }

    @Nullable
    @Valid
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getId() {
        return this.id;
    }

    @Nullable
    @Valid
    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    @Nullable
    @Valid
    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersion() {
        return this.version;
    }

    public ExternalEvent instant(LocalDateTime instant) {
        this.instant = instant;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="instant")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDateTime getInstant() {
        return this.instant;
    }

    @JsonProperty(value="instant")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInstant(LocalDateTime instant) {
        this.instant = instant;
    }

    public ExternalEvent sender(SenderEnum sender) {
        this.sender = sender;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="sender")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SenderEnum getSender() {
        return this.sender;
    }

    @JsonProperty(value="sender")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSender(SenderEnum sender) {
        this.sender = sender;
    }

    public ExternalEvent receiver(ReceiverEnum receiver) {
        this.receiver = receiver;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="receiver")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ReceiverEnum getReceiver() {
        return this.receiver;
    }

    @JsonProperty(value="receiver")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setReceiver(ReceiverEnum receiver) {
        this.receiver = receiver;
    }

    public ExternalEvent type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public ExternalEvent entityIdentifier(String entityIdentifier) {
        this.entityIdentifier = entityIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="entityIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEntityIdentifier() {
        return this.entityIdentifier;
    }

    @JsonProperty(value="entityIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEntityIdentifier(String entityIdentifier) {
        this.entityIdentifier = entityIdentifier;
    }

    public ExternalEvent request(String request) {
        this.request = request;
        return this;
    }

    @Nullable
    @JsonProperty(value="request")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRequest() {
        return this.request;
    }

    @JsonProperty(value="request")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequest(String request) {
        this.request = request;
    }

    public ExternalEvent response(String response) {
        this.response = response;
        return this;
    }

    @Nullable
    @JsonProperty(value="response")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResponse() {
        return this.response;
    }

    @JsonProperty(value="response")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResponse(String response) {
        this.response = response;
    }

    public ExternalEvent mediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="mediaType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMediaType() {
        return this.mediaType;
    }

    @JsonProperty(value="mediaType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public ExternalEvent httpResponseCode(Integer httpResponseCode) {
        this.httpResponseCode = httpResponseCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="httpResponseCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getHttpResponseCode() {
        return this.httpResponseCode;
    }

    @JsonProperty(value="httpResponseCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHttpResponseCode(Integer httpResponseCode) {
        this.httpResponseCode = httpResponseCode;
    }

    public ExternalEvent score(Float score) {
        this.score = score;
        return this;
    }

    @Nullable
    @JsonProperty(value="score")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getScore() {
        return this.score;
    }

    @JsonProperty(value="score")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScore(Float score) {
        this.score = score;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalEvent externalEvent = (ExternalEvent)o;
        return Objects.equals(this.id, externalEvent.id) && Objects.equals(this.createdDate, externalEvent.createdDate) && Objects.equals(this.lastUpdate, externalEvent.lastUpdate) && Objects.equals(this.version, externalEvent.version) && Objects.equals(this.instant, externalEvent.instant) && Objects.equals((Object)this.sender, (Object)externalEvent.sender) && Objects.equals((Object)this.receiver, (Object)externalEvent.receiver) && Objects.equals(this.type, externalEvent.type) && Objects.equals(this.entityIdentifier, externalEvent.entityIdentifier) && Objects.equals(this.request, externalEvent.request) && Objects.equals(this.response, externalEvent.response) && Objects.equals(this.mediaType, externalEvent.mediaType) && Objects.equals(this.httpResponseCode, externalEvent.httpResponseCode) && Objects.equals(this.score, externalEvent.score);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.createdDate, this.lastUpdate, this.version, this.instant, this.sender, this.receiver, this.type, this.entityIdentifier, this.request, this.response, this.mediaType, this.httpResponseCode, this.score});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExternalEvent {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    instant: ").append(this.toIndentedString(this.instant)).append("\n");
        sb.append("    sender: ").append(this.toIndentedString((Object)this.sender)).append("\n");
        sb.append("    receiver: ").append(this.toIndentedString((Object)this.receiver)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    entityIdentifier: ").append(this.toIndentedString(this.entityIdentifier)).append("\n");
        sb.append("    request: ").append(this.toIndentedString(this.request)).append("\n");
        sb.append("    response: ").append(this.toIndentedString(this.response)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString(this.mediaType)).append("\n");
        sb.append("    httpResponseCode: ").append(this.toIndentedString(this.httpResponseCode)).append("\n");
        sb.append("    score: ").append(this.toIndentedString(this.score)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SenderEnum {
        WINK("WINK"),
        TRIP_PAY("TRIP_PAY");

        private String value;

        private SenderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SenderEnum fromValue(String value) {
            for (SenderEnum b : SenderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ReceiverEnum {
        PAYMENT_WEBHOOK_LISTENER("PAYMENT_WEBHOOK_LISTENER"),
        CHANNEL_MANAGER_ALLOTZ("CHANNEL_MANAGER_ALLOTZ"),
        CHANNEL_MANAGER_DEDGE("CHANNEL_MANAGER_DEDGE"),
        CHANNEL_MANAGER_CHANNEX("CHANNEL_MANAGER_CHANNEX"),
        CHANNEL_MANAGER_RATE_GAIN_SYNXIS("CHANNEL_MANAGER_RATE_GAIN_SYNXIS");

        private String value;

        private ReceiverEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ReceiverEnum fromValue(String value) {
            for (ReceiverEnum b : ReceiverEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

