/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.BeneficiaryCharge;
import io.trippay.sdk.payment.model.PendingRefund;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"accountIdentifier", "accountName", "accountEmail", "accountUrl", "type", "amountDue", "sourceCurrency", "displayCurrency", "supplierCurrency", "internalCurrency", "captureCurrency", "sourceAmount", "displayAmount", "supplierAmount", "internalAmount", "captureAmount", "sourceAmountRefundModifier", "displayAmountRefundModifier", "supplierAmountRefundModifier", "internalAmountRefundModifier", "captureAmountRefundModifier", "pendingRefunds", "metadata", "netCaptureAmount", "netSupplierAmount", "netSourceAmount", "netDisplayAmount", "netInternalAmount"})
public class Beneficiary {
    public static final String JSON_PROPERTY_ACCOUNT_IDENTIFIER = "accountIdentifier";
    private String accountIdentifier;
    public static final String JSON_PROPERTY_ACCOUNT_NAME = "accountName";
    private String accountName;
    public static final String JSON_PROPERTY_ACCOUNT_EMAIL = "accountEmail";
    private String accountEmail;
    public static final String JSON_PROPERTY_ACCOUNT_URL = "accountUrl";
    private String accountUrl;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_AMOUNT_DUE = "amountDue";
    private BeneficiaryCharge amountDue;
    public static final String JSON_PROPERTY_SOURCE_CURRENCY = "sourceCurrency";
    private String sourceCurrency;
    public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
    private String displayCurrency;
    public static final String JSON_PROPERTY_SUPPLIER_CURRENCY = "supplierCurrency";
    private String supplierCurrency;
    public static final String JSON_PROPERTY_INTERNAL_CURRENCY = "internalCurrency";
    private String internalCurrency;
    public static final String JSON_PROPERTY_CAPTURE_CURRENCY = "captureCurrency";
    private String captureCurrency;
    public static final String JSON_PROPERTY_SOURCE_AMOUNT = "sourceAmount";
    private BigDecimal sourceAmount;
    public static final String JSON_PROPERTY_DISPLAY_AMOUNT = "displayAmount";
    private BigDecimal displayAmount;
    public static final String JSON_PROPERTY_SUPPLIER_AMOUNT = "supplierAmount";
    private BigDecimal supplierAmount;
    public static final String JSON_PROPERTY_INTERNAL_AMOUNT = "internalAmount";
    private BigDecimal internalAmount;
    public static final String JSON_PROPERTY_CAPTURE_AMOUNT = "captureAmount";
    private BigDecimal captureAmount;
    public static final String JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER = "sourceAmountRefundModifier";
    private BigDecimal sourceAmountRefundModifier;
    public static final String JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER = "displayAmountRefundModifier";
    private BigDecimal displayAmountRefundModifier;
    public static final String JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER = "supplierAmountRefundModifier";
    private BigDecimal supplierAmountRefundModifier;
    public static final String JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER = "internalAmountRefundModifier";
    private BigDecimal internalAmountRefundModifier;
    public static final String JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER = "captureAmountRefundModifier";
    private BigDecimal captureAmountRefundModifier;
    public static final String JSON_PROPERTY_PENDING_REFUNDS = "pendingRefunds";
    private List<PendingRefund> pendingRefunds;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, String> metadata = new HashMap<String, String>();
    public static final String JSON_PROPERTY_NET_CAPTURE_AMOUNT = "netCaptureAmount";
    private BigDecimal netCaptureAmount;
    public static final String JSON_PROPERTY_NET_SUPPLIER_AMOUNT = "netSupplierAmount";
    private BigDecimal netSupplierAmount;
    public static final String JSON_PROPERTY_NET_SOURCE_AMOUNT = "netSourceAmount";
    private BigDecimal netSourceAmount;
    public static final String JSON_PROPERTY_NET_DISPLAY_AMOUNT = "netDisplayAmount";
    private BigDecimal netDisplayAmount;
    public static final String JSON_PROPERTY_NET_INTERNAL_AMOUNT = "netInternalAmount";
    private BigDecimal netInternalAmount;

    public Beneficiary accountIdentifier(String accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="accountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountIdentifier() {
        return this.accountIdentifier;
    }

    @JsonProperty(value="accountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountIdentifier(String accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
    }

    public Beneficiary accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="accountName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountName() {
        return this.accountName;
    }

    @JsonProperty(value="accountName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public Beneficiary accountEmail(String accountEmail) {
        this.accountEmail = accountEmail;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="accountEmail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountEmail() {
        return this.accountEmail;
    }

    @JsonProperty(value="accountEmail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountEmail(String accountEmail) {
        this.accountEmail = accountEmail;
    }

    public Beneficiary accountUrl(String accountUrl) {
        this.accountUrl = accountUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="accountUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountUrl() {
        return this.accountUrl;
    }

    @JsonProperty(value="accountUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountUrl(String accountUrl) {
        this.accountUrl = accountUrl;
    }

    public Beneficiary type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Beneficiary amountDue(BeneficiaryCharge amountDue) {
        this.amountDue = amountDue;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="amountDue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BeneficiaryCharge getAmountDue() {
        return this.amountDue;
    }

    @JsonProperty(value="amountDue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmountDue(BeneficiaryCharge amountDue) {
        this.amountDue = amountDue;
    }

    public Beneficiary sourceCurrency(String sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="sourceCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceCurrency() {
        return this.sourceCurrency;
    }

    @JsonProperty(value="sourceCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceCurrency(String sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
    }

    public Beneficiary displayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDisplayCurrency() {
        return this.displayCurrency;
    }

    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
    }

    public Beneficiary supplierCurrency(String supplierCurrency) {
        this.supplierCurrency = supplierCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="supplierCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSupplierCurrency() {
        return this.supplierCurrency;
    }

    @JsonProperty(value="supplierCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierCurrency(String supplierCurrency) {
        this.supplierCurrency = supplierCurrency;
    }

    public Beneficiary internalCurrency(String internalCurrency) {
        this.internalCurrency = internalCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="internalCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getInternalCurrency() {
        return this.internalCurrency;
    }

    @JsonProperty(value="internalCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalCurrency(String internalCurrency) {
        this.internalCurrency = internalCurrency;
    }

    public Beneficiary captureCurrency(String captureCurrency) {
        this.captureCurrency = captureCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="captureCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCaptureCurrency() {
        return this.captureCurrency;
    }

    @JsonProperty(value="captureCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCaptureCurrency(String captureCurrency) {
        this.captureCurrency = captureCurrency;
    }

    public Beneficiary sourceAmount(BigDecimal sourceAmount) {
        this.sourceAmount = sourceAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="sourceAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getSourceAmount() {
        return this.sourceAmount;
    }

    @JsonProperty(value="sourceAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceAmount(BigDecimal sourceAmount) {
        this.sourceAmount = sourceAmount;
    }

    public Beneficiary displayAmount(BigDecimal displayAmount) {
        this.displayAmount = displayAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="displayAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getDisplayAmount() {
        return this.displayAmount;
    }

    @JsonProperty(value="displayAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayAmount(BigDecimal displayAmount) {
        this.displayAmount = displayAmount;
    }

    public Beneficiary supplierAmount(BigDecimal supplierAmount) {
        this.supplierAmount = supplierAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="supplierAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getSupplierAmount() {
        return this.supplierAmount;
    }

    @JsonProperty(value="supplierAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierAmount(BigDecimal supplierAmount) {
        this.supplierAmount = supplierAmount;
    }

    public Beneficiary internalAmount(BigDecimal internalAmount) {
        this.internalAmount = internalAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="internalAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getInternalAmount() {
        return this.internalAmount;
    }

    @JsonProperty(value="internalAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalAmount(BigDecimal internalAmount) {
        this.internalAmount = internalAmount;
    }

    public Beneficiary captureAmount(BigDecimal captureAmount) {
        this.captureAmount = captureAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="captureAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getCaptureAmount() {
        return this.captureAmount;
    }

    @JsonProperty(value="captureAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCaptureAmount(BigDecimal captureAmount) {
        this.captureAmount = captureAmount;
    }

    public Beneficiary sourceAmountRefundModifier(BigDecimal sourceAmountRefundModifier) {
        this.sourceAmountRefundModifier = sourceAmountRefundModifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="sourceAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getSourceAmountRefundModifier() {
        return this.sourceAmountRefundModifier;
    }

    @JsonProperty(value="sourceAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceAmountRefundModifier(BigDecimal sourceAmountRefundModifier) {
        this.sourceAmountRefundModifier = sourceAmountRefundModifier;
    }

    public Beneficiary displayAmountRefundModifier(BigDecimal displayAmountRefundModifier) {
        this.displayAmountRefundModifier = displayAmountRefundModifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="displayAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getDisplayAmountRefundModifier() {
        return this.displayAmountRefundModifier;
    }

    @JsonProperty(value="displayAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayAmountRefundModifier(BigDecimal displayAmountRefundModifier) {
        this.displayAmountRefundModifier = displayAmountRefundModifier;
    }

    public Beneficiary supplierAmountRefundModifier(BigDecimal supplierAmountRefundModifier) {
        this.supplierAmountRefundModifier = supplierAmountRefundModifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="supplierAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getSupplierAmountRefundModifier() {
        return this.supplierAmountRefundModifier;
    }

    @JsonProperty(value="supplierAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierAmountRefundModifier(BigDecimal supplierAmountRefundModifier) {
        this.supplierAmountRefundModifier = supplierAmountRefundModifier;
    }

    public Beneficiary internalAmountRefundModifier(BigDecimal internalAmountRefundModifier) {
        this.internalAmountRefundModifier = internalAmountRefundModifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="internalAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getInternalAmountRefundModifier() {
        return this.internalAmountRefundModifier;
    }

    @JsonProperty(value="internalAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalAmountRefundModifier(BigDecimal internalAmountRefundModifier) {
        this.internalAmountRefundModifier = internalAmountRefundModifier;
    }

    public Beneficiary captureAmountRefundModifier(BigDecimal captureAmountRefundModifier) {
        this.captureAmountRefundModifier = captureAmountRefundModifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="captureAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getCaptureAmountRefundModifier() {
        return this.captureAmountRefundModifier;
    }

    @JsonProperty(value="captureAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCaptureAmountRefundModifier(BigDecimal captureAmountRefundModifier) {
        this.captureAmountRefundModifier = captureAmountRefundModifier;
    }

    public Beneficiary pendingRefunds(List<PendingRefund> pendingRefunds) {
        this.pendingRefunds = pendingRefunds;
        return this;
    }

    public Beneficiary addPendingRefundsItem(PendingRefund pendingRefundsItem) {
        if (this.pendingRefunds == null) {
            this.pendingRefunds = new ArrayList<PendingRefund>();
        }
        this.pendingRefunds.add(pendingRefundsItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="pendingRefunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PendingRefund> getPendingRefunds() {
        return this.pendingRefunds;
    }

    @JsonProperty(value="pendingRefunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPendingRefunds(List<PendingRefund> pendingRefunds) {
        this.pendingRefunds = pendingRefunds;
    }

    public Beneficiary metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Beneficiary putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public Beneficiary netCaptureAmount(BigDecimal netCaptureAmount) {
        this.netCaptureAmount = netCaptureAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getNetCaptureAmount() {
        return this.netCaptureAmount;
    }

    @JsonProperty(value="netCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetCaptureAmount(BigDecimal netCaptureAmount) {
        this.netCaptureAmount = netCaptureAmount;
    }

    public Beneficiary netSupplierAmount(BigDecimal netSupplierAmount) {
        this.netSupplierAmount = netSupplierAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getNetSupplierAmount() {
        return this.netSupplierAmount;
    }

    @JsonProperty(value="netSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetSupplierAmount(BigDecimal netSupplierAmount) {
        this.netSupplierAmount = netSupplierAmount;
    }

    public Beneficiary netSourceAmount(BigDecimal netSourceAmount) {
        this.netSourceAmount = netSourceAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getNetSourceAmount() {
        return this.netSourceAmount;
    }

    @JsonProperty(value="netSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetSourceAmount(BigDecimal netSourceAmount) {
        this.netSourceAmount = netSourceAmount;
    }

    public Beneficiary netDisplayAmount(BigDecimal netDisplayAmount) {
        this.netDisplayAmount = netDisplayAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getNetDisplayAmount() {
        return this.netDisplayAmount;
    }

    @JsonProperty(value="netDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetDisplayAmount(BigDecimal netDisplayAmount) {
        this.netDisplayAmount = netDisplayAmount;
    }

    public Beneficiary netInternalAmount(BigDecimal netInternalAmount) {
        this.netInternalAmount = netInternalAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getNetInternalAmount() {
        return this.netInternalAmount;
    }

    @JsonProperty(value="netInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetInternalAmount(BigDecimal netInternalAmount) {
        this.netInternalAmount = netInternalAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Beneficiary beneficiary = (Beneficiary)o;
        return Objects.equals(this.accountIdentifier, beneficiary.accountIdentifier) && Objects.equals(this.accountName, beneficiary.accountName) && Objects.equals(this.accountEmail, beneficiary.accountEmail) && Objects.equals(this.accountUrl, beneficiary.accountUrl) && Objects.equals((Object)this.type, (Object)beneficiary.type) && Objects.equals(this.amountDue, beneficiary.amountDue) && Objects.equals(this.sourceCurrency, beneficiary.sourceCurrency) && Objects.equals(this.displayCurrency, beneficiary.displayCurrency) && Objects.equals(this.supplierCurrency, beneficiary.supplierCurrency) && Objects.equals(this.internalCurrency, beneficiary.internalCurrency) && Objects.equals(this.captureCurrency, beneficiary.captureCurrency) && Objects.equals(this.sourceAmount, beneficiary.sourceAmount) && Objects.equals(this.displayAmount, beneficiary.displayAmount) && Objects.equals(this.supplierAmount, beneficiary.supplierAmount) && Objects.equals(this.internalAmount, beneficiary.internalAmount) && Objects.equals(this.captureAmount, beneficiary.captureAmount) && Objects.equals(this.sourceAmountRefundModifier, beneficiary.sourceAmountRefundModifier) && Objects.equals(this.displayAmountRefundModifier, beneficiary.displayAmountRefundModifier) && Objects.equals(this.supplierAmountRefundModifier, beneficiary.supplierAmountRefundModifier) && Objects.equals(this.internalAmountRefundModifier, beneficiary.internalAmountRefundModifier) && Objects.equals(this.captureAmountRefundModifier, beneficiary.captureAmountRefundModifier) && Objects.equals(this.pendingRefunds, beneficiary.pendingRefunds) && Objects.equals(this.metadata, beneficiary.metadata) && Objects.equals(this.netCaptureAmount, beneficiary.netCaptureAmount) && Objects.equals(this.netSupplierAmount, beneficiary.netSupplierAmount) && Objects.equals(this.netSourceAmount, beneficiary.netSourceAmount) && Objects.equals(this.netDisplayAmount, beneficiary.netDisplayAmount) && Objects.equals(this.netInternalAmount, beneficiary.netInternalAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountIdentifier, this.accountName, this.accountEmail, this.accountUrl, this.type, this.amountDue, this.sourceCurrency, this.displayCurrency, this.supplierCurrency, this.internalCurrency, this.captureCurrency, this.sourceAmount, this.displayAmount, this.supplierAmount, this.internalAmount, this.captureAmount, this.sourceAmountRefundModifier, this.displayAmountRefundModifier, this.supplierAmountRefundModifier, this.internalAmountRefundModifier, this.captureAmountRefundModifier, this.pendingRefunds, this.metadata, this.netCaptureAmount, this.netSupplierAmount, this.netSourceAmount, this.netDisplayAmount, this.netInternalAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Beneficiary {\n");
        sb.append("    accountIdentifier: ").append(this.toIndentedString(this.accountIdentifier)).append("\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    accountEmail: ").append(this.toIndentedString(this.accountEmail)).append("\n");
        sb.append("    accountUrl: ").append(this.toIndentedString(this.accountUrl)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    amountDue: ").append(this.toIndentedString(this.amountDue)).append("\n");
        sb.append("    sourceCurrency: ").append(this.toIndentedString(this.sourceCurrency)).append("\n");
        sb.append("    displayCurrency: ").append(this.toIndentedString(this.displayCurrency)).append("\n");
        sb.append("    supplierCurrency: ").append(this.toIndentedString(this.supplierCurrency)).append("\n");
        sb.append("    internalCurrency: ").append(this.toIndentedString(this.internalCurrency)).append("\n");
        sb.append("    captureCurrency: ").append(this.toIndentedString(this.captureCurrency)).append("\n");
        sb.append("    sourceAmount: ").append(this.toIndentedString(this.sourceAmount)).append("\n");
        sb.append("    displayAmount: ").append(this.toIndentedString(this.displayAmount)).append("\n");
        sb.append("    supplierAmount: ").append(this.toIndentedString(this.supplierAmount)).append("\n");
        sb.append("    internalAmount: ").append(this.toIndentedString(this.internalAmount)).append("\n");
        sb.append("    captureAmount: ").append(this.toIndentedString(this.captureAmount)).append("\n");
        sb.append("    sourceAmountRefundModifier: ").append(this.toIndentedString(this.sourceAmountRefundModifier)).append("\n");
        sb.append("    displayAmountRefundModifier: ").append(this.toIndentedString(this.displayAmountRefundModifier)).append("\n");
        sb.append("    supplierAmountRefundModifier: ").append(this.toIndentedString(this.supplierAmountRefundModifier)).append("\n");
        sb.append("    internalAmountRefundModifier: ").append(this.toIndentedString(this.internalAmountRefundModifier)).append("\n");
        sb.append("    captureAmountRefundModifier: ").append(this.toIndentedString(this.captureAmountRefundModifier)).append("\n");
        sb.append("    pendingRefunds: ").append(this.toIndentedString(this.pendingRefunds)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    netCaptureAmount: ").append(this.toIndentedString(this.netCaptureAmount)).append("\n");
        sb.append("    netSupplierAmount: ").append(this.toIndentedString(this.netSupplierAmount)).append("\n");
        sb.append("    netSourceAmount: ").append(this.toIndentedString(this.netSourceAmount)).append("\n");
        sb.append("    netDisplayAmount: ").append(this.toIndentedString(this.netDisplayAmount)).append("\n");
        sb.append("    netInternalAmount: ").append(this.toIndentedString(this.netInternalAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        COMMISSION("COMMISSION"),
        PLATFORM_FEE("PLATFORM_FEE"),
        TRIP_PAY("TRIP_PAY"),
        SALE("SALE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

