/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 29.24.2
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.Acquirer;
import io.trippay.sdk.payment.model.UpsertBankAccountRequest;
import io.trippay.sdk.payment.model.UpsertCityOnlyAddressRequest;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CreateAccountRequest
 */
@JsonPropertyOrder({
  CreateAccountRequest.JSON_PROPERTY_EXTERNAL_IDENTIFIER,
  CreateAccountRequest.JSON_PROPERTY_TYPE,
  CreateAccountRequest.JSON_PROPERTY_OWNER_TYPE,
  CreateAccountRequest.JSON_PROPERTY_NAME,
  CreateAccountRequest.JSON_PROPERTY_LEGAL_NAME,
  CreateAccountRequest.JSON_PROPERTY_USER_IDENTIFIER,
  CreateAccountRequest.JSON_PROPERTY_ACCOUNT_EMAIL,
  CreateAccountRequest.JSON_PROPERTY_ACCOUNT_PHONE_NUMBER,
  CreateAccountRequest.JSON_PROPERTY_DESCRIPTION,
  CreateAccountRequest.JSON_PROPERTY_URL,
  CreateAccountRequest.JSON_PROPERTY_CURRENCY_CODE,
  CreateAccountRequest.JSON_PROPERTY_ADDRESS,
  CreateAccountRequest.JSON_PROPERTY_ACQUIRERS,
  CreateAccountRequest.JSON_PROPERTY_BANK_ACCOUNTS,
  CreateAccountRequest.JSON_PROPERTY_OWNER_TYPE_IDENTIFIER,
  CreateAccountRequest.JSON_PROPERTY_DOB,
  CreateAccountRequest.JSON_PROPERTY_DISBURSEMENT_TYPE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-28T12:45:52.502731781+07:00[Asia/Bangkok]")
public class CreateAccountRequest {
  public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
  private String externalIdentifier;

  /**
   * Type of account tells us what the account is capable of.
   */
  public enum TypeEnum {
    MERCHANT("MERCHANT"),
    
    AFFILIATE("AFFILIATE"),
    
    AGENT("AGENT"),
    
    FACILITATOR("FACILITATOR"),
    
    RATE_PROVIDER("RATE_PROVIDER"),
    
    TRIP_PAY("TRIP_PAY");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  /**
   * Type of account owner tells us whether ths account is managed by a company or an individual.
   */
  public enum OwnerTypeEnum {
    COMPANY("COMPANY"),
    
    INDIVIDUAL("INDIVIDUAL");

    private String value;

    OwnerTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OwnerTypeEnum fromValue(String value) {
      for (OwnerTypeEnum b : OwnerTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
  private OwnerTypeEnum ownerType;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_LEGAL_NAME = "legalName";
  private String legalName;

  public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
  private UUID userIdentifier;

  public static final String JSON_PROPERTY_ACCOUNT_EMAIL = "accountEmail";
  private String accountEmail;

  public static final String JSON_PROPERTY_ACCOUNT_PHONE_NUMBER = "accountPhoneNumber";
  private String accountPhoneNumber;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_URL = "url";
  private String url;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private UpsertCityOnlyAddressRequest address;

  public static final String JSON_PROPERTY_ACQUIRERS = "acquirers";
  private List<Acquirer> acquirers;

  public static final String JSON_PROPERTY_BANK_ACCOUNTS = "bankAccounts";
  private List<UpsertBankAccountRequest> bankAccounts;

  public static final String JSON_PROPERTY_OWNER_TYPE_IDENTIFIER = "ownerTypeIdentifier";
  private String ownerTypeIdentifier;

  public static final String JSON_PROPERTY_DOB = "dob";
  private LocalDate dob;

  /**
   * The method which the account holder wishes to be paid.
   */
  public enum DisbursementTypeEnum {
    VIRTUAL_CREDIT_CARD("VIRTUAL_CREDIT_CARD"),
    
    BANK_TRANSFER("BANK_TRANSFER");

    private String value;

    DisbursementTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DisbursementTypeEnum fromValue(String value) {
      for (DisbursementTypeEnum b : DisbursementTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DISBURSEMENT_TYPE = "disbursementType";
  private DisbursementTypeEnum disbursementType;

  public CreateAccountRequest() {
  }

  public CreateAccountRequest externalIdentifier(String externalIdentifier) {
    
    this.externalIdentifier = externalIdentifier;
    return this;
  }

   /**
   * Unique external record identifier
   * @return externalIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalIdentifier() {
    return externalIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalIdentifier(String externalIdentifier) {
    this.externalIdentifier = externalIdentifier;
  }


  public CreateAccountRequest type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of account tells us what the account is capable of.
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public CreateAccountRequest ownerType(OwnerTypeEnum ownerType) {
    
    this.ownerType = ownerType;
    return this;
  }

   /**
   * Type of account owner tells us whether ths account is managed by a company or an individual.
   * @return ownerType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_OWNER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OwnerTypeEnum getOwnerType() {
    return ownerType;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerType(OwnerTypeEnum ownerType) {
    this.ownerType = ownerType;
  }


  public CreateAccountRequest name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of company / full name of person
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public CreateAccountRequest legalName(String legalName) {
    
    this.legalName = legalName;
    return this;
  }

   /**
   * Legal name of entity if other than name
   * @return legalName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLegalName() {
    return legalName;
  }


  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalName(String legalName) {
    this.legalName = legalName;
  }


  public CreateAccountRequest userIdentifier(UUID userIdentifier) {
    
    this.userIdentifier = userIdentifier;
    return this;
  }

   /**
   * The authenticated user that owns this account.
   * @return userIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getUserIdentifier() {
    return userIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserIdentifier(UUID userIdentifier) {
    this.userIdentifier = userIdentifier;
  }


  public CreateAccountRequest accountEmail(String accountEmail) {
    
    this.accountEmail = accountEmail;
    return this;
  }

   /**
   * Account email is where we will send KYC documents and other account specific mailings
   * @return accountEmail
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ACCOUNT_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAccountEmail() {
    return accountEmail;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAccountEmail(String accountEmail) {
    this.accountEmail = accountEmail;
  }


  public CreateAccountRequest accountPhoneNumber(String accountPhoneNumber) {
    
    this.accountPhoneNumber = accountPhoneNumber;
    return this;
  }

   /**
   * Account phone number is mostly used for KYC purchases
   * @return accountPhoneNumber
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ACCOUNT_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccountPhoneNumber() {
    return accountPhoneNumber;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountPhoneNumber(String accountPhoneNumber) {
    this.accountPhoneNumber = accountPhoneNumber;
  }


  public CreateAccountRequest description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Short company / person description.
   * @return description
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescription(String description) {
    this.description = description;
  }


  public CreateAccountRequest url(String url) {
    
    this.url = url;
    return this;
  }

   /**
   * Company website. If private person with no personal website, link to main social network account.
   * @return url
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getUrl() {
    return url;
  }


  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUrl(String url) {
    this.url = url;
  }


  public CreateAccountRequest currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Account&#39;s main currency.
   * @return currencyCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=3,max=3)
  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }


  public CreateAccountRequest address(UpsertCityOnlyAddressRequest address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UpsertCityOnlyAddressRequest getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(UpsertCityOnlyAddressRequest address) {
    this.address = address;
  }


  public CreateAccountRequest acquirers(List<Acquirer> acquirers) {
    
    this.acquirers = acquirers;
    return this;
  }

  public CreateAccountRequest addAcquirersItem(Acquirer acquirersItem) {
    if (this.acquirers == null) {
      this.acquirers = new ArrayList<>();
    }
    this.acquirers.add(acquirersItem);
    return this;
  }

   /**
   * Get acquirers
   * @return acquirers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ACQUIRERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Acquirer> getAcquirers() {
    return acquirers;
  }


  @JsonProperty(JSON_PROPERTY_ACQUIRERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAcquirers(List<Acquirer> acquirers) {
    this.acquirers = acquirers;
  }


  public CreateAccountRequest bankAccounts(List<UpsertBankAccountRequest> bankAccounts) {
    
    this.bankAccounts = bankAccounts;
    return this;
  }

  public CreateAccountRequest addBankAccountsItem(UpsertBankAccountRequest bankAccountsItem) {
    if (this.bankAccounts == null) {
      this.bankAccounts = new ArrayList<>();
    }
    this.bankAccounts.add(bankAccountsItem);
    return this;
  }

   /**
   * Get bankAccounts
   * @return bankAccounts
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<UpsertBankAccountRequest> getBankAccounts() {
    return bankAccounts;
  }


  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBankAccounts(List<UpsertBankAccountRequest> bankAccounts) {
    this.bankAccounts = bankAccounts;
  }


  public CreateAccountRequest ownerTypeIdentifier(String ownerTypeIdentifier) {
    
    this.ownerTypeIdentifier = ownerTypeIdentifier;
    return this;
  }

   /**
   * This is the tax identification number (TIN) for individuals and entity identification number (EIN) for companies.
   * @return ownerTypeIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OWNER_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOwnerTypeIdentifier() {
    return ownerTypeIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerTypeIdentifier(String ownerTypeIdentifier) {
    this.ownerTypeIdentifier = ownerTypeIdentifier;
  }


  public CreateAccountRequest dob(LocalDate dob) {
    
    this.dob = dob;
    return this;
  }

   /**
   * This is the individual&#39;s date of birth.
   * @return dob
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DOB)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getDob() {
    return dob;
  }


  @JsonProperty(JSON_PROPERTY_DOB)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDob(LocalDate dob) {
    this.dob = dob;
  }


  public CreateAccountRequest disbursementType(DisbursementTypeEnum disbursementType) {
    
    this.disbursementType = disbursementType;
    return this;
  }

   /**
   * The method which the account holder wishes to be paid.
   * @return disbursementType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISBURSEMENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DisbursementTypeEnum getDisbursementType() {
    return disbursementType;
  }


  @JsonProperty(JSON_PROPERTY_DISBURSEMENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisbursementType(DisbursementTypeEnum disbursementType) {
    this.disbursementType = disbursementType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateAccountRequest createAccountRequest = (CreateAccountRequest) o;
    return Objects.equals(this.externalIdentifier, createAccountRequest.externalIdentifier) &&
        Objects.equals(this.type, createAccountRequest.type) &&
        Objects.equals(this.ownerType, createAccountRequest.ownerType) &&
        Objects.equals(this.name, createAccountRequest.name) &&
        Objects.equals(this.legalName, createAccountRequest.legalName) &&
        Objects.equals(this.userIdentifier, createAccountRequest.userIdentifier) &&
        Objects.equals(this.accountEmail, createAccountRequest.accountEmail) &&
        Objects.equals(this.accountPhoneNumber, createAccountRequest.accountPhoneNumber) &&
        Objects.equals(this.description, createAccountRequest.description) &&
        Objects.equals(this.url, createAccountRequest.url) &&
        Objects.equals(this.currencyCode, createAccountRequest.currencyCode) &&
        Objects.equals(this.address, createAccountRequest.address) &&
        Objects.equals(this.acquirers, createAccountRequest.acquirers) &&
        Objects.equals(this.bankAccounts, createAccountRequest.bankAccounts) &&
        Objects.equals(this.ownerTypeIdentifier, createAccountRequest.ownerTypeIdentifier) &&
        Objects.equals(this.dob, createAccountRequest.dob) &&
        Objects.equals(this.disbursementType, createAccountRequest.disbursementType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(externalIdentifier, type, ownerType, name, legalName, userIdentifier, accountEmail, accountPhoneNumber, description, url, currencyCode, address, acquirers, bankAccounts, ownerTypeIdentifier, dob, disbursementType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateAccountRequest {\n");
    sb.append("    externalIdentifier: ").append(toIndentedString(externalIdentifier)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    ownerType: ").append(toIndentedString(ownerType)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    legalName: ").append(toIndentedString(legalName)).append("\n");
    sb.append("    userIdentifier: ").append(toIndentedString(userIdentifier)).append("\n");
    sb.append("    accountEmail: ").append(toIndentedString(accountEmail)).append("\n");
    sb.append("    accountPhoneNumber: ").append(toIndentedString(accountPhoneNumber)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    acquirers: ").append(toIndentedString(acquirers)).append("\n");
    sb.append("    bankAccounts: ").append(toIndentedString(bankAccounts)).append("\n");
    sb.append("    ownerTypeIdentifier: ").append(toIndentedString(ownerTypeIdentifier)).append("\n");
    sb.append("    dob: ").append(toIndentedString(dob)).append("\n");
    sb.append("    disbursementType: ").append(toIndentedString(disbursementType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

