/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;
import io.trippay.sdk.payment.model.ExternalEvent;
import io.trippay.sdk.payment.model.PageExternalEvent;
import io.trippay.sdk.payment.model.State;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ExternalEventApi {
    private ApiClient apiClient;

    public ExternalEventApi() {
        this(new ApiClient());
    }

    @Autowired
    public ExternalEventApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec showExternalEventRequestCreation(String eventIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (eventIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'eventIdentifier' when calling showExternalEvent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("eventIdentifier", eventIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ExternalEvent> localVarReturnType = new ParameterizedTypeReference<ExternalEvent>(this){};
        return this.apiClient.invokeAPI("/api/administration/external-event/{eventIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ExternalEvent> showExternalEvent(String eventIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ExternalEvent> localVarReturnType = new ParameterizedTypeReference<ExternalEvent>(this){};
        return this.showExternalEventRequestCreation(eventIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ExternalEvent>> showExternalEventWithHttpInfo(String eventIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ExternalEvent> localVarReturnType = new ParameterizedTypeReference<ExternalEvent>(this){};
        return this.showExternalEventRequestCreation(eventIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showExternalEventWithResponseSpec(String eventIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showExternalEventRequestCreation(eventIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showExternalEventGridRequestCreation(State state, String winkVersion) throws WebClientResponseException {
        State postBody = state;
        if (state == null) {
            throw new WebClientResponseException("Missing the required parameter 'state' when calling showExternalEventGrid", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageExternalEvent> localVarReturnType = new ParameterizedTypeReference<PageExternalEvent>(this){};
        return this.apiClient.invokeAPI("/api/administration/external-event/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageExternalEvent> showExternalEventGrid(State state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageExternalEvent> localVarReturnType = new ParameterizedTypeReference<PageExternalEvent>(this){};
        return this.showExternalEventGridRequestCreation(state, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageExternalEvent>> showExternalEventGridWithHttpInfo(State state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageExternalEvent> localVarReturnType = new ParameterizedTypeReference<PageExternalEvent>(this){};
        return this.showExternalEventGridRequestCreation(state, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showExternalEventGridWithResponseSpec(State state, String winkVersion) throws WebClientResponseException {
        return this.showExternalEventGridRequestCreation(state, winkVersion);
    }

    private WebClient.ResponseSpec showExternalEventListRequestCreation(String entityIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (entityIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'entityIdentifier' when calling showExternalEventList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("entityIdentifier", entityIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ExternalEvent> localVarReturnType = new ParameterizedTypeReference<ExternalEvent>(this){};
        return this.apiClient.invokeAPI("/api/administration/external-event/{entityIdentifier}/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<ExternalEvent> showExternalEventList(String entityIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ExternalEvent> localVarReturnType = new ParameterizedTypeReference<ExternalEvent>(this){};
        return this.showExternalEventListRequestCreation(entityIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<ExternalEvent>>> showExternalEventListWithHttpInfo(String entityIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ExternalEvent> localVarReturnType = new ParameterizedTypeReference<ExternalEvent>(this){};
        return this.showExternalEventListRequestCreation(entityIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showExternalEventListWithResponseSpec(String entityIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showExternalEventListRequestCreation(entityIdentifier, winkVersion);
    }
}

